// -*- mode:c++; indent-tabs-moe:nil; tab-width:2; -*-
//
// $Id: UssIOBuffer_Queue.cpp,v 1.1 2001/07/24 07:29:11 seagull Exp $
//

#include "UssIOBuffer.h"

IUssIOPacketBase::IUssIOPacketBase()
{
  m_pNext = NULL;
}


IUssIOPacketBase::~IUssIOPacketBase()
{
}

void
IUssIOPacketBase::onSendStart()
{
}


void
IUssIOPacketBase::onSendFinish()
{
}





UssIOPacket::UssIOPacket(uint8_t* p, int len)
{
  m_pBuffer = new uint8_t[len];
  memcpy(m_pBuffer, p, len);
  m_len = len;
}


UssIOPacket::~UssIOPacket()
{
}


unsigned int
UssIOPacket::doSend(IUssIO* io, unsigned int offset)
{
  return io->write(m_pBuffer + offset, m_len - offset);
}



unsigned int
UssIOPacket::getLength()
{
  return m_len;
}






UssIOBuffer_Queue::UssIOBuffer_Queue()
{
  m_pHead = NULL;
  m_pTail = NULL;
  m_nCurrOffset = 0;
}




UssIOBuffer_Queue::~UssIOBuffer_Queue()
{
  reset();
}



void
UssIOBuffer_Queue::reset()
{
  while (m_pHead)
  {
    IUssIOPacketBase* p = m_pHead;
    m_pHead = m_pHead->m_pNext;
    delete p;
  }
  m_pHead = NULL;
  m_pTail = NULL;
  m_nCurrOffset = 0;
}




int
UssIOBuffer_Queue::read(void* buf, int len)
{
  // no implemented yet.
  return 0;
}



int
UssIOBuffer_Queue::write(void const* buf, int len)
{
  UssIOPacket* packet = new UssIOPacket(static_cast<uint8_t*>(buf), len);
  return write(packet);
}



int
UssIOBuffer_Queue::write(IUssIOPacketBase* packet)
{
  // 塼ɲ
  if (m_pTail == NULL)
    m_pHead = packet;
  else
    m_pTail->m_pNext = packet;
  m_pTail = packet;
  
  return packet->getLength();
}

size_t
UssIOBuffer_Queue::getBufferSize() const
{
  return 0;
}

size_t
UssIOBuffer_Queue::getFreeSize() const
{
  return 0;
}


size_t
UssIOBuffer_Queue::getUsedSize() const
{
  return UINT_MAX;
}

bool
UssIOBuffer_Queue::isEmpty() const
{
  return m_pHead == NULL;
}

bool
UssIOBuffer_Queue::isFull() const
{
  return false;
}



int
UssIOBuffer_Queue::flush()
{
  testRedirected();
  
  if (m_pHead == NULL)
    return 0;
  
  int n;
  
  m_nCurrOffset += (n = m_pHead->doSend(getRedirectTo(), m_nCurrOffset));
  if (m_nCurrOffset >= m_pHead->getLength())
  {
    IUssIOPacketBase* p = m_pHead;
    
    // ݥ󥿤򼡤ΥѥåȤش
    m_nCurrOffset = 0;
    m_pHead = m_pHead->m_pNext;
    
    // 塼ˤʤä顢ݥ󥿤
    if (m_pHead == NULL)
      m_pTail = NULL;
    
    // 꽪äѥåȤ˴
    delete p;
  }
  
  return n;
}


int
UssIOBuffer_Queue::fetch()
{
  return 0;
}



bool
UssIOBuffer_Queue::lookAhead(int offset, uint8_t* p)
{
  return false;
}

  

