﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;



public class pinSpawner : MonoBehaviour {

    //ピンの間隔(基準値)
    const float PIN_SPACE = 18.5f;
    //判定開始から次の投球への開始が確定するまでの時間
    const float TURN_END_TIME = 10.0f;

    [SerializeField]
    GameObject pinPrefab;
    [SerializeField]
    GameObject ballObj;
    [SerializeField]
    GameRuler Ruler;

    //ピンの数を常にカウントし続ける
    [SerializeField]
    int nNumStandPin;
    int nOldStandPin;
    [SerializeField]
    int nNumKnocdownPin;

    [SerializeField]
    Vector3 PinSetPos;
    [SerializeField]
    int nNextPin;


    float fDetectStart;
    float fDetectEnd;
    [SerializeField]
    bool bTurnCheck;
    [SerializeField]
    bool bNextTurn;

    float fPosZ_LastColum;

	// Use this for initialization
	void Start () {
        nNumStandPin = 0;
        nOldStandPin = 0;
        nNumKnocdownPin = 0;
        fPosZ_LastColum = 0.0f;

        if (nNextPin == 0)
        {
            nNextPin = 10;
        }
        ResetAllFrag();

        SetPin(nNextPin);

	}

    // Update is called once per frame
    void Update()
    {
        if(Input.GetKey(KeyCode.S)){
            Strike();
        }

        //立っている本数を数える
        CountStandPin();

        //次の投球に移るかどうかの判定
        CheckPinMovement();

       //if (Input.GetKey(KeyCode.Space))
       //{
       //    //倒れているピンを取り除き、他を再配置
       //    RemovePin();
       //}

       //if (Input.GetKey(KeyCode.A))
       //{
       //    //ピンの再配置
       //    RespawnPin();
       //}

	}

    void ResetAllFrag() {
        bTurnCheck = false;
        bNextTurn = false;
        fDetectStart = 0.0f;
        fDetectEnd = 0.0f;
    }

    public void RespawnPin() {
        //現在あるピンを全て消してからピンを再配置
        DeleatePin();
        SetPin(nNextPin);
        ResetAllFrag();
    }

    void SetPin(int nNumPin)
    {
        float pin_space = PIN_SPACE / 20.0f;

        int nLine;
        int nCntPin = 0;
        float z = 0.0f;
        for (nLine = 0; nCntPin < nNumPin; nLine++)
        {
            //三平方
            z = nLine * Mathf.Sqrt(3) * pin_space * 0.5f;
            for (int nLinepin = 0; nLinepin <= nLine ; nLinepin++, nCntPin++)
            {
                if (nCntPin >= nNumPin) break;

                GameObject pinObj = (GameObject)Instantiate(pinPrefab);
                pinObj.transform.parent = transform;
                Vector3 pinPos = new Vector3(PinSetPos.x + nLine * (pin_space * 0.5f) - pin_space * nLinepin, PinSetPos.y + 1.0f, PinSetPos.z + z);
                pinObj.transform.position = pinPos;

                pinObj.transform.localScale = new Vector3(3.0f, 3.0f, 3.0f);
            }
        }
        fPosZ_LastColum = z;

        SetPinID();
    }

    void SetPinID() {
        foreach (var obj in GetComponentsInChildren<pinScript>()) {
            //各ピンにIDを割り振る
            int nID = obj.transform.GetSiblingIndex();
            obj.SetID(nID);
        }
    }

    void DeleatePin() {
        foreach (var obj in GetComponentsInChildren<pinScript>()) {
            Destroy(obj.gameObject);
        }
    }

    void CountStandPin() {
        nOldStandPin = nNumStandPin;
        //リセット
        nNumStandPin = 0;
        nNumKnocdownPin = 0;
        foreach (var obj in GetComponentsInChildren<pinScript>()) {
            //各ピンが立っているかチェック
            if (obj.GetStandFrag()) {
                nNumStandPin++;
            }
            else {
                nNumKnocdownPin++;

                //ピンが倒れたのを検出、投球の終了チェック開始フラグオン
                bTurnCheck = true;
            }
        }
    }


    //1投してピンが残っている場合この関数を呼ぶ
    void RemovePin() {
        foreach (var obj in GetComponentsInChildren<pinScript>())
        {
            //各ピンが立っているかチェック
            if (!obj.GetStandFrag()) {
                //立っていなかったら殺す
                Destroy(obj.gameObject);
            }
            else {
                //立っているなら位置修正
                obj.FixedPosition();
            }
        }
        ResetAllFrag();
    }

    void CheckPinMovement() {

        if (bNextTurn) {
            //既に次の投球へ移行
            Ruler.NextTurn();
        }

        //チェックがオフの時だけ
        if (!bTurnCheck)
        {
            //ボールが一番後ろのピンが置かれているZ座標を超えたとき
            if (ballObj.transform.position.z > fPosZ_LastColum)
            {
                bTurnCheck = true;

                //時間をそろえる
                fDetectStart = Time.realtimeSinceStartup;
                fDetectEnd = Time.realtimeSinceStartup;
            }
        }
        else {

            //倒れた数が変わらない
            if (nNumStandPin == nOldStandPin)
            {
                //時間を更新していく
                fDetectEnd = Time.realtimeSinceStartup;
            }
            else {
                //時間をそろえる
                fDetectStart = Time.realtimeSinceStartup;
                fDetectEnd = Time.realtimeSinceStartup;
            }

            if (fDetectEnd - fDetectStart >= TURN_END_TIME)
            {
                bNextTurn = true;
            }
        }
    }

    public int GetCollapsedPins()
    {
        return nNumKnocdownPin;
    }

    public int GetStandPins()
    {
        return nNumStandPin;
    }

    public void RelovatePin()
    {
        if (nNumStandPin == 0)//ターン数を拾ってくる
        {//全消去全配置
            RespawnPin();
        }
        else
        {//倒れてるの除去
            RemovePin();
        }
    }



    void Strike() {
        foreach (var obj in GetComponentsInChildren<pinScript>())
        {
            obj.transform.rotation = Quaternion.Euler(90.0f,0.0f,0.0f);
        }
    }
}
