﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class pinScript : MonoBehaviour {
    [SerializeField]
    bool bStand;

    [SerializeField]
    int nID;

    Vector3 fixPos;
    Vector3 fixRot;

    [SerializeField]
    Vector3 vecUp;

    [SerializeField]
    float fAngle;

    Rigidbody rigidbody;

    float PIN_LYING_DEGREE = 10.0f;


	// Use this for initialization
	void Start () {
        rigidbody = this.GetComponent<Rigidbody> ();
        bStand = true;
        vecUp = Vector3.up;
        fixPos = this.transform.position;

    }
	
	// Update is called once per frame
    void Update()
    {

            if (bStand) {
                bStand = !checkStand();
            }
	}

    bool checkStand() {
        //上方向と現在の上方向の角度差を算出
        fAngle = Vector3.Angle(Vector3.up, rigidbody.transform.rotation * Vector3.up);

        //fLying以上傾いてるときtrue
        if (fAngle > PIN_LYING_DEGREE)
        {
            return true;   //倒れている
        }
        return false;
    }

    public void SetID(int id) {
        nID = id;
    }

    public bool GetStandFrag() {
        return bStand;
    }

    public void FixedPosition() {
        this.transform.position = fixPos;
        this.transform.rotation = Quaternion.Euler(0.0f, 0.0f, 0.0f);
        this.rigidbody.angularVelocity = fixRot;
        this.rigidbody.velocity = Vector3.zero;
    }

    public void SetCollapsPin(bool b) {
        bStand = b;
    }
}
