﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class OptionController : MonoBehaviour {


    public float hSliderValue = 0.0f;
    float moveHeightPercentage;
    float playerPower;

    [SerializeField]
    GameParameter gameParameter;

    [SerializeField]
    InputManager inputManager;

    [SerializeField]
    Button closeWidgetButton; 

    [SerializeField]
    AudioClip audio;

	// Use this for initialization
	void Start () {

        moveHeightPercentage = gameParameter.HeightScrollPercentage;
        playerPower = gameParameter.PlayerPower;

        inputManager.SetExecInputOpenOptionWindow(ShowWidget);
        closeWidgetButton.onClick.AddListener(CloseWidget);

        CloseWidget();
		
	}
	
	// Update is called once per frame
	void Update () {

        gameParameter.HeightScrollPercentage = moveHeightPercentage;
        gameParameter.PlayerPower = playerPower;
		
	}
    
    void OnGUI () {

        GUI.Label(new Rect(20, 150, 200, 20), "MoveHightPercentage :" + moveHeightPercentage);
        moveHeightPercentage = GUI.HorizontalSlider(new Rect(40, 170, 150, 30), moveHeightPercentage, 0.0f, 1.0f);

        GUI.Label(new Rect(20, 190, 100, 20), "PlayerPower:" + playerPower);
        playerPower = GUI.HorizontalSlider(new Rect(40, 210, 150, 30), playerPower, 0.0f, 500.0f);

        GUI.Label(new Rect(20, 230, 100, 20), "Volume :" + hSliderValue);
        hSliderValue = GUI.HorizontalSlider(new Rect(40, 250, 150, 30), hSliderValue, 0.0f, 1.0f);

    }

    public void ShowWidget()
    {
        this.gameObject.SetActive(true);
    }

    void CloseWidget()
    {
        this.gameObject.SetActive(false);  
    }

}
