﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class InputManager : MonoBehaviour {

    enum InputType
    {

        PC_INPUT = 0,
        MOBILE_INPUT

    };

    public delegate void InputMethod();
    public delegate void InputMethodFromForce(Vector3 force);

    [SerializeField]
    InputType type;

    [SerializeField]
    VectorSaver vectorSaver; 

    private MonoBehaviour input;


	// Use this for initialization
	void Awake () {

        if (type == InputType.PC_INPUT)
        {
            input = gameObject.AddComponent<PCInput>()as PCInput;
        }
        else if (type == InputType.MOBILE_INPUT)
        {
            input = gameObject.AddComponent<MobileInput>()as MobileInput;
        }

        Debug.Log("inputObjectを生成しました。");

    }
	
	// Update is called once per frame
	void Update () {

      //input.
        SaveMousePosition();
		
	}


    void SaveMousePosition()
    {
        vectorSaver.SavePosition(Input.mousePosition);
    }

    public Vector3 GetFlickDirection() {

        var direction = vectorSaver.GetDirection();

        float save = direction.y;
        direction.y = direction.z;
        direction.z = save;

        return direction;
    }

    public void SetExecInputPressMethod(InputMethod method)
    {


        if (type == InputType.PC_INPUT)
        {
            var inputObject = GetComponent<PCInput>();
            inputObject.inputPress = () => method();
        }
        else if (type == InputType.MOBILE_INPUT)
        {
            var inputObject = GetComponent<MobileInput>();
            inputObject.inputPress = () => method();
        }
        Debug.Log("Callback SetExecInputPressMethod");
    }

    public void SetExecInputDownMethod(InputMethod method)
    {


        if (type == InputType.PC_INPUT)
        {
            var inputObject = GetComponent<PCInput>();
            inputObject.inputDown = () => method();
        }
        else if (type == InputType.MOBILE_INPUT)
        {
            var inputObject = GetComponent<MobileInput>();
            inputObject.inputDown = () => method();
        }
        Debug.Log("Callback SetExecInputDownMethod");
    }

    public void SetExecInputReleaseMethod(InputMethod method)
    {


        if (type == InputType.PC_INPUT)
        {
            var inputObject = GetComponent<PCInput>();
            inputObject.inputRelease = () => method();
        }
        else if (type == InputType.MOBILE_INPUT)
        {
            var inputObject = GetComponent<MobileInput>();
            inputObject.inputRelease = () => method();
        }
        Debug.Log("Callback SetExecInputReleaseMethod");
    }

    public void SetExecInputDeathBlowMethod(InputMethod method)
    {


        if (type == InputType.PC_INPUT)
        {
            var inputObject = GetComponent<PCInput>();
            inputObject.inputDeathBlow = () => method();
        }
        else if (type == InputType.MOBILE_INPUT)
        {
            var inputObject = GetComponent<MobileInput>();
            inputObject.inputDeathBlow = () => method();
        }
        Debug.Log("Callback SetExecInputReleaseMethod");
    }

    public void SetExecInputOpenOptionWindow(InputMethod method)
    {


        if (type == InputType.PC_INPUT)
        {
            var inputObject = GetComponent<PCInput>();
            inputObject.inputOpenOptionWindow = () => method();
        }
        else if (type == InputType.MOBILE_INPUT)
        {
            var inputObject = GetComponent<MobileInput>();
            inputObject.inputOpenOptionWindow = () => method();
        }
        Debug.Log("Callback SetExecInputReleaseMethod");
    }

}
