﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GameRuler : MonoBehaviour {


    [SerializeField]
    GameParameter gameParameter;

    [SerializeField]
    GameObject ballObj;
    Vector3 BallRepopPos;

    [SerializeField]
    pinSpawner spawner;

	// Use this for initialization
	void Start () {

        BallRepopPos = ballObj.transform.position;

	}
	
	// Update is called once per frame
	void Update () {
	   

	}

    public void CalculateUserScore(int pins)
    {
        if (spawner.GetStandPins() == 0) //
        {
            if (gameParameter.throwCount == 0)
            {
                // ストライク
                gameParameter.bowlingParamas[gameParameter.GameRound] = GameParameter.BowlingParam.Strike;
                Debug.Log("ストライク");
            }
            else
            {
                // スペア
                gameParameter.bowlingParamas[gameParameter.GameRound] = GameParameter.BowlingParam.Spare;
                Debug.Log("スペア");
            }
        }
        else
        {
            gameParameter.bowlingParamas[gameParameter.GameRound] = GameParameter.BowlingParam.Default;
        }

        { // 得点計算

            // 開始ラウンドでは、特殊点計算は行わない。
            if (gameParameter.GameStartRound != gameParameter.GameRound)
            {
                // ストライク時の得点計算
                if (GameParameter.BowlingParam.Strike == gameParameter.bowlingParamas[gameParameter.GameRound - 1])
                {
                    Debug.Log("ストライク時の得点計算");
                    if (gameParameter.GameStartRound != gameParameter.GameRound-1){

                        if (GameParameter.BowlingParam.Strike == gameParameter.bowlingParamas[gameParameter.GameRound - 2])
                        {
                            if (gameParameter.throwCount == 0)
                            {
                                gameParameter.AddScore(pins);
                            }
                        }
                    }
                    gameParameter.AddScore(pins);
                }
                // スペア時の得点計算
                if (GameParameter.BowlingParam.Spare == gameParameter.bowlingParamas[gameParameter.GameRound - 1])
                {
                    Debug.Log("スペア時の得点計算");
                    if (gameParameter.throwCount == 0)
                    {
                        gameParameter.AddScore(pins);
                    }
                }
            }
            gameParameter.AddScore(pins);
        };
    }

    void InitializeTurn()
    {
        gameParameter.throwCount = 0;
    }

    void InitializeRound()
    {
        gameParameter.GameRound = 0;
    }

    public void NextTurn() {
        CalculateUserScore(spawner.GetCollapsedPins());
        gameParameter.throwCount++;
        if (gameParameter.throwCount >= gameParameter.RoundThrowNumber || GameParameter.BowlingParam.Strike == gameParameter.bowlingParamas[gameParameter.GameRound])
        {
            NextRound();
        }
        else {
            spawner.RelovatePin();
        }
        RepopBall();

    }

    void NextRound() {
        InitializeTurn();
        gameParameter.GameRound++;
        if (gameParameter.GameRound >= gameParameter.MaxGameRound) {
            // ゲーム終了処理
            Debug.Log("ゲーム終了");
        }
        spawner.RespawnPin();
    }

    void RepopBall() {
        //ボール再配置
        ballObj.transform.position = BallRepopPos;
        ballObj.transform.rotation = Quaternion.Euler(0.0f, 0.0f, 0.0f);
        //移動量も殺す
        Rigidbody ballRigi = ballObj.GetComponent<Rigidbody>();
        ballRigi.angularVelocity = new Vector3(0.0f, 0.0f, 0.0f);
        ballRigi.velocity = Vector3.zero;
    }

}
