﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GameParameter : MonoBehaviour {

    public enum BowlingParam
    {
        Default = 0,
        Spare,
        Strike
    };

    // GameParameter.
    public int GameRound = 10;
    public int GameStartRound;
    public int throwCount = 0;
    public int RoundThrowNumber = 2;
    public int MaxGameRound = 10;

    // UserParameter.
    public Dictionary<int, BowlingParam> bowlingParamas = new Dictionary<int,BowlingParam>();
   //ublic BowlingParam[] bowlingParam = new BowlingParam[10];
    public float PlayerPower = 150;
    public int UserScore = 0;
    public int DeathBlowCredit = 1;

    // User Settings Parameter.
    public float HeightScrollPercentage = 0.4f;

	// Use this for initialization
	void Start () 
    {
        InitializeGameParameter();
        InitializeUserSettings();
	}

    void Update() 
    {

        if (Input.GetKey(KeyCode.UpArrow)) {
            AddScrollPercentage();
            Debug.Log(HeightScrollPercentage);
        }
        if (Input.GetKey(KeyCode.DownArrow)) {
            SubScrollPercentage();
            Debug.Log(HeightScrollPercentage);
        }

        if (Input.GetKey(KeyCode.RightArrow))
        {
            AddPlayerPower();
            Debug.Log(PlayerPower);
        }
        if (Input.GetKey(KeyCode.LeftArrow))
        {
            SubPlayerPower();
            Debug.Log(PlayerPower);
        }

    }

    public void InitializeGameParameter()
    {
        throwCount = 0;
        UserScore = 0;
        GameStartRound = GameRound;
    }

    public void InitializeUserSettings()
    {

    }

    public void SetHeightScrollPercentage(float addValue)
    {
        HeightScrollPercentage += addValue;
        if (HeightScrollPercentage > 1.0f) {
            HeightScrollPercentage = 1.0f;
        }
        if (HeightScrollPercentage < 0.0f) {
            HeightScrollPercentage = 0.0f;
        }
    }

    public void AddScore(int value) 
    {
        UserScore += value;
    }

    public void AddPlayerPower()
    {
        PlayerPower+=1.0f;
    }

    public void SubPlayerPower()
    {
        PlayerPower -= 1.0f;
    }

    public void AddScrollPercentage()
    {
        SetHeightScrollPercentage(0.01f);
    }

    public void SubScrollPercentage()
    {
        SetHeightScrollPercentage(-0.01f);
    }


}
