﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/ssm/model/InventoryResultEntity.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace SSM
{
namespace Model
{

InventoryResultEntity::InventoryResultEntity() : 
    m_idHasBeenSet(false),
    m_dataHasBeenSet(false)
{
}

InventoryResultEntity::InventoryResultEntity(const JsonValue& jsonValue) : 
    m_idHasBeenSet(false),
    m_dataHasBeenSet(false)
{
  *this = jsonValue;
}

InventoryResultEntity& InventoryResultEntity::operator =(const JsonValue& jsonValue)
{
  if(jsonValue.ValueExists("Id"))
  {
    m_id = jsonValue.GetString("Id");

    m_idHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Data"))
  {
    Aws::Map<Aws::String, JsonValue> dataJsonMap = jsonValue.GetObject("Data").GetAllObjects();
    for(auto& dataItem : dataJsonMap)
    {
      m_data[dataItem.first] = dataItem.second.AsObject();
    }
    m_dataHasBeenSet = true;
  }

  return *this;
}

JsonValue InventoryResultEntity::Jsonize() const
{
  JsonValue payload;

  if(m_idHasBeenSet)
  {
   payload.WithString("Id", m_id);

  }

  if(m_dataHasBeenSet)
  {
   JsonValue dataJsonMap;
   for(auto& dataItem : m_data)
   {
     dataJsonMap.WithObject(dataItem.first, dataItem.second.Jsonize());
   }
   payload.WithObject("Data", std::move(dataJsonMap));

  }

  return payload;
}

} // namespace Model
} // namespace SSM
} // namespace Aws
