﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/Array.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SSM
{
namespace Model
{

  /**
   * <p>The parameters for a LAMBDA task type.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/MaintenanceWindowLambdaParameters">AWS
   * API Reference</a></p>
   */
  class AWS_SSM_API MaintenanceWindowLambdaParameters
  {
  public:
    MaintenanceWindowLambdaParameters();
    MaintenanceWindowLambdaParameters(const Aws::Utils::Json::JsonValue& jsonValue);
    MaintenanceWindowLambdaParameters& operator=(const Aws::Utils::Json::JsonValue& jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Pass client-specific information to the Lambda function that you are
     * invoking. You can then process the client information in your Lambda function as
     * you choose through the context variable.</p>
     */
    inline const Aws::String& GetClientContext() const{ return m_clientContext; }

    /**
     * <p>Pass client-specific information to the Lambda function that you are
     * invoking. You can then process the client information in your Lambda function as
     * you choose through the context variable.</p>
     */
    inline void SetClientContext(const Aws::String& value) { m_clientContextHasBeenSet = true; m_clientContext = value; }

    /**
     * <p>Pass client-specific information to the Lambda function that you are
     * invoking. You can then process the client information in your Lambda function as
     * you choose through the context variable.</p>
     */
    inline void SetClientContext(Aws::String&& value) { m_clientContextHasBeenSet = true; m_clientContext = std::move(value); }

    /**
     * <p>Pass client-specific information to the Lambda function that you are
     * invoking. You can then process the client information in your Lambda function as
     * you choose through the context variable.</p>
     */
    inline void SetClientContext(const char* value) { m_clientContextHasBeenSet = true; m_clientContext.assign(value); }

    /**
     * <p>Pass client-specific information to the Lambda function that you are
     * invoking. You can then process the client information in your Lambda function as
     * you choose through the context variable.</p>
     */
    inline MaintenanceWindowLambdaParameters& WithClientContext(const Aws::String& value) { SetClientContext(value); return *this;}

    /**
     * <p>Pass client-specific information to the Lambda function that you are
     * invoking. You can then process the client information in your Lambda function as
     * you choose through the context variable.</p>
     */
    inline MaintenanceWindowLambdaParameters& WithClientContext(Aws::String&& value) { SetClientContext(std::move(value)); return *this;}

    /**
     * <p>Pass client-specific information to the Lambda function that you are
     * invoking. You can then process the client information in your Lambda function as
     * you choose through the context variable.</p>
     */
    inline MaintenanceWindowLambdaParameters& WithClientContext(const char* value) { SetClientContext(value); return *this;}


    /**
     * <p>(Optional) Specify a Lambda function version or alias name. If you specify a
     * function version, the action uses the qualified function ARN to invoke a
     * specific Lambda function. If you specify an alias name, the action uses the
     * alias ARN to invoke the Lambda function version to which the alias points.</p>
     */
    inline const Aws::String& GetQualifier() const{ return m_qualifier; }

    /**
     * <p>(Optional) Specify a Lambda function version or alias name. If you specify a
     * function version, the action uses the qualified function ARN to invoke a
     * specific Lambda function. If you specify an alias name, the action uses the
     * alias ARN to invoke the Lambda function version to which the alias points.</p>
     */
    inline void SetQualifier(const Aws::String& value) { m_qualifierHasBeenSet = true; m_qualifier = value; }

    /**
     * <p>(Optional) Specify a Lambda function version or alias name. If you specify a
     * function version, the action uses the qualified function ARN to invoke a
     * specific Lambda function. If you specify an alias name, the action uses the
     * alias ARN to invoke the Lambda function version to which the alias points.</p>
     */
    inline void SetQualifier(Aws::String&& value) { m_qualifierHasBeenSet = true; m_qualifier = std::move(value); }

    /**
     * <p>(Optional) Specify a Lambda function version or alias name. If you specify a
     * function version, the action uses the qualified function ARN to invoke a
     * specific Lambda function. If you specify an alias name, the action uses the
     * alias ARN to invoke the Lambda function version to which the alias points.</p>
     */
    inline void SetQualifier(const char* value) { m_qualifierHasBeenSet = true; m_qualifier.assign(value); }

    /**
     * <p>(Optional) Specify a Lambda function version or alias name. If you specify a
     * function version, the action uses the qualified function ARN to invoke a
     * specific Lambda function. If you specify an alias name, the action uses the
     * alias ARN to invoke the Lambda function version to which the alias points.</p>
     */
    inline MaintenanceWindowLambdaParameters& WithQualifier(const Aws::String& value) { SetQualifier(value); return *this;}

    /**
     * <p>(Optional) Specify a Lambda function version or alias name. If you specify a
     * function version, the action uses the qualified function ARN to invoke a
     * specific Lambda function. If you specify an alias name, the action uses the
     * alias ARN to invoke the Lambda function version to which the alias points.</p>
     */
    inline MaintenanceWindowLambdaParameters& WithQualifier(Aws::String&& value) { SetQualifier(std::move(value)); return *this;}

    /**
     * <p>(Optional) Specify a Lambda function version or alias name. If you specify a
     * function version, the action uses the qualified function ARN to invoke a
     * specific Lambda function. If you specify an alias name, the action uses the
     * alias ARN to invoke the Lambda function version to which the alias points.</p>
     */
    inline MaintenanceWindowLambdaParameters& WithQualifier(const char* value) { SetQualifier(value); return *this;}


    /**
     * <p>JSON to provide to your Lambda function as input.</p>
     */
    inline const Aws::Utils::ByteBuffer& GetPayload() const{ return m_payload; }

    /**
     * <p>JSON to provide to your Lambda function as input.</p>
     */
    inline void SetPayload(const Aws::Utils::ByteBuffer& value) { m_payloadHasBeenSet = true; m_payload = value; }

    /**
     * <p>JSON to provide to your Lambda function as input.</p>
     */
    inline void SetPayload(Aws::Utils::ByteBuffer&& value) { m_payloadHasBeenSet = true; m_payload = std::move(value); }

    /**
     * <p>JSON to provide to your Lambda function as input.</p>
     */
    inline MaintenanceWindowLambdaParameters& WithPayload(const Aws::Utils::ByteBuffer& value) { SetPayload(value); return *this;}

    /**
     * <p>JSON to provide to your Lambda function as input.</p>
     */
    inline MaintenanceWindowLambdaParameters& WithPayload(Aws::Utils::ByteBuffer&& value) { SetPayload(std::move(value)); return *this;}

  private:

    Aws::String m_clientContext;
    bool m_clientContextHasBeenSet;

    Aws::String m_qualifier;
    bool m_qualifierHasBeenSet;

    Aws::Utils::ByteBuffer m_payload;
    bool m_payloadHasBeenSet;
  };

} // namespace Model
} // namespace SSM
} // namespace Aws
