﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/model/APNSMessage.h>
#include <aws/pinpoint/model/DefaultMessage.h>
#include <aws/pinpoint/model/DefaultPushNotificationMessage.h>
#include <aws/pinpoint/model/GCMMessage.h>
#include <aws/pinpoint/model/SMSMessage.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Pinpoint
{
namespace Model
{

  /**
   * The message configuration.
   */
  class AWS_PINPOINT_API DirectMessageConfiguration
  {
  public:
    DirectMessageConfiguration();
    DirectMessageConfiguration(const Aws::Utils::Json::JsonValue& jsonValue);
    DirectMessageConfiguration& operator=(const Aws::Utils::Json::JsonValue& jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * The message to APNS channels. Overrides the default push notification message.
     */
    inline const APNSMessage& GetAPNSMessage() const{ return m_aPNSMessage; }

    /**
     * The message to APNS channels. Overrides the default push notification message.
     */
    inline void SetAPNSMessage(const APNSMessage& value) { m_aPNSMessageHasBeenSet = true; m_aPNSMessage = value; }

    /**
     * The message to APNS channels. Overrides the default push notification message.
     */
    inline void SetAPNSMessage(APNSMessage&& value) { m_aPNSMessageHasBeenSet = true; m_aPNSMessage = std::move(value); }

    /**
     * The message to APNS channels. Overrides the default push notification message.
     */
    inline DirectMessageConfiguration& WithAPNSMessage(const APNSMessage& value) { SetAPNSMessage(value); return *this;}

    /**
     * The message to APNS channels. Overrides the default push notification message.
     */
    inline DirectMessageConfiguration& WithAPNSMessage(APNSMessage&& value) { SetAPNSMessage(std::move(value)); return *this;}


    /**
     * The default message for all channels.
     */
    inline const DefaultMessage& GetDefaultMessage() const{ return m_defaultMessage; }

    /**
     * The default message for all channels.
     */
    inline void SetDefaultMessage(const DefaultMessage& value) { m_defaultMessageHasBeenSet = true; m_defaultMessage = value; }

    /**
     * The default message for all channels.
     */
    inline void SetDefaultMessage(DefaultMessage&& value) { m_defaultMessageHasBeenSet = true; m_defaultMessage = std::move(value); }

    /**
     * The default message for all channels.
     */
    inline DirectMessageConfiguration& WithDefaultMessage(const DefaultMessage& value) { SetDefaultMessage(value); return *this;}

    /**
     * The default message for all channels.
     */
    inline DirectMessageConfiguration& WithDefaultMessage(DefaultMessage&& value) { SetDefaultMessage(std::move(value)); return *this;}


    /**
     * The default push notification message for all push channels.
     */
    inline const DefaultPushNotificationMessage& GetDefaultPushNotificationMessage() const{ return m_defaultPushNotificationMessage; }

    /**
     * The default push notification message for all push channels.
     */
    inline void SetDefaultPushNotificationMessage(const DefaultPushNotificationMessage& value) { m_defaultPushNotificationMessageHasBeenSet = true; m_defaultPushNotificationMessage = value; }

    /**
     * The default push notification message for all push channels.
     */
    inline void SetDefaultPushNotificationMessage(DefaultPushNotificationMessage&& value) { m_defaultPushNotificationMessageHasBeenSet = true; m_defaultPushNotificationMessage = std::move(value); }

    /**
     * The default push notification message for all push channels.
     */
    inline DirectMessageConfiguration& WithDefaultPushNotificationMessage(const DefaultPushNotificationMessage& value) { SetDefaultPushNotificationMessage(value); return *this;}

    /**
     * The default push notification message for all push channels.
     */
    inline DirectMessageConfiguration& WithDefaultPushNotificationMessage(DefaultPushNotificationMessage&& value) { SetDefaultPushNotificationMessage(std::move(value)); return *this;}


    /**
     * The message to GCM channels. Overrides the default push notification message.
     */
    inline const GCMMessage& GetGCMMessage() const{ return m_gCMMessage; }

    /**
     * The message to GCM channels. Overrides the default push notification message.
     */
    inline void SetGCMMessage(const GCMMessage& value) { m_gCMMessageHasBeenSet = true; m_gCMMessage = value; }

    /**
     * The message to GCM channels. Overrides the default push notification message.
     */
    inline void SetGCMMessage(GCMMessage&& value) { m_gCMMessageHasBeenSet = true; m_gCMMessage = std::move(value); }

    /**
     * The message to GCM channels. Overrides the default push notification message.
     */
    inline DirectMessageConfiguration& WithGCMMessage(const GCMMessage& value) { SetGCMMessage(value); return *this;}

    /**
     * The message to GCM channels. Overrides the default push notification message.
     */
    inline DirectMessageConfiguration& WithGCMMessage(GCMMessage&& value) { SetGCMMessage(std::move(value)); return *this;}


    /**
     * The message to SMS channels. Overrides the default message.
     */
    inline const SMSMessage& GetSMSMessage() const{ return m_sMSMessage; }

    /**
     * The message to SMS channels. Overrides the default message.
     */
    inline void SetSMSMessage(const SMSMessage& value) { m_sMSMessageHasBeenSet = true; m_sMSMessage = value; }

    /**
     * The message to SMS channels. Overrides the default message.
     */
    inline void SetSMSMessage(SMSMessage&& value) { m_sMSMessageHasBeenSet = true; m_sMSMessage = std::move(value); }

    /**
     * The message to SMS channels. Overrides the default message.
     */
    inline DirectMessageConfiguration& WithSMSMessage(const SMSMessage& value) { SetSMSMessage(value); return *this;}

    /**
     * The message to SMS channels. Overrides the default message.
     */
    inline DirectMessageConfiguration& WithSMSMessage(SMSMessage&& value) { SetSMSMessage(std::move(value)); return *this;}

  private:

    APNSMessage m_aPNSMessage;
    bool m_aPNSMessageHasBeenSet;

    DefaultMessage m_defaultMessage;
    bool m_defaultMessageHasBeenSet;

    DefaultPushNotificationMessage m_defaultPushNotificationMessage;
    bool m_defaultPushNotificationMessageHasBeenSet;

    GCMMessage m_gCMMessage;
    bool m_gCMMessageHasBeenSet;

    SMSMessage m_sMSMessage;
    bool m_sMSMessageHasBeenSet;
  };

} // namespace Model
} // namespace Pinpoint
} // namespace Aws
