﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/model/ScheduleState.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Glue
{
namespace Model
{

  /**
   * <p>A scheduling object using a <code>cron</code> statement to schedule an
   * event.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Schedule">AWS API
   * Reference</a></p>
   */
  class AWS_GLUE_API Schedule
  {
  public:
    Schedule();
    Schedule(const Aws::Utils::Json::JsonValue& jsonValue);
    Schedule& operator=(const Aws::Utils::Json::JsonValue& jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>A <code>cron</code> expression that can be used as a Cloudwatch event to
     * schedule something (see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch
     * Schedule Expression Syntax</a>. For example, to run something every day at 12:15
     * UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>
     */
    inline const Aws::String& GetScheduleExpression() const{ return m_scheduleExpression; }

    /**
     * <p>A <code>cron</code> expression that can be used as a Cloudwatch event to
     * schedule something (see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch
     * Schedule Expression Syntax</a>. For example, to run something every day at 12:15
     * UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>
     */
    inline void SetScheduleExpression(const Aws::String& value) { m_scheduleExpressionHasBeenSet = true; m_scheduleExpression = value; }

    /**
     * <p>A <code>cron</code> expression that can be used as a Cloudwatch event to
     * schedule something (see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch
     * Schedule Expression Syntax</a>. For example, to run something every day at 12:15
     * UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>
     */
    inline void SetScheduleExpression(Aws::String&& value) { m_scheduleExpressionHasBeenSet = true; m_scheduleExpression = std::move(value); }

    /**
     * <p>A <code>cron</code> expression that can be used as a Cloudwatch event to
     * schedule something (see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch
     * Schedule Expression Syntax</a>. For example, to run something every day at 12:15
     * UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>
     */
    inline void SetScheduleExpression(const char* value) { m_scheduleExpressionHasBeenSet = true; m_scheduleExpression.assign(value); }

    /**
     * <p>A <code>cron</code> expression that can be used as a Cloudwatch event to
     * schedule something (see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch
     * Schedule Expression Syntax</a>. For example, to run something every day at 12:15
     * UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>
     */
    inline Schedule& WithScheduleExpression(const Aws::String& value) { SetScheduleExpression(value); return *this;}

    /**
     * <p>A <code>cron</code> expression that can be used as a Cloudwatch event to
     * schedule something (see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch
     * Schedule Expression Syntax</a>. For example, to run something every day at 12:15
     * UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>
     */
    inline Schedule& WithScheduleExpression(Aws::String&& value) { SetScheduleExpression(std::move(value)); return *this;}

    /**
     * <p>A <code>cron</code> expression that can be used as a Cloudwatch event to
     * schedule something (see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">CloudWatch
     * Schedule Expression Syntax</a>. For example, to run something every day at 12:15
     * UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>
     */
    inline Schedule& WithScheduleExpression(const char* value) { SetScheduleExpression(value); return *this;}


    /**
     * <p>The state of the schedule.</p>
     */
    inline const ScheduleState& GetState() const{ return m_state; }

    /**
     * <p>The state of the schedule.</p>
     */
    inline void SetState(const ScheduleState& value) { m_stateHasBeenSet = true; m_state = value; }

    /**
     * <p>The state of the schedule.</p>
     */
    inline void SetState(ScheduleState&& value) { m_stateHasBeenSet = true; m_state = std::move(value); }

    /**
     * <p>The state of the schedule.</p>
     */
    inline Schedule& WithState(const ScheduleState& value) { SetState(value); return *this;}

    /**
     * <p>The state of the schedule.</p>
     */
    inline Schedule& WithState(ScheduleState&& value) { SetState(std::move(value)); return *this;}

  private:

    Aws::String m_scheduleExpression;
    bool m_scheduleExpressionHasBeenSet;

    ScheduleState m_state;
    bool m_stateHasBeenSet;
  };

} // namespace Model
} // namespace Glue
} // namespace Aws
