#pragma once
#include "Interface.h"
#include "MmdStruct.h"
#include "Camera.h"

/// bV̒_f[^
/// _tH[}bg D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_TEX1
struct Vertex {
	D3DXVECTOR3 position;	// _ʒu
	D3DXVECTOR3 normal;		// @xNg
	D3DXVECTOR2 texture;	// eNX`W
};

/// bṼ|Sf[^
struct Face {
	unsigned short indices[3];		// 3_̃CfbNX
	unsigned long material_number;	// ޗԍ
};

// bVf[^ꎞۑp\́BƎ`f[^͈x̍\̂Ɋi[AMesh::SetMesh()Mesh::pMeshɃZbgB
struct MeshData {
	vector<Vertex> vertices;
	vector<Face> faces;
	vector<D3DMATERIAL9> material;
	vector<string> texture_filename;
};

/// bṼx[X
class Mesh : public Drawable3D {
protected:
	LPDIRECT3DDEVICE9 pDevice;			// Direct3DfoCXIuWFNg
	LPD3DXMESH pMesh;					// bV
	D3DMATERIAL9* pMeshMaterials;		// }eAz
	LPDIRECT3DTEXTURE9*	pMeshTextures;	// eNX`z
	unsigned long numMaterial;				// }eAEeNX`z̑傫
	void AddNormalVector(MeshData& meshData);// MeshDataɖ@xNgǉ
	void SetMesh(MeshData meshData);	// MeshDatapMeshɃZbg
	Mesh(LPDIRECT3DDEVICE9 pDevice);	// IuWFNg֎~
public:
	virtual ~Mesh();
	virtual void Draw(D3DXVECTOR3* position, D3DXMATRIX* rotation, D3DLIGHT9* light, Camera* camera);
	virtual LPD3DXMESH GetMesh();
	virtual int GetNumMaterial();
};

/// Xt@CǍ񂾃bV
class XFileMesh sealed : public Mesh {
public:
	XFileMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDevice);
};

/// ^ZRCAt@CǍ񂾃bV
class MqoMesh sealed : public Mesh {
private:
	template <typename T> vector<T> MaterialPickOut(string str, char* name, int n); // }eAs̕񂩂w肵O̒l̔z擾
	void LoadMaterial(ifstream& ifs, MeshData& meshData);
	void LoadObject(ifstream& ifs, MeshData& meshData);
	MeshData GetMeshDataFromMQO(LPCTSTR filename); // ^ZRCAt@C烁bVf[^Ǎ
public:
	MqoMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDevice);
};

/// PMDt@CǍ񂾃bV
class PmdMesh sealed : public Mesh {
	void CopyMaterial(D3DMATERIAL9& material, MmdStruct::PmdMaterial& pmdMaterial);	// PmdMaterialD3DMATERIAL9Ƀf[^Rs[
public:
	PmdMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDevice);
};