// test.cpp : AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "test.h"
#include "MyApplication.h"

#define MAX_LOADSTRING 100

// O[oϐ:
static HWND hWnd;
HINSTANCE hInst;								// ݂̃C^[tFCX
TCHAR szTitle[MAX_LOADSTRING];					// ^Cg o[̃eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// C EBhE NX

// ̃R[h W[Ɋ܂܂֐̐錾]܂:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	MSG msg;
	HACCEL hAccelTable;

	// O[oĂ܂B
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_TEST, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// AvP[V̏s܂:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_TEST));
	ZeroMemory(&msg, sizeof(msg));


	// C bZ[W [v
	MyApplication* myApplication = 0;
	try {
		myApplication = new MyApplication(hWnd);
		while (msg.message!=WM_QUIT) {
			if(PeekMessage(&msg, NULL, 0U, 0U, PM_REMOVE)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
			else myApplication->Run();
		}
	}
	catch (LPCTSTR str) {
		MessageBox(0, str, TEXT("Error"), MB_OK);	// O\
		DestroyWindow(hWnd);
	} catch (...) {
		MessageBox(0, TEXT("unknown error"), TEXT("Error"), MB_OK);
		DestroyWindow(hWnd);
	}
	delete myApplication;
	return (int) msg.wParam;
}



//
//  ֐: MyRegisterClass()
//
//  ړI: EBhE NXo^܂B
//
//  Rg:
//
//    ̊֐юǵA'RegisterClassEx' ֐ǉꂽ
//    Windows 95 O Win32 VXeƌ݊ꍇɂ̂ݕKvłB
//    AvP[VA֘Atꂽ
//    `̏ACR擾ł悤ɂɂ́A
//    ̊֐ĂяoĂB
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_TEST));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= 0;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   ֐: InitInstance(HINSTANCE, int)
//
//   ړI: CX^X nhۑāAC EBhE쐬܂B
//
//   Rg:
//
//        ̊֐ŁAO[oϐŃCX^X nhۑA
//        C vO EBhE쐬ѕ\܂B
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   hInst = hInstance; // O[oϐɃCX^Xi[܂B

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, WINDOW_WIDTH, WINDOW_HEIGHT, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  ֐: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  ړI:  C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd_in_callBack, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Iꂽj[̉:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd_in_callBack, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd_in_callBack);
			break;
		default:
			return DefWindowProc(hWnd_in_callBack, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd_in_callBack, &ps);
		// TODO: `R[hɒǉĂ...
		EndPaint(hWnd_in_callBack, &ps);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd_in_callBack, message, wParam, lParam);
	}
	return 0;
}

// o[W{bNX̃bZ[W nhłB
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
