#pragma once
#include "d3dx9anim.h"

/// bV̒_f[^
struct Vertex {
	D3DXVECTOR3 position;	//_ʒu
//	D3DXVECTOR3 normal;		//@xNg
};

/// bṼ|Sf[^
struct Face {
	unsigned short indices[3];		// 3_̃CfbNX
	unsigned long material_number;	// ޗԍ
};

// bVf[^ۑp\
struct MeshData {
	vector<Vertex> vertices;
	vector<Face> faces;
	vector<D3DMATERIAL9> material;
	vector<string> texture_filename;
};

/// bṼx[X
class Mesh {
protected:
	LPDIRECT3DDEVICE9 pDevice;			// Direct3DfoCXIuWFNg
	LPD3DXMESH pMesh;					// bV
	D3DMATERIAL9* pMeshMaterials;		// }eAz
	LPDIRECT3DTEXTURE9*	pMeshTextures;	// eNX`z
	DWORD dwNumMaterials;				// }eAEeNX`z̑傫
	void SetMesh(MeshData meshData);	// MeshDataOtBbN{[h̃ɃZbg
public:
	Mesh(LPDIRECT3DDEVICE9 pDevice);
	virtual ~Mesh();
	virtual void Draw(D3DXVECTOR3 position, D3DXMATRIX rotation);
	virtual LPD3DXMESH GetMesh();
	virtual int GetNumMaterial();
};

/// Xt@CǍ񂾃bV
class XFileMesh sealed : public Mesh {
public:
	XFileMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDev);
};

/// ^ZRCAt@CǍ񂾃bV
class MqoMesh sealed : public Mesh {
private:
	template <typename T> vector<T> MaterialPickOut(string str, char* name, int n); // }eAs̕񂩂w肵O̒l̔z擾
	void LoadMaterial(ifstream& ifs, MeshData& meshData);
	void LoadObject(ifstream& ifs, MeshData& meshData);
	MeshData GetMeshDataFromMQO(LPCTSTR filename); // ^ZRCAt@C烁bVf[^Ǎ
public:
	MqoMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDev);
};

/// bṼr[ϊAˉeϊsȂJ
class MeshCamera sealed {
private:
	LPDIRECT3DDEVICE9 pDevice;
public:
	MeshCamera(LPDIRECT3DDEVICE9 pDev);
	void Look(D3DXVECTOR3 eyePoint, D3DXVECTOR3 lookAtPoint);
};

/// bVpCg
class MeshLight sealed {
private:
	LPDIRECT3DDEVICE9 pDevice;
	D3DLIGHT9 light;
public:
	MeshLight(LPDIRECT3DDEVICE9 pDev);
	void Illume(D3DXVECTOR3 direction);
};

/// t[
struct MYFRAME: public D3DXFRAME {
	D3DXMATRIX CombinedTransformationMatrix;
};

/// bVRei
struct MYMESHCONTAINER: public D3DXMESHCONTAINER {
	LPDIRECT3DTEXTURE9*  ppTextures;
	DWORD dwWeight;							// ď݂id݂Ƃ͒_ւ̉eBj
	DWORD dwBoneAmt;						// {[̐
	LPD3DXBUFFER pBoneBuffer;				// {[Ee[u
	D3DXMATRIX** ppBoneMatrix;				// SẴ{[̃[hs̐擪|C^[
	D3DXMATRIX* pBoneOffsetMatrices;		// t[ƂẴ{[̃[hs̃|C^[
};

/// t[Iy[^
class FrameOperator {
private:
	/// bVReĩ_O
	virtual void RenderMeshContainer(LPDIRECT3DDEVICE9 pDevice, MYMESHCONTAINER* pMeshContainer, MYFRAME* pFrame);
public:
	/// t[̃[hϊ
	virtual void UpdateMatrices(LPD3DXFRAME pFrame, LPD3DXMATRIX world);

	/// t[̃_O
	virtual void Draw(LPDIRECT3DDEVICE9 pDevice, LPD3DXFRAME pFrame);
};

/// Xt@CǍ񂾃Aj[VbV
class XFileAnimationMesh sealed {
private:
	class MyHierarchy : public ID3DXAllocateHierarchy {
	private:
		void CreateTexture(MYMESHCONTAINER* pMeshContainer, LPDIRECT3DDEVICE9 pDevice, DWORD NumMaterials);
		void SetDefaultMaterial(MYMESHCONTAINER* pMeshContainer);
	public:
		MyHierarchy(){};
		~MyHierarchy(){};
		STDMETHOD(CreateFrame)(THIS_ LPCSTR , LPD3DXFRAME *);
		STDMETHOD(CreateMeshContainer)(THIS_ LPCSTR, CONST D3DXMESHDATA*, CONST D3DXMATERIAL*, CONST D3DXEFFECTINSTANCE*, DWORD, CONST DWORD*, LPD3DXSKININFO, LPD3DXMESHCONTAINER*);
		STDMETHOD(DestroyFrame)(THIS_ LPD3DXFRAME);
		STDMETHOD(DestroyMeshContainer)(THIS_ LPD3DXMESHCONTAINER);
	};
	LPDIRECT3DDEVICE9			pDevice;										// Direct3DfoCXIuWFNg
	MyHierarchy					cHierarchy;										// AP[gqGL[IuWFNg
	LPD3DXFRAME					pFrameRoot;										// t[
	LPD3DXANIMATIONCONTROLLER	pAnimController;								// Aj[VRg[
	LPD3DXANIMATIONSET			pAnimSet[100];									// Aj[VZbg
	HRESULT AllocateBoneMatrix(LPD3DXMESHCONTAINER);							// bVɍsU
	HRESULT AllocateAllBoneMatrices(LPD3DXFRAME);								// ċAR[hFt[KwWJĊebVɍsU
	void FreeAnim(LPD3DXFRAME pF);												// ċAR[hFSẴbVRei[X
	FrameOperator				frameOperator;									// t[Iy[^
public:
	XFileAnimationMesh(LPCTSTR filename, LPDIRECT3DDEVICE9 pDevice);
	~XFileAnimationMesh(void);

	// `
	void Draw(D3DXVECTOR3 position, D3DXMATRIX rotation);

	/// Ԃis
	void AdvanceTime(double time);

	/// ؂ւ
	void ChangeMotion(int motion_number);

	/// t[擾
	LPD3DXFRAME GetFrame();
};


/// 상bV
class HandMadeMesh sealed : public Mesh {
public:
	HandMadeMesh(LPDIRECT3DDEVICE9 pDev);
};
