'''OpenGL extension KHR.context_flush_control

This module customises the behaviour of the 
OpenGL.raw.GLES2.KHR.context_flush_control to provide a more 
Python-friendly API

Overview (from the spec)
	
	OpenGL and OpenGL ES have long supported multiple contexts. The
	semantics of switching contexts is generally left to window system
	binding APIs such as WGL, GLX and EGL. Most of these APIs (if not all)
	specify that when the current context for a thread is changed, the
	outgoing context performs an implicit flush of any commands that have
	been issued to that point. OpenGL and OpenGL ES define a flush as
	sending any pending commands for execution and that this action will
	result in their completion in finite time.
	
	This behavior has subtle consequences. For example, if an application is
	rendering to the front buffer and switches contexts, it may assume that
	any rendering performed thus far will eventually be visible to the user.
	With recent introduction of shared memory buffers, there become inumerable
	ways in which applications may observe side effects of an implicit flush
	(or lack thereof).
	
	In general, a full flush is not the desired behavior of the application.
	Nonetheless, applications that switch contexts frequently suffer the
	performance consequences of this unless implementations make special
	considerations for them, which is generally untenable.
	
	The WGL and GLX extensions add new context creation parameters the allow
	an application to specify the behavior that is desired when a context is
	made non-current, and specifically to opt out of the implicit flush
	behavior. The GL extension allows querying the context flush behavior.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/KHR/context_flush_control.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.KHR.context_flush_control import *
from OpenGL.raw.GLES2.KHR.context_flush_control import _EXTENSION_NAME

def glInitContextFlushControlKHR():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION