/**
 *  UtInterpolate.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */


#ifndef __LIVE2D_UTINTERPOLATE_H__
#define __LIVE2D_UTINTERPOLATE_H__


#ifndef __SKIP_DOC__

#include "../Live2D.h"
#include "../type/LDVector.h"



//------------ LIVE2D NAMESPACE ------------
namespace live2d
{ 
	class ModelContext ;
	class PivotManager ;
	
	
	class UtInterpolate 
	{
	public:
		// _Ԃ
		static void interpolatePoints(
				ModelContext &mdc 
				, PivotManager &pivotManager
				, bool *ret_paramOutside	// p[^`͈͊O̎ɁAtrueZbgĕԂ 
				,int numPts 
				, LDVector<l2d_pointf*> &pivotPoints // [][]ɑ
				, l2d_pointf * dst_points
				, int pt_offset , int pt_step ) ;
	
		// float	
		static float interpolateFloat(
				ModelContext &mdc , 
				PivotManager &pivotManager	,
				bool *ret_paramOutside	,// p[^`͈͊O̎ɁAtrueZbgĕԂ 
				LDVector<float> & pivotValue 
		) ; // []ɑ
	
		// int	
		static int interpolateInt(
				ModelContext &mdc , 
				PivotManager &pivotManager	,
				bool *ret_paramOutside ,// p[^`͈͊O̎ɁAtrueZbgĕԂ 
				LDVector<int> & pivotValue ) ; // []ɑ
	
	private:
		UtInterpolate();		
	
		//Prevention of copy Constructor
		UtInterpolate( const UtInterpolate & ) ;				
		UtInterpolate& operator=( const UtInterpolate & ) ; 
		
		~UtInterpolate();	
	};
} 
//------------ LIVE2D NAMESPACE ------------

#endif // __SKIP_DOC__

#endif		// __LIVE2D_UTINTERPOLATE_H__