/**
 *  MotionQueueEnt.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */
#ifndef __LIVE2D_MOTION_QUEUE_ENT_H__
#define __LIVE2D_MOTION_QUEUE_ENT_H__


#ifndef __SKIP_DOC__

#include "../memory/LDObject.h"
#include "../ALive2DModel.h"

#include "../type/LDVector.h"


//--------- LIVE2D NAMESPACE ------------
namespace live2d
{
	class AMotion ;
	class Live2DMotion ;

	/********************************************************************************
	@brief	MotionQueueManagerōĐĂe[V̊ǗNX
	
	MotionQueueManager* mqm = ... \n
	int motionQueueEntNo = mqm->startMotion(...)\n
	MotionQueueEnt ent = mqm->getMotionQueueEnt(motionQueueEntNo)
	********************************************************************************/
	class MotionQueueEnt : public live2d::LDObject 
	{
		// th
		friend class MotionQueueManager ;
		friend class AMotion ;
		friend class Live2DMotion ;
		friend class Live2DMotionBin ;
	public:
		MotionQueueEnt();
		virtual ~MotionQueueEnt(void);

	public:
		//  tF[hAEgJn
		void startFadeout(long long fadeOutMsec)  ;

		//  I
		bool isFinished() { return finished ; }

		//  JnԎ擾
		long long getStartTimeMSec(){ return startTimeMSec ; }

		//  tF[hCJnԎ擾
		long long getFadeInStartTimeMSec(){ return fadeInStartTimeMSec ; }

		//  tF[hCIԎ擾
		long long getEndTimeMSec(){ return endTimeMSec ; }

		//  JnԐݒ
		void setStartTimeMSec(long long t){ this->startTimeMSec = t ; }

		//  tF[hCJnԐݒ
		void setFadeInStartTimeMSec(long long t){ this->fadeInStartTimeMSec = t ; }

		//  tF[hCIԐݒ
		void setEndTimeMSec(long long t){ this->endTimeMSec = t ; }

		//  Iݒ
		void setFinished( bool f ){ this->finished = f ; }

		//  [VLԂ
		bool isAvailable(){ return available ; }

		//  Lݒ
		void setAvailable( bool v ){ this->available = v ; }

		//---- state for callback(Unity etc) ----
		//  Ԑݒ
		void setState( long long time , float weight ){ this->state_time = time ; this->state_weight = weight ; }

		//  ԏԎ擾
		long long getState_time(){ return this->state_time ; }

		//  "d"̏Ԏ擾
		float getState_weight(){ return this->state_weight ; }
		
	private:
		// pubNȐݒl
		bool			autoDelete;					//  폜
		AMotion* 		motion;						//  [V

		bool 			available;					//  LtO
		bool 			finished ;					//  ItO
		bool 			started ;					//  JntOi0.9.00ȍ~j
		long long 		startTimeMSec ;				//  Jn
		long long 		fadeInStartTimeMSec ;		//  tF[hCJni[v̎͏̂݁j

		// I\莞
		// @-1̏ꍇ͏I\莞ȂiA܂́@[vӖj
		// 	loop̏ꍇ endTimeMSec = ( startTimeMSec + 1񕪂̎ )
		// 	ʃ[V̊ MotionQueueManager startFadeout()Ă΂
		//		newEndTimeMSec = (+fadeOutMSec) ;
		//	if( endTimeMSec<0 /*[v*/ || newEndTimeMSec < endTimeMSec ){
		//			endTimeMSec = newEndTimeMSec 
		// I\莞߂ꍇ̓[Vj
		long long endTimeMSec ;

		// ---- CX^X̎ʔԍ
		static int static_motionQueueEntNo ;// CX^XƂɈӂ̒lʔԍ̎̒l
		int motionQueueEntNo ;// CX^XƂɈӂ̒lʔԍinewɐݒj(0.8.09ǉj

	private:
		//---- state for callback(Unity etc) ----
		long long   	state_time ;				//  ̏
		float	   	state_weight ;				//  d݂̏
	};

}
//--------- LIVE2D NAMESPACE ------------

#endif // __SKIP_DOC__

#endif	// __LIVE2D_MOTION_QUEUE_ENT_H__