/**
 *  AMotion.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */
#ifndef __LIVE2D_A_MOTION_H__
#define __LIVE2D_A_MOTION_H__


#include "../memory/LDObject.h"

#include "../ALive2DModel.h"

//--------- LIVE2D NAMESPACE ------------
namespace live2d 
{

	class MotionQueueEnt ;

	
	class AMotion : public live2d::LDObject 
	{
	public:
		AMotion();
		virtual ~AMotion() ;

	public:
		//  p[^XV
		void updateParam( live2d::ALive2DModel * model , MotionQueueEnt *motionQueueEnt ) ;

	public:

		
		void setFadeIn( int fadeInMsec ){ this->fadeInMsec = fadeInMsec ; }

		
		void setFadeOut( int fadeOutMsec){ this->fadeOutMsec = fadeOutMsec ; }
		
		
		int getFadeOut(){ return this->fadeOutMsec ; }

		
		int getFadeIn(){ return this->fadeInMsec ; }

		
		void setWeight( float weight){ this->weight = weight ; }
		
		
		float getWeight(){ return this->weight ; }

		/*****************************************************************
		 * [V̒Ԃi[v̂Ƃ -1j 
		 * [vł͂Ȃꍇ́AI[o[Ch
		 * 
		 * ̒l͎̎擾鎞ԂŏI
		 * -1̂Ƃ͊O~߂IȂƂȂ
		******************************************************************/
		virtual int getDurationMSec(){ return -1 ; }
		
		/*****************************************************************
		 * [vP񕪂̒Ԃ (0.9.00b8)
		 * 
		 * Ƀ[V̏ŗp
		 * 
		 * TuNXLive2DMotion̏ꍇ́Amtnt@CŒ`Ã[V̒Ԃ
		 * [vȂꍇ getDurationMSec()ƓlԂ
		 * [v񕪂̒`łȂꍇivOIɓTuNXȂǁj̏ꍇ-1Ԃ
		******************************************************************/
		virtual int getLoopDurationMSec(){ return -1 ; }


		/*****************************************************************
		 * [VĐ̊Jnݒ肷
		 * rĐꍇɎgp
		 *
		 * version 0.9.00蓋
		******************************************************************/
		void setOffsetMSec( int offsetMsec ){ this->offsetMsec = offsetMsec ; }

		
		void reinit(){}

	protected:
		//  p[^Abvf[g
		virtual void updateParamExe( live2d::ALive2DModel * model , long long timeMSec , float weight , MotionQueueEnt *motionQueueEnt ) = 0 ;

		//  C[WO擾
		float getEasing( float time , float totalTime , float accelerateTime ) ;

	protected:
		int 	fadeInMsec ;		// tF[hCꍇBꂪƁAˑRς肷
		int 	fadeOutMsec ;		// tF[hAEg
		float 	weight ;			// Modelɐݒ肳ĂlƊ|킹xBPȂ㏑

		int 	offsetMsec ;		// Đ̊Jn

	};

}
//--------- LIVE2D NAMESPACE ------------


#endif		// __LIVE2D_A_MOTION_H__