/**
 * DrawParam_D3D.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */
#ifndef __LIVE2D_DRAWPARAM_D3D_H__
#define __LIVE2D_DRAWPARAM_D3D_H__

#ifndef __SKIP_DOC__

#include "Live2D.h"

#ifdef L2D_TARGET_D3D

#include "type/LDVector.h"
#include <d3dx9.h>
#include "graphics/DrawParam.h"
#include "type/LDMap.h"
//------------ LIVE2D NAMESPACE ------------
namespace live2d
{ 
	// _Wp̍\
	typedef struct LIVE2D_D3D_VERTEX
	{
		D3DXVECTOR3 Position;
	} LIVE2D_D3D_VERTEX;


	// UVf[^p̍\
	typedef struct LIVE2D_D3D_UV
	{
		D3DXVECTOR2 Texture;
	} LIVE2D_D3D_UV;


	/**********************************************************************************
	@brief		DirectXp̕`NX
	************************************************************************************/
	class DrawParam_D3D : public DrawParam 
	{
	public:
		static const int INITIAL_VERTEX_COUNT = 300;		
		static const int INITIAL_INDEX_COUNT = 150;			
		
		//--- error / Direct3D is 6000.. ---
		static const int ERROR_D3D_CREATE_VERTEX_BUFFER	= 6001;
		static const int ERROR_D3D_LOCK_VERTEX_BUFFER	= 6002;
		static const int ERROR_D3D_CREATE_INDEX_BUFFER	= 6003;
		static const int ERROR_D3D_LOCK_INDEX_BUFFER	= 6004;
		static const int ERROR_D3D_DEVICE_NOT_SET		= 6005;
		static const int ERROR_D3D_LOAD_SHADER			= 6006;

		// foCXZbg
		static void setDevice( LPDIRECT3DDEVICE9 device );

		// NbsO}XNp̃eNX`ݒ肷
		static void setMaskTexture(LPDIRECT3DTEXTURE9 maskTexture);

		// NbsO}XNp̃T[tF[Xݒ肷
		static void setMaskSurface(LPDIRECT3DSURFACE9 maskSurface);

		// foCXXgɋʂČĂяo
		static void deviceLostCommon();

		// foCXZbgɋʂČĂяo
		static void deviceResetCommon();

		// VF[_̃[h
		static HRESULT initShader();

		// L\[X̔j
		static void dispose();

	public:
		DrawParam_D3D();
		virtual ~DrawParam_D3D();
		
	public:
		virtual void deleteTextures() ;

		virtual void setupDraw() ;

		void drawTextureD3D( int textureNo , int indexCount , int vertexCount , l2d_index * indexArray 
								, l2d_pointf * vertexArray , l2d_uvmapf * uvArray , float opacity
								, LPDIRECT3DVERTEXBUFFER9 pUvBu // Uvz
								, LPDIRECT3DINDEXBUFFER9 pIndexBuf // CfbNXz
								, int colorCompositionType // F̃^Cv
							 ) ;

		void drawTexture( int textureNo , int indexCount , int vertexCount , l2d_index * indexArray 
			, l2d_pointf * vertexArray , l2d_uvmapf * uvArray , float opacity
			, int colorCompositionType // F̃^Cv
			) ;

	
		void setTexture( int modelTextureNo , LPDIRECT3DTEXTURE9 textureNo ) ;

		//  VpłModel̃eNX`ԍm(Avatarpj
		virtual int generateModelTextureNo() ;
		
		//  Model̃eNX`ԍ𐶐(Avatarpj
		virtual void releaseModelTextureNo(int no) ;
		
		/********************************************************************
		@brief		OgetErrorŌĂ񂾌ŔG[擾
		**********************************************************************/
		int getErrorD3D_tmp()
		{
			int ret = error ;
			error = 0 ;
			return ret ;
		}


		/********************************************************************
		@brief		G[
		@param		error	->	G[ԍ
		**********************************************************************/
		void setErrorD3D_tmp( int error ){ this->error = error ; }
		

		/********************************************************************
		@brief		foCX擾
		@return		ݒ肳ĂfoCXf[^
		**********************************************************************/
		LPDIRECT3DDEVICE9 getDevice(){ return pd3dDevice ; }


		/********************************************************************
		@brief		D3DUVobt@̃Zbg
		**********************************************************************/
		void setUpBufD3D_UV(int vertexCount_, l2d_uvmapf*	uvArray);

		/********************************************************************
		@brief		D3DIndexobt@̃Zbg
		**********************************************************************/
		void setUpBufD3D_Index(int indexCount, l2d_index* indexArray);





		//  DirectXfoCXXgɌĂяo
		void deviceLost( ) ;


		//  DirectXp_񃁃mہiDDTextureĂ΂j
		static HRESULT createUvBuffer(    LPDIRECT3DDEVICE9 pd3dDevice , unsigned int length , IDirect3DVertexBuffer9**  ppVerterxBuffer ) ;
		static HRESULT createIndexBuffer( LPDIRECT3DDEVICE9 pd3dDevice , unsigned int length , IDirect3DIndexBuffer9**   ppIndexBuffer ) ;


	private:
		// Prevention of copy Constructor
		DrawParam_D3D( const DrawParam_D3D & ) ;
		DrawParam_D3D& operator=( const DrawParam_D3D & ) ; 
		
	private:
		// `uh[h
		// (lRenderEffectPassɕRÂ)
		enum RENDER_EFFECT_BLEND_MODE
		{
			RENDER_EFFECT_BLEND_MODE_MULT         = 0, // Z
			RENDER_EFFECT_BLEND_MODE_ADD          = 1, // Z
			RENDER_EFFECT_BLEND_MODE_INTERPORATE  = 2, // 
		};

		// RenderEffect̃O[oϐ̃nhꗗ
		struct EffectConstantHandleTable
		{
			D3DXHANDLE techNormal;				// ʏ`
			D3DXHANDLE techNormalPremultiplied;	// Zς݃At@{ʏ`
			D3DXHANDLE techMask;				// NbsO}XN`
			D3DXHANDLE techMaskPremultiplied;	// Zς݃At@{NbsO}XN`
			D3DXHANDLE worldViewProj;
			D3DXHANDLE baseColor;
			D3DXHANDLE interpolate;
			D3DXHANDLE windowWidth;
			D3DXHANDLE windowHeight;
		};

		//--------- fields ------------
		LDVector<LPDIRECT3DTEXTURE9>	textures ;			// DestructorŃeNX`͍̉sȂB{IɊOōsB

		LPDIRECT3DVERTEXBUFFER9			pVertexBuf ;		// _z
		int								vertexBuf_length ;	// ݂Buffer̃TCY

		IDirect3DVertexDeclaration9*	pDec ;				// _`

		live2d::LDMap<DrawDataID*,LPDIRECT3DVERTEXBUFFER9>  pUVBufMap;//UVzDDTEXTURẼ}bv
		live2d::LDMap<DrawDataID*,LPDIRECT3DINDEXBUFFER9>   pIndexBufMap;//CfbNXzDDTEXTURẼ}bv

		live2d::LDVector<DrawDataID*>                       pDrawDataIDs;//`f[^ID̃|C^Ǘ  LDMap̗vf폜邽߂ɂgĂȂ


		//-- error
		int								error ;				// G[L^pBIɂ͊NXɈړ\

	private:
		static LPDIRECT3DDEVICE9		pd3dDevice ;		// DirectXfoCXێ
		static LPDIRECT3DSURFACE9		pMainSurface;		// f̕`
		static LPDIRECT3DSURFACE9		pMaskSurface;		// NbsO}XÑT[tF[X
		static LPDIRECT3DTEXTURE9		pMaskTexture;		// NbsO}XÑeNX`
		static LPD3DXEFFECT				pRenderEffect;		// ʏ`ANbsO܂ރVF[_
		static EffectConstantHandleTable effectHandleTable; // RenderEffect̃O[oϐ̃nhꗗ
	};

} 
//------------ LIVE2D NAMESPACE ------------
#endif// L2D_TARGET_D3D

#endif // __SKIP_DOC__

#endif		// __LIVE2D_DRAWPARAM_D3D_H__