/**
 *
 *  You can modify and use this source freely
 *  only for the development of application related Live2D.
 *
 *  (c) Live2D Inc. All rights reserved.
 */
#pragma once

//Live2D lib
#include "ALive2DModel.h"
#include "motion/AMotion.h"
#include "motion/MotionQueueManager.h"

namespace live2d
{
	namespace framework
	{
		class L2DMotionManager : public MotionQueueManager
		{
			typedef MotionQueueManager super;
		public:
			L2DMotionManager();
			virtual ~L2DMotionManager(){}
			
		private:
			int currentPriority;//  ݍĐ̃[V̗Dx
			int reservePriority;//  Đ\̃[V̗DxBĐ0ɂȂB[Vt@CʃXbhœǂݍނƂ̋@\B
			
		public:
			//  Đ̃[V̗Dx
			int getCurrentPriority(){return currentPriority;}
			
			//  \񒆂̃[V̗Dx
			int getReservePriority(){return reservePriority;}
			
			//  [V\񂷂
			void setReservePriority( int val ){reservePriority=val;}
			
			//  [VJn
			int startMotionPrio( live2d::AMotion* motion, bool isDelete, int priority );
			
			bool updateParam(live2d::ALive2DModel* model);
			
			bool reserveMotion(int priority);
		};
	}
}
