/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! エラー回復
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@retval	int	エラーコード
 *@note
 * エラー等によりftpコマンドシーケンスが乱れたとき、再同期を試みるために
 * リプライキューをクリアします。
 */
int ftp_reset( LIBOFTP *ftp )
{
    int now_timeout_sec = ftp->timeout_sec;
    int ret;
    int i;

    /*
     * send "CRLF" only
     */
    if( ftp_send_command( ftp, "\r\n" ) < 0 ) {
	DEBUGPRINT1( "command sending error. %s\n", "CRLF" );
	return LIBOFTP_ERROR_OS;
    }

    /*
     * receive response until timeout. 100 cycle maxmum.
     */
    ftp_timeout( ftp, 1 );	/* set 1 sec */

    for( i = 0; i < 100; i++ ) {
	ret = ftp_receive_response( ftp, 0, 0 );
	if( ret == LIBOFTP_ERROR_TIMEOUT ) {
	    ret = LIBOFTP_NOERROR;
	    break;
	}

	if( ret == LIBOFTP_ERROR_OS ) {
	    DEBUGPRINT1( "os level error occurred.\n%s", "" );
	    break;
	}
    }

    ftp_timeout( ftp, now_timeout_sec );
    return ret;
}
