/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <stdio.h>


/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! ファイルリネーム
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	from	対象ファイル名
 *@param	to	変更後ファイル名
 *@retval	int	エラーコード
 *@note
 */
int ftp_rename( LIBOFTP *ftp, const char *from, const char *to )
{
    char str1[512];
    int res;

    /*
     * send RNFR command
     */
    snprintf( str1, sizeof(str1)-1, "RNFR %s\r\n", from );
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "RNFR command sending error. %s\n", str1 );
	return LIBOFTP_ERROR_OS;
    }

    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message)-1 );
    if( res != 350 ) {					/* 350: Requested file action pending further information */
	DEBUGPRINT1( "RNFR command response error. %d\n", res );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

    /*
     * send RNTO command
     */
    snprintf( str1, sizeof(str1)-1, "RNTO %s\r\n", to );
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "rename: RNTO command sending error. %s\n", str1 );
	return LIBOFTP_ERROR_OS;
    }

    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message)-1 );
    if( res != 250 ) {						/* 250: Requested file action okay, completed. */
	DEBUGPRINT1( "RNTO command response error. %d\n", res );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

    return LIBOFTP_NOERROR;
}
