/**
 * IP å󥸥饤֥(Unix)
 * å饹
 */
  
#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "IpMessenger.h"
#include "IpMessengerImpl.h"
#include "ipmsg.h"

using namespace ipmsg;

//åȥ饤
#define SENDMSG_RETRY_MAX	5

/**
 * 󥹥ȥ饯
 */
SentMessage::SentMessage()
{
	IPMSG_FUNC_ENTER( "SentMessage::SentMessage()" );
	IPMSG_FUNC_EXIT;
}

/**
 * ԡ󥹥ȥ饯
 * @param other ԡΥ֥
 */
SentMessage::SentMessage( const SentMessage& other )
{
	IPMSG_FUNC_ENTER( "SentMessage::SentMessage( const SentMessage& other )" );
	CopyFrom( other );
	IPMSG_FUNC_EXIT;
}

/**
 * 黻ҡ
 * @param other ԡΥ֥
 * @retval 󥹥
 */
SentMessage&
SentMessage::operator=( const SentMessage& other )
{
	IPMSG_FUNC_ENTER( "SentMessage& SentMessage::operator=( const SentMessage& other )" );
	CopyFrom( other );
	IPMSG_FUNC_RETURN( *this );
}

/**
 * ԡ᥽åɡ
 * @param other ԡΥ֥
 */
void
SentMessage::CopyFrom( const SentMessage& other )
{
	IPMSG_FUNC_ENTER( "void SentMessage::CopyFrom( const SentMessage& other )" );
	_To = other. _To;
	_Host = other. _Host;
	_PacketNo = other. _PacketNo;
	_Message = other. _Message;
	_Sent = other. _Sent;
	_PrevTry = other. _PrevTry;
	_IsRetryMaxOver = other. _IsRetryMaxOver;
	_IsSent = other. _IsSent;
	_IsPasswordLock = other. _IsPasswordLock;
	_IsCrypted = other. _IsCrypted;
	_RetryCount = other. _RetryCount;
	_IsConfirmed = other. _IsConfirmed;
	_IsConfirmAnswered = other. _IsConfirmAnswered;
	_IsSecret = other. _IsSecret;
	_IsNoLogging = other. _IsNoLogging;
	_HostCountAtSameTime = other. _HostCountAtSameTime;
	_Opt = other. _Opt;
	_Files = other._Files;
	IPMSG_FUNC_EXIT;
}

/**
 * 󥹥ȥ饯
 * <ul>
 * <li>ѥåꥹȤå뤿Υߥ塼ƥå</li>
 * </ul>
 */
SentMessageList::SentMessageList()
{
	IPMSG_FUNC_ENTER( "SentMessageList::SentMessageList()" );
	IpMsgMutexInit( "SentMessageList::SentMessageList()", &messagesMutex, NULL );
	IPMSG_FUNC_EXIT;
}

/**
 * ԡ󥹥ȥ饯
 * @param other ԡΥ֥
 */
SentMessageList::SentMessageList( const SentMessageList& other )
{
	IPMSG_FUNC_ENTER( "SentMessageList::SentMessageList( const SentMessageList& other )" );
	IpMsgMutexInit( "SentMessageList::SentMessageList(SentMessageList&)", &messagesMutex, NULL );
	Lock( "SentMessageList::SentMessageList(SentMessageList&)" );
	CopyFrom( other );
	Unlock( "SentMessageList::SentMessageList(SentMessageList&)" );
	IPMSG_FUNC_EXIT;
}

/**
 * ǥȥ饯
 * <ul>
 * <li>ѥåꥹȤå뤿Υߥ塼ƥå˴</li>
 * </ul>
 */
SentMessageList::~SentMessageList()
{
	IPMSG_FUNC_ENTER( "SentMessageList::~SentMessageList()" );
	IpMsgMutexDestroy( "SentMessageList::~SentMessageList()", &messagesMutex );
	IPMSG_FUNC_EXIT;
}

/**
 * 黻ҡ
 * @param other ԡΥ֥
 * @retval 󥹥
 */
SentMessageList&
SentMessageList::operator=( const SentMessageList& other )
{
	IPMSG_FUNC_ENTER( "SentMessageList& SentMessageList::operator=( const SentMessageList& other )" );
	IpMsgMutexInit( "SentMessageList::operator=(SentMessageList&)", &messagesMutex, NULL );
	Lock( "SentMessageList::operator=(SentMessageList&)" );
	CopyFrom( other );
	Unlock( "SentMessageList::operator=(SentMessageList&)" );
	IPMSG_FUNC_RETURN( *this );
}

/**
 * ԡ᥽åɡ
 * @param other ԡΥ֥
 */
void
SentMessageList::CopyFrom( const SentMessageList& other )
{
	IPMSG_FUNC_ENTER( "void SentMessageList::CopyFrom( const SentMessageList& other )" );
	messages = other.messages;
	IPMSG_FUNC_EXIT;
}

/**
 * åꥹȤå
 * @param pos åƤ֤򼨤ʸ
 */
void
SentMessageList::Lock( const char *pos ) const
{
	IPMSG_FUNC_ENTER( "void SentMessageList::Lock( const char *pos ) const" );
	IpMsgMutexLock( pos, const_cast< pthread_mutex_t* >( &messagesMutex ) );
	IPMSG_FUNC_EXIT;
}

/**
 * åꥹȤ򥢥å
 * @param pos åƤ֤򼨤ʸ
 */
void
SentMessageList::Unlock( const char *pos ) const
{
	IPMSG_FUNC_ENTER( "void SentMessageList::Unlock( const char *pos ) const" );
	IpMsgMutexUnlock( pos, const_cast< pthread_mutex_t * >( &messagesMutex ) );
	IPMSG_FUNC_EXIT;
}

/**
 * ѥåꥹȤƬ򼨤ƥ졼֤
 * @retval ѥåꥹȤƬ򼨤ƥ졼
 */
std::vector<SentMessage>::iterator
SentMessageList::begin()
{
	IPMSG_FUNC_ENTER( "std::vector<SentMessage>::iterator SentMessageList::begin()" );
	IPMSG_FUNC_RETURN( messages.begin() );
}

/**
 * ѥåꥹȤܣ򼨤ƥ졼֤
 * @retval ѥåꥹȤܣ򼨤ƥ졼
 */
std::vector<SentMessage>::iterator
SentMessageList::end()
{
	IPMSG_FUNC_ENTER( "std::vector<SentMessage>::iterator SentMessageList::end()" );
	IPMSG_FUNC_RETURN( messages.end() );
}

/**
 * ꤵ줿ƥ졼ѥåѥåꥹȤ롣
 * @param item оݤѥå򼨤ƥ졼
 * @retval 줿ѥåμǤ򼨤ƥ졼
 */
std::vector<SentMessage>::iterator
SentMessageList::erase( std::vector<SentMessage>::iterator item )
{
	IPMSG_FUNC_ENTER( "std::vector<SentMessage>::iterator SentMessageList::erase( std::vector<SentMessage>::iterator item )" );
	Lock( "SentMessageList::erase()" );
	std::vector<SentMessage>::iterator ret = messages.erase( item );
	Unlock( "SentMessageList::erase()" );
	IPMSG_FUNC_RETURN( ret );
}

/**
 * ѥåꥹȤ˥åɲä롣
 * @param item ѥå
 */
void
SentMessageList::append( const SentMessage &item )
{
	IPMSG_FUNC_ENTER( "void SentMessageList::append( const SentMessage &item )" );
	Lock( "SentMessageList::append()" );
	messages.push_back( item );
	Unlock( "SentMessageList::append()" );
	IPMSG_FUNC_EXIT;
}

/**
 * ѥåꥹȤθĿ֤
 * @retval ѥåꥹȤθĿ
 */
int
SentMessageList::size() const
{
	IPMSG_FUNC_ENTER( "int SentMessageList::size() const" );
	Lock( "SentMessageList::size()" );
	int ret = messages.size();
	Unlock( "SentMessageList::size()" );
	IPMSG_FUNC_RETURN( ret );
}

/**
 * ѥåꥹȤ򥯥ꥢ롣
 */
void
SentMessageList::clear()
{
	IPMSG_FUNC_ENTER( "void SentMessageList::clear()" );
	Lock( "SentMessageList::clear()" );
	messages.clear();
	Unlock( "SentMessageList::clear()" );
	IPMSG_FUNC_EXIT;
}

/**
 * ѥåꥹȤΥݥ󥿤֤
 * @retval ѥåꥹȤΥݥ󥿡
 */
std::vector<SentMessage> *
SentMessageList::GetMessageList()
{
	IPMSG_FUNC_ENTER( "std::vector<SentMessage> *SentMessageList::GetMessageList()" );
	IPMSG_FUNC_RETURN( &messages );
}

/**
 * ѥåȤźեե򸡺ޤ
 * <ul>
 * <li>ѥåȤեIDФեIDźեե򸡺AttachFileΥƥ졼֤ޤ</li>
 * </ul>
 * @param packet ѥåȥ֥
 * @retval AttachFileΥƥ졼
 * @retval դʤ硢end()
 */
std::vector<AttachFile>::iterator
SentMessage::FindAttachFileByPacket( const Packet& packet )
{
	IPMSG_FUNC_ENTER( "std::vector<AttachFile>::iterator SentMessage::FindAttachFileByPacket( const Packet& packet )" );
	char *dmyptr;
	char *startptr;
	strtoul( packet.Option().c_str(), &dmyptr, 16 );
	startptr = ++dmyptr;
	int packet_file_id = strtoul( startptr, &dmyptr, 16 );
	startptr = ++dmyptr;

	std::vector<AttachFile>::iterator FoundFile;
	FoundFile = Files().FindByFileId( packet_file_id );
	IPMSG_FUNC_RETURN( FoundFile );
}

/**
 * ȥ饤ޥåСĴ٤
 * @retval true:ȥ饤ޥåС
 * @retval false:СƤʤ
 */
bool
SentMessage::isRetryMaxOver() const
{
	IPMSG_FUNC_ENTER( "bool SentMessage::isRetryMaxOver() const" );
	if ( RetryCount() > SENDMSG_RETRY_MAX ) {
		IPMSG_FUNC_RETURN( true );
	}
	IPMSG_FUNC_RETURN( false );
}

/**
 * ȥ饤ɬפĴ٤
 * @param tryNow ߻
 * @retval true:ȥ饤ɬ
 * @retval false:ȥ饤
 */
bool
SentMessage::needSendRetry( time_t tryNow ) const
{
	IPMSG_FUNC_ENTER( "bool SentMessage::needSendRetry( time_t tryNow ) const" );
	if ( !IsSent() && PrevTry() != tryNow && !IsRetryMaxOver() ) {
		IPMSG_FUNC_RETURN( true );
	}
	IPMSG_FUNC_RETURN( false );
}

/**
 * ѥåNoѥåꥹȤѥåΥƥ졼롣
 * @param PacketNo ѥåNo
 * @retval ѥåΥƥ졼
 * @retval դʤend()
 */
std::vector<SentMessage>::iterator
SentMessageList::FindSentMessageByPacketNo( unsigned long PacketNo )
{
	IPMSG_FUNC_ENTER( "std::vector<SentMessage>::iterator SentMessageList::FindSentMessageByPacketNo( unsigned long PacketNo )" );
	Lock( "SentMessageList::FindSentMessageByPacketNo()" );
	std::vector<SentMessage>::iterator ret = end();
	for( std::vector<SentMessage>::iterator ixmsg = begin(); ixmsg != end(); ixmsg++ ) {
		if ( PacketNo == ixmsg->PacketNo() ) {
			ret = ixmsg;
			break;
		}
	}
	Unlock( "SentMessageList::FindSentMessageByPacketNo()" );
	IPMSG_FUNC_RETURN( ret );
}

/**
 * ѥåȤѥå򸡺ޤ
 * <ul>
 * <li>ѥåȤѥåNoФѥåNoѥå򸡺SentMessageΥƥ졼֤ޤ</li>
 * </ul>
 * @param packet ѥåȥ֥
 * @retval SentMessageΥƥ졼
 * @retval դʤ硢end()
 */
std::vector<SentMessage>::iterator
SentMessageList::FindSentMessageByPacket( Packet packet )
{
	IPMSG_FUNC_ENTER( "std::vector<SentMessage>::iterator SentMessageList::FindSentMessageByPacket( Packet packet )" );
	char *dmyptr;
	char *startptr;
	unsigned long packetNo = strtoul( packet.Option().c_str(), &dmyptr, 16 );
	startptr = ++dmyptr;

	Lock( "SentMessageList::FindSentMessageByPacket()" );
	std::vector<SentMessage>::iterator ret = end();
	for( std::vector<SentMessage>::iterator ixmsg = begin(); ixmsg != end(); ixmsg++ ) {
		if ( packetNo == ixmsg->PacketNo() ) {
			ret = ixmsg;
			break;
		}
	}
	Unlock( "SentMessageList::FindSentMessageByPacket()" );
	IPMSG_FUNC_RETURN( ret );
}

