package jp.sourceforge.lepidolite.dao;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.beanutils.DynaBean;

/**
 * [UDB}l[WB
 *
 */
public class UserDao extends BaseDao {
	
	/**
	 * RXgN^B
	 * 
	 * @param trans gUNVIuWFNg
	 */
	public UserDao(DaoTransaction trans) {
		super(trans);
	}
	
	
	/**
	 * [Üꗗ擾B
	 * 
	 * @return [U񂪐ݒ肳ꂽDynaBeañXgB
	 */
	public List<DynaBean> findUsers() {
		return findByCriteria("select" +
				" user_id, user_name, email" +
				", user_state" +
				" from users" +
				" order by user_id", null);
	}
	
	
	/**
	 * [UIDɑ΂郆[U擾B
	 * 
	 * @param userId [UIDB
	 * @return [UB݂Ȃꍇ<code>null</code>B
	 */
	public DynaBean getUserById(String userId) {
		return getById("select" +
				" u.user_id, u.user_name, u.email" +
				", u.last_changed, u.user_state" +
				", u.updated_at" +
				" from users u" +
				" where u.user_id=?",
				new Object[]{userId});
	}
	
	
	/**
	 * [UVKo^B
	 * 
	 * @param bean [UB
	 * @throws DaoException SQLOꍇB
	 */
	public void createUser(DynaBean bean) {
		try {
			Connection conn = trans.getConnection();
			PreparedStatement stmt = conn.prepareStatement("insert into users (" +
					" user_id, user_name, passwd, email, user_state" +
					", created_by, created_at, updated_by, updated_at" +
					") values (" +
					" ?, ?, ?, ?, ?" +
					", ?, current_timestamp, ?, current_timestamp" +
					")");
			stmt.setObject(1, bean.get("user_id"));
			stmt.setObject(2, bean.get("user_name"));
			stmt.setObject(3, encodePassword((String) bean.get("passwd")));
			stmt.setObject(4, bean.get("email"));
			stmt.setObject(5, bean.get("user_state"));
			stmt.setObject(6, trans.getOwner());
			stmt.setObject(7, trans.getOwner());
			stmt.executeUpdate();
		} catch (SQLException sqle) {
			if ("23505".equals(sqle.getSQLState())) {
				// FIXME Ӑᔽ
				throw new UniqueViolationException("[UID " + bean.get("user_id") + " ͊ɑ݂Ă܂B", sqle);
			} else {
				throw new DaoException("[U̍쐬Ɏs܂B", sqle);
			}
		}
	}
	
	
	/**
	 * [UXVB
	 * 
	 * @param bean [U
	 * @throws OptimisticLockException yϓIbNsꍇB
	 * @throws DaoException SQLOꍇB
	 */
	public void updateUser(DynaBean bean) {
		try {
			// yϓIbN
			DynaBean user = getById("select" +
					" user_id, updated_at" +
					" from users" +
					" where user_id=?" +
					" for update nowait",
					new Object[]{bean.get("user_id")});
			if (user == null || !user.get("updated_at").equals(bean.get("updated_at"))) {
				throw new OptimisticLockException("ʃ[UɂĊɍXVĂ܂");
			}
			
			// XV
			Connection conn = trans.getConnection();
			PreparedStatement stmt = conn.prepareStatement("update users set" +
					" user_name=?, email=?, user_state=?" +
					", updated_by=?, updated_at=current_timestamp" +
					" where user_id=?");
			stmt.setObject(1, bean.get("user_name"));
			stmt.setObject(2, bean.get("email"));
			stmt.setObject(3, bean.get("user_state"));
			stmt.setObject(4, trans.getOwner());
			stmt.setObject(5, bean.get("user_id"));
			stmt.executeUpdate();
		} catch (SQLException sqle) {
			throw new DaoException("[U̍XVɎs܂B", sqle);
		}
	}
	
	
	/**
	 * pX[hύXB
	 * 
	 * ̃\bhł͓͂ꂽlƃpX[ȟݒlr邽߁AXVɂyϓIbNȗB
	 * 
	 * @param bean pX[hB
	 * 			<dl>
	 * 			<dt>user_id</dt>	<dd>pX[hύX郆[Ũ[UIDB</dd>
	 * 			<dt>current</dt>	<dd>݂̃pX[hB</dd>
	 * 			<dt>new1</dt>		<dd>ύXpX[hB</dd>
	 * 			</dl>
	 * @throws IllegalArgumentException ݂̃pX[hႤꍇB
	 */
	public void updatePassword(DynaBean bean) {
		String current = (String) bean.get("current");
		String new1 = (String) bean.get("new1");
		
		// yϓIbN
		DynaBean user = getById("select" +
				" passwd" +
				" from users" +
				" where user_id=?" +
				" for update nowait",
				new Object[]{bean.get("user_id")});
		if (user == null) {
			throw new OptimisticLockException("[U݂܂B");
		}
		
		// Ó`FbN
		if (!encodePassword(current).equals(user.get("passwd"))) {
			throw new IllegalArgumentException("݂̃pX[hႢ܂B");
		}
		
		try {
			// XV
			Connection conn = trans.getConnection();
			PreparedStatement stmt = conn.prepareStatement("update users set" +
					" passwd=?" +
					", updated_by=?, updated_at=current_timestamp" +
					" where user_id=?");
			stmt.setObject(1, encodePassword(new1));
			stmt.setObject(2, trans.getOwner());
			stmt.setObject(3, bean.get("user_id"));
			stmt.executeUpdate();
		} catch (SQLException sqle) {
			throw new DaoException("pX[h̍XVɎs܂B", sqle);
		}
	}
	
	
	/**
	 * pX[h̃nbVlԂB
	 * 
	 * @param passwd v[ȃpX[hB
	 * @return pX[h16i\L̃nbVl
	 */
	private String encodePassword(String passwd) {
		try {
			MessageDigest md = MessageDigest.getInstance("SHA-1");
			md.update(passwd.getBytes());
			byte[] digest = md.digest();
			return toHexString(digest);
		} catch (NoSuchAlgorithmException nsae) {
			throw new DaoException("_CWFXgׂ̈̃ASY擾ł܂B", nsae);
		}
	}
	
	
	/**
	 * oCg^̔z16i֕ϊB
	 * 
	 * @param bytes ϊ̃oCg^z
	 * @return 16iB
	 */
	private String toHexString(byte[] bytes) {
		final char[] digit = {
				'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'
		};
		StringBuilder buf = new StringBuilder();
		for (int b : bytes) {
			if (b < 0) {
				b += 256;
			}
			buf.append(digit[b / 16]);
			buf.append(digit[b % 16]);
		}
		return buf.toString();
	}
}
