package jp.sourceforge.lepidolite.actions;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.lepidolite.dao.DaoException;
import jp.sourceforge.lepidolite.dao.DaoTransaction;
import jp.sourceforge.lepidolite.dao.DaoTransactionFactory;
import jp.sourceforge.lepidolite.dao.GroupDao;
import jp.sourceforge.lepidolite.dao.OptimisticLockException;
import jp.sourceforge.lepidolite.dao.UniqueViolationException;
import jp.sourceforge.lepidolite.dao.UserDao;

import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.EventDispatchAction;
import org.apache.struts.validator.LazyValidatorForm;

/**
 * [UǗsANVNXB
 *
 */
public class UsersAction extends EventDispatchAction {
	
	/**
	 * ꗗ\sB
	 * 
	 * @param mapping ActionMappingB
	 * @param form NGXgɊ܂܂ActionForm BeanB
	 * @param request NGXgB
	 * @param response X|XB
	 * @return JڐB
	 */
	public ActionForward manipulator(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {
		
		DaoTransaction trans = DaoTransactionFactory.getTransaction(request.getRemoteUser());
		try {
			// ꗗ\
			UserDao dao = new UserDao(trans);
			List<DynaBean> users = dao.findUsers();
			request.setAttribute("users", users);
		} catch (DaoException de) {
			// Oo
			LogFactory.getLog(getClass()).error("FUSM001", de);
			// G[bZ[Wۑ
			ActionErrors errors = new ActionErrors();
			errors.add(Globals.ERROR_KEY, new ActionMessage("FUSM001"));
			saveErrors(request, errors);
		} finally {
			trans.close();
		}
		return mapping.findForward("manipulator");
	}
	
	
	/**
	 * VKo^ʂ̏\sB
	 * 
	 * @param mapping ActionMappingB
	 * @param form NGXgɊ܂܂ActionForm BeanB
	 * @param request NGXgB
	 * @param response X|XB
	 * @return JڐB
	 */
	public ActionForward entry(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {
		// g[Nۑ
		saveToken(request);
		// ̃[Uݒ
		request.setAttribute("user", new LazyDynaBean());
		// gDݒ
		DaoTransaction trans = DaoTransactionFactory.getTransaction(request.getRemoteUser());
		try {
			GroupDao groupDao = new GroupDao(trans);
			List<DynaBean> groups = groupDao.findGroups();
			request.setAttribute("groups", groups);
		} finally {
			trans.close();
		}
		return mapping.findForward("entry");
	}
	
	
	/**
	 * VKo^sB
	 * 
	 * @param mapping ActionMappingB
	 * @param form NGXgɊ܂܂ActionForm BeanB
	 * @param request NGXgB
	 * @param response X|XB
	 * @return JڐB
	 */
	public ActionForward create(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {
		LazyValidatorForm f = (LazyValidatorForm) form;
		
		DaoTransaction trans = DaoTransactionFactory.getTransaction(request.getRemoteUser());
		try {
			// ͏̍Đݒ
			request.setAttribute("user", form);
			// gDݒ
			GroupDao groupDao = new GroupDao(trans);
			List<DynaBean> groups = groupDao.findGroups();
			request.setAttribute("groups", groups);
			
			// g[NmF
			if (!isTokenValid(request, true)) {
				// G[bZ[Wۑ
				ActionErrors errors = new ActionErrors();
				errors.add(Globals.ERROR_KEY, new ActionMessage("errors.token"));
				saveErrors(request, errors);
				// g[Nۑ
				saveToken(request);
				return mapping.getInputForward();
			}
			
			// g[Nۑ
			saveToken(request);
			
			// Ó`FbN
			ActionErrors errors = f.validate(mapping, request);
			if (!errors.isEmpty()) {
				// G[bZ[Wۑ
				saveErrors(request, errors);
				return mapping.getInputForward();
			}
			
			// [Uo^
			UserDao userDao = new UserDao(trans);
			userDao.createUser(f);
			// O[vւ̒ǉ
			groupDao.addUser(f);
			trans.commit();
			
			// ʏ탁bZ[Wۑ
			ActionMessages messages = new ActionMessages();
			messages.add(Globals.MESSAGE_KEY, new ActionMessage("MUSU004"));
			saveMessages(request, messages);
			
			// [U̍Ď擾
			DynaBean user = userDao.getUserById((String) f.get("user_id"));
			DynaBean parent = groupDao.getParentByPartyId((String) f.get("user_id"));
			if (parent != null) {
				user.set("parent_id", parent.get("party_id"));
			}
			request.setAttribute("user", user);
		} catch (UniqueViolationException uve) {
			// [UIDɎgpĂꍇ
			// G[bZ[Wۑ
			ActionErrors errors = new ActionErrors();
			errors.add(Globals.ERROR_KEY, new ActionMessage("EUSC002", f.get("user_id")));
			saveErrors(request, errors);
			return mapping.getInputForward();
		} catch (DaoException de) {
			Logger.getLogger(getClass()).error("[UXVł܂ł", de);
			// G[bZ[Wۑ
			ActionErrors errors = new ActionErrors();
			errors.add(Globals.ERROR_KEY, new ActionMessage("FUSC003"));
			saveErrors(request, errors);
			return mapping.getInputForward();
		} finally {
			trans.close();
		}
		
		return mapping.findForward("create");
	}
	
	
	/**
	 * ҏWʂ̏\sB
	 * 
	 * @param mapping ActionMappingB
	 * @param form NGXgɊ܂܂ActionForm BeanB
	 * @param request NGXgB
	 * @param response X|XB
	 * @return JڐB
	 */
	public ActionForward edit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {
		
		LazyValidatorForm f = (LazyValidatorForm) form;
		DaoTransaction trans = DaoTransactionFactory.getTransaction(request.getRemoteUser());
		try {
			String userId = (String) f.get("user_id");
			
			// [U̎擾
			UserDao userDao = new UserDao(trans);
			DynaBean user = userDao.getUserById(userId);
			request.setAttribute("user", user);
			
			// gDݒ
			GroupDao groupDao = new GroupDao(trans);
			DynaBean parent = groupDao.getParentByPartyId(userId);
			if (parent != null) {
				user.set("parent_id", parent.get("party_id"));
			}
			List<DynaBean> groups = groupDao.findGroups();
			request.setAttribute("groups", groups);
		} catch (DaoException de) {
			ActionErrors errors = new ActionErrors();
			errors.add(Globals.ERROR_KEY, new ActionMessage("FUSU005"));
			saveErrors(request, errors);
			Logger.getLogger(getClass()).error("[U擾ł܂ł", de);
		} finally {
			trans.close();
		}
		// g[N̕ۑ
		saveToken(request);
		return mapping.findForward("edit");
	}
	
	
	/**
	 * XVsB
	 * 
	 * @param mapping ActionMappingB
	 * @param form NGXgɊ܂܂ActionForm BeanB
	 * @param request NGXgB
	 * @param response X|XB
	 * @return JڐB
	 */
	public ActionForward update(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {
		
		LazyValidatorForm f = (LazyValidatorForm) form;
		
		DaoTransaction trans = DaoTransactionFactory.getTransaction(request.getRemoteUser());
		try {
			// ͏̍Đݒ
			request.setAttribute("user", f);
			// gDݒ
			GroupDao groupDao = new GroupDao(trans);
			List<DynaBean> groups = groupDao.findGroups();
			request.setAttribute("groups", groups);
			
			// g[NmF
			if (!isTokenValid(request, true)) {
				// G[bZ[Wۑ
				ActionErrors errors = new ActionErrors();
				errors.add(Globals.ERROR_KEY, new ActionMessage("errors.token"));
				saveErrors(request, errors);
				// g[Nۑ
				saveToken(request);
				return mapping.getInputForward();
			}
			// g[Nۑ
			saveToken(request);
			
			// Ó`FbN
			ActionErrors errors = f.validate(mapping, request);
			if (!errors.isEmpty()) {
				// G[bZ[Wۑ
				saveErrors(request, errors);
				return mapping.getInputForward();
			}
			
			// [UXV
			UserDao userDao = new UserDao(trans);
			userDao.updateUser(f);
			// O[vXV
			groupDao.deleteUser(f);
			groupDao.addUser(f);
			trans.commit();
			
			// XV̌㏈ݒ
			ActionMessages messages = new ActionMessages();
			messages.add(Globals.MESSAGE_KEY, new ActionMessage("MUSU007"));
			saveMessages(request, messages);
			
			String userId = (String) f.get("user_id");
			// [U̍Ď擾
			DynaBean user = userDao.getUserById(userId);
			DynaBean parent = groupDao.getParentByPartyId(userId);
			if (parent != null) {
				user.set("parent_id", parent.get("party_id"));
			}
			request.setAttribute("user", user);
		} catch (OptimisticLockException ole) {
			ActionErrors errors = new ActionErrors();
			errors.add(Globals.ERROR_KEY, new ActionMessage("errors.optimisticlock"));
			saveErrors(request, errors);
		} catch (DaoException de) {
			Logger.getLogger(getClass()).error("[UXVł܂ł", de);
			ActionErrors errors = new ActionErrors();
			errors.add(Globals.ERROR_KEY, new ActionMessage("FUSU006"));
			saveErrors(request, errors);
		} finally {
			trans.close();
		}
		return mapping.findForward("update");
	}
}
