/****************************************************************************/
/* The developnent of this program is partly supported by IPA.              */
/* (Infomation-Technology Promotion Agency, Japan).                         */
/****************************************************************************/

/****************************************************************************/
/*  log2list.c                                                              */
/*  Copyright : Copyright (C) 2006 ALPHA SYSTEMS INC.                       */
/*  Authors : TAN Hideyuki(tanh@alpha.co.jp)                                */
/*            ALPHA SYSTEMS INC. knoppix team(knoppix@alpha.co.jp)          */
/*                                                                          */
/*  This is free software; you can redistribute it and/or modify            */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This software is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this software; if not, write to the Free Software            */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/*  USA.                                                                    */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <errno.h>

#include "log2list.h"
#include "cloop_optimizer.h"

#define TOTAL_BLOCKS_LINE "total blocks :"

#define BUFLEN 512

extern float opt_progress;
extern int do_optimize;

void (*progress)(void*);
void *progress_args;

struct blk_info {
  unsigned int num;
  unsigned int size;
};

int read_listfile(const char *list_file,
		  struct blk_info** blk_lists, unsigned int* read_count,
		  unsigned int* total_blocks) {

  FILE *fp;
  char buf[BUFLEN];
  int len = 0;
  int i, j;

  fp = fopen(list_file, "r");
  if (! fp) {
    fprintf(stderr, "%s : fopen err.\n", list_file);
    exit(1);
  }

  *total_blocks = 0;
  *read_count = 0;
  *blk_lists = NULL;

  while(fgets(buf, 512, fp) != 0) {
    if (*read_count > *total_blocks) break;
    len = strlen(buf);
    buf[len -1] = '\0';

    if (*read_count == 0 && *blk_lists == NULL) {
      if (strncmp(TOTAL_BLOCKS_LINE, buf, strlen(TOTAL_BLOCKS_LINE)) == 0) {
	for(i = 0, j = sizeof(TOTAL_BLOCKS_LINE); i < len; i++, j++) buf[i] = buf[j];
	buf[j++] = '\0';
	*total_blocks = atoi(buf);
	*blk_lists = malloc(sizeof(struct blk_info) * (*total_blocks));
	if (! *blk_lists) {
	  fprintf(stderr, "blk_lists : malloc err.\n");
	  exit(1);
	}
	memset(*blk_lists, 0, sizeof(struct blk_info) * (*total_blocks));
      }
      continue;
    }

    for (i = 0; i < len; i++)
      if (! (isdigit(buf[i]) || buf[i] == '.' || buf[i] == ' ')) break;

    if (i == len -1) { // ok line.

      char *work = strtok(buf, " ");
      if (! work) break;
      int no = atoi(work);
      if (no > *total_blocks) break;

      int array = 0;
      int blk_num = 0, blk_size = 0;
      for (array++; ; array++) {
	work = strtok(NULL, " ");
	if (! work) break;
	if (array == 1) {
	  blk_num = atoi(work);
	  continue;
	}
	if (array == 2) {
	  blk_size = atoi(work);
	  break;
	}
      }

      if (blk_num > *total_blocks) continue;
      
      for (i = 0; i < *read_count; i++)
	if ((*blk_lists)[i].num == blk_num) break;
      if (i != *read_count) continue; // found

      (*blk_lists)[*read_count].num = blk_num;
      (*blk_lists)[*read_count].size = blk_size;
      (*read_count)++;
    }
  }
  fclose(fp);

  return 0;
}

int write_readahead_list(const char* output_file,
			 struct blk_info** out_blk_lst, unsigned int out_blk_cnt,
			 unsigned int burst_size) {

  unsigned count = 0, n = 0;
  unsigned int sum = 0, total_sum = 0;
  FILE *fp = NULL;
  if (output_file) {
    fp = fopen(output_file, "w");
    if (! fp) {
      fprintf(stderr, "%s : fopen err.\n", output_file);
      exit(1);
    }
  } else {
    fp = stdout;
  }

  fprintf(fp, "# burst_size = %u (%u KB)\n", burst_size, burst_size/1024);
  fprintf(fp, "burst_start\n");
  for(count = 0; count < out_blk_cnt; count++, n++) {
    if ((*out_blk_lst)[count].size == 0) continue;
    if (count != 0 && sum + (*out_blk_lst)[count +1].size > burst_size) {
      fprintf(fp, "# block = %u, size = %u\n",n, sum);
      fprintf(fp, "burst_end\n");
      if ((*out_blk_lst)[count +1].size != 0)
	fprintf(fp, "burst_start\n");
      n = 0;
      sum = 0;
    }
    //    fprintf(fp, "%u\t%u\t%u\t%u\n", count, (*out_blk_lst)[count].num, (*out_blk_lst)[count].size, sum);
    fprintf(fp, "%u\n", (*out_blk_lst)[count].num);
    sum += (*out_blk_lst)[count].size;
    total_sum += (*out_blk_lst)[count].size;
  }

  if (sum != 0) {
    fprintf(fp, "# block = %u, size = %u\n",n, sum);
    fprintf(fp, "burst_end\n");
  }
  fprintf(fp, "# total size = %u (%0.2f MB)\n", total_sum, 1.0 * total_sum/1024/1024);

  fclose(fp);

  return 0;
}


int rblkstat2list(char* input_file, char* output_file, unsigned int burst_size,
		  void (*progress)(void *), void* progress_arg) {

  struct blk_info *blk_lists = NULL;
  unsigned int read_count = 0;
  unsigned int tmp;

  // input
  read_listfile(input_file, &blk_lists, &read_count, &tmp);

  // output
  write_readahead_list(NULL, &blk_lists, read_count, burst_size);

  free(blk_lists);

  return 0;
}

int appstat2list(char* boot_blk_file, char** appli_blk_files, int appli_blk_count,
		 char* output_file, unsigned int burst_size,
		 void (*progress)(void *), void* progress_arg) {

  int i, j, k;
  struct blk_info *boot_blk_lst = NULL;
  unsigned int total_blks = 0;
  unsigned int boot_blk_cnt = 0;
  unsigned int tmp;

  // input 1
  read_listfile(boot_blk_file, &boot_blk_lst, &boot_blk_cnt, &total_blks);

  // input 2
  unsigned int out_blk_cnt = 0;
  struct blk_info *out_blk_lst = malloc(sizeof(struct blk_info) * total_blks);
  if (! out_blk_lst) {
    fprintf(stderr, "out_blk_lst malloc err.\n");
    exit(1);
  }

  for (i = 0; i < appli_blk_count; i++) {
    unsigned int tmp_blk_cnt = 0;
    struct blk_info *tmp_blk_lst = NULL;

    read_listfile(appli_blk_files[i], &tmp_blk_lst, &tmp_blk_cnt, &tmp);

    for (j = 0; j < tmp_blk_cnt; j++) {

      // boot block check
      for (k = 0; k < boot_blk_cnt; k++)
	if (boot_blk_lst[k].num == tmp_blk_lst[j].num) break;
      if (k != boot_blk_cnt) continue; // mikke.

      // out block check
      for (k = 0; k < out_blk_cnt; k++)
	if (out_blk_lst[k].num == tmp_blk_lst[j].num) break;
      if (k != out_blk_cnt) continue; // mikke.

      // append
      out_blk_lst[out_blk_cnt].num = tmp_blk_lst[j].num;
      out_blk_lst[out_blk_cnt].size = tmp_blk_lst[j].size;
      out_blk_cnt++;
    }
  }

  //  for(i = 0; i < out_blk_cnt; i++)
  //    printf("[%u]: num = %u, size = %u\n", i, out_blk_lst[i].num, out_blk_lst[i].size);

  // output
  write_readahead_list(NULL, &out_blk_lst, out_blk_cnt, burst_size);

  return 0;
}

