/****************************************************************************/
/* The developnent of this program is partly supported by IPA.              */
/* (Infomation-Technology Promotion Agency, Japan).                         */
/****************************************************************************/

/****************************************************************************/
/*  extract_compressed_opt_fs.c                                             */
/*  Copyright : Copyright (C) 2006 ALPHA SYSTEMS INC.                       */
/*  Authors   : TAN Hideyuki (tanh@alpha.co.jp)                             */
/*              ALPHA SYSTEMS INC. knoppix team (knoppix@alpha.co.jp)       */
/*                                                                          */
/*  This is free software; you can redistribute it and/or modify            */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This software is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this software; if not, write to the Free Software            */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/*  USA.                                                                    */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <netinet/in.h>
#include <string.h>
#include <zlib.h>
#include <ctype.h>

#include "compressed_loop.h"
#include "cloop_optimizer.h"

int main(int argc, char **argv) {

  //
  int clofd;
  struct cloop_head header;
  unsigned int total_offsets;
  struct block_info *blk_info_tbl;

  unsigned int i;

  //
  unsigned long blk_len = 0;
  void *blk_data = NULL;
  unsigned long ubuflen = 0;
  void *ubuf = NULL;

  // argc check.
  if (argc != 2) {
    fprintf(stderr, "%s : Usage <optimized cloop file>\n", argv[0]);
    exit(1);
  }

  // cloop open
  clofd = open(argv[1], O_RDONLY);
  if (clofd < 0) {
    fprintf(stderr, "cloop file open error.\n");
    exit(1);
  }

  // header read
  if (read(clofd, &header, sizeof(struct cloop_head))
      != sizeof(struct cloop_head)) {
    fprintf(stderr, "header read error.\n");
    exit(1);
  }

  // version check
  if (strcmp(header.preamble, CLOOP_OPT_PREAMBLE) != 0) {
    fprintf(stderr, "%s is not optimized cloop image.\n", argv[1]);
    exit(1);
  }

  fprintf(stderr, "blocksize: %u, blocknumber: %u\n",
	  ntohl(header.block_size), ntohl(header.num_blocks));


  // offsets read
  total_offsets = ntohl(header.num_blocks) + 1;

  blk_info_tbl = malloc(sizeof(struct block_info) * total_offsets);
  if (! blk_info_tbl) {
    fprintf(stderr, "block_info table malloc error.\n");
    exit(1);
  }
  if (read(clofd, blk_info_tbl, (sizeof(struct block_info) * total_offsets))
	  != (sizeof(struct block_info) * total_offsets)) {
    fprintf(stderr, "block_info table read error.\n");
    exit(1);
  }

  ubuflen = ntohl(header.block_size);
  ubuf = malloc(ubuflen);
  if (! ubuf) {
    fprintf(stderr, "ubuff malloc error.\n");
    exit(1);
  }

  blk_data = malloc(ntohl(header.block_size) + ntohl(header.block_size)/1000 + 12 + 4);
  if (! blk_data) {
    fprintf(stderr, "blk_data malloc error.\n");
    exit(1);
  }

  for(i = 0; i < total_offsets -1; i++) {
    int ret = 0;
    blk_len = ntohl(blk_info_tbl[i].size);

    ret = lseek(clofd, be64_to_cpu(blk_info_tbl[i].offset), SEEK_SET);
    if (ret < 0) {
      fprintf(stderr, "seek error.\n");
      exit(1);
    }

    ret = read(clofd, blk_data, blk_len);
    if (ret < 0) {
      fprintf(stderr, "read error.\n");
      exit(1);
    }

    ret = uncompress(ubuf, &ubuflen, blk_data, blk_len);

    switch (ret) {
    case Z_OK:
      break;
    case Z_MEM_ERROR:
      fprintf(stderr, "Uncomp: oom block %u\n", i);
      exit(1);
    case Z_BUF_ERROR:
      fprintf(stderr, "Uncopm: not enough out room %u\n", i);
      exit(1);
    case Z_DATA_ERROR:
      fprintf(stderr, "Uncomp: input corrupt %u\n", i);
      exit(1);
    default:
      fprintf(stderr, "Uncomp: unknown error %u\n", i);
      exit(1);
    }

    fprintf(stderr, "%05u/%05u: %2.03f%%, %lu => %lu\n", i +1, total_offsets -1,
	    i /  (float)(total_offsets -1) * 100, blk_len, ubuflen);

    if (ubuflen != ntohl(header.block_size)) {
      fprintf(stderr, "Uncomp: bad len %u (%lu not %u)\n", i, ubuflen, ntohl(header.block_size));
      exit(1);
    }

    write(STDOUT_FILENO, ubuf, ubuflen);

  }

  free(ubuf);
  free(blk_data);

  free(blk_info_tbl);

  exit(0);
}

