#ifndef _COMPRESSED_LOOP_H
#define _COMPRESSED_LOOP_H

#define CLOOP_HEADROOM 128

/* The cloop header usually looks like this:          */
/* #!/bin/sh                                          */
/* #V2.00 Format                                      */
/* ...padding up to CLOOP_HEADROOM...                 */
/* block_size (32bit number, network order)           */
/* num_blocks (32bit number, network order)           */

struct cloop_head
{
	char preamble[CLOOP_HEADROOM];
	u_int32_t block_size;
	u_int32_t num_blocks;
};

#ifdef DEFAULT_CLOOP

/* data_index (num_blocks 64bit pointers, network order)...      */
/* compressed data (gzip block compressed format)...             */

#else

/*                                                               */
/* optimized block offsets supported format                      */
/*                                                               */
/* CLOOP_HEADROOM contains "OPT" string.                         */
/*                                                               */
/* block information index (num_blocks)...                       */
/* compressed data (gzip block compressed format)...             */

struct block_info
{
  loff_t offset;    /* 64-bit offsets of compressed block : network order */
  u_int32_t size;   /* 32-bit compressed block size : network order */
  u_int32_t optidx; /* 32-bit index number : network order */
};

#endif

#endif /*_COMPRESSED_LOOP_H*/
