/****************************************************************************/
/* The developnent of this program is partly supported by IPA.              */
/* (Infomation-Technology Promotion Agency, Japan).                         */
/****************************************************************************/

/****************************************************************************/
/*  cloop.h                                                                 */
/*  Copyright : Copyright (C) 2006 ALPHA SYSTEMS INC.                       */
/*  Authors : Daisuke Abe (abeda@alpha.co.jp)                               */
/*           ALPHA SYSTEMS INC. knoppix team(knoppix@alpha.co.jp)           */
/*                                                                          */
/*  This is free software; you can redistribute it and/or modify            */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This software is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this software; if not, write to the Free Software            */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/*  USA.                                                                    */
/****************************************************************************/

#ifndef _CLOOP_H
#define _CLOOP_H
#include "compressed_loop.h"

static __inline __uint64_t
__bswap64 (__uint64_t _x)
{

  return ((_x >> 56) | ((_x >> 40) & 0xff00) | ((_x >> 24) & 0xff0000) |
	  ((_x >> 8) & 0xff000000) | ((_x << 8) & ((__uint64_t) 0xff << 32)) |
	  ((_x << 24) & ((__uint64_t) 0xff << 40)) |
	  ((_x << 40) & ((__uint64_t) 0xff << 48)) | ((_x << 56)));
}

#define be64toh(x)      __bswap64(x)
#define be64_to_cpu be64toh

/* 
 * __func__ for Debug
 *
 * usage: dbg(const char *format, ...);
 */
#define dbg(...) \
  (printf("%s %u @%s:",__FILE__,__LINE__,__func__), \
   printf(" "__VA_ARGS__))

struct blk_data
{
  unsigned int no;
  unsigned int size;
  void *data;
};

struct blk_data_2
{
  unsigned int no;
  unsigned int size;
  unsigned long offset;
};

#endif // _CLOOP_H
