/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.ArrayList;
import java.util.Iterator;
import latte.model.LM13Actor;
import latte.model.LM13Class;
import latte.model.LM13ClassifierRole;
import latte.model.LM13DiagramElement2;
import latte.model.LM13Interface;
import latte.model.LM13Message;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.view.LVConst;
import latte.view.LVDiagFigure;
import latte.view.LVSeqDiag;
import latte.view.LVSeqDiagActorFigure;
import latte.view.LVSeqDiagClassFigure;
import latte.view.LVSeqDiagInterfaceFigure;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public abstract class LVSeqDiagFigure
extends LVDiagFigure {
    protected Label classNameLabel_ = new Label();
    protected RectangleFigure lifeLine_ = new RectangleFigure();
    static final int ACTIVELINE_WIDTH = 10;
    static final int ACTIVELINE_HEIGHT = 30;
    private ArrayList activelineList_ = new ArrayList();
    static final int FIGURE_Y = 20;

    public LVSeqDiagFigure(LVSeqDiag lvSeqDiag, LM13DiagramElement2 lmDiagElement) {
        super(lvSeqDiag, lmDiagElement);
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setBorder(null);
        Point p = this.getLocation();
        this.setLocation(new Point(p.x, 20));
    }

    void updateFigure() {
    }

    void updateFigure(boolean contens) {
    }

    protected static LVSeqDiagFigure createFigure(LVSeqDiag parent, LM13DiagramElement2 lmDiagElement) {
        Object o = ModelUtil.getModel(lmDiagElement);
        if (!(o instanceof LM13ClassifierRole)) {
            LogUtil.writeln("Class=" + o.getClass().getName());
            throw new IllegalArgumentException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u306a\u3044\u5f15\u6570\u3067\u3059");
        }
        LVSeqDiagFigure createdFigure = null;
        LM13ClassifierRole cRole = (LM13ClassifierRole)o;
        Object model = ModelUtil.getModel(cRole);
        if (model instanceof LM13Class) {
            createdFigure = new LVSeqDiagClassFigure(parent, lmDiagElement);
        } else if (model instanceof LM13Interface) {
            createdFigure = new LVSeqDiagInterfaceFigure(parent, lmDiagElement);
        } else if (model instanceof LM13Actor) {
            createdFigure = new LVSeqDiagActorFigure(parent, lmDiagElement);
        } else {
            LogUtil.writeln("Class=" + model.getClass().getName());
            throw new IllegalArgumentException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044lmDiagElement\u306e\u578b\u3067\u3059");
        }
        ((LVSeqDiagFigure)createdFigure).createFigureContents();
        return createdFigure;
    }

    protected void createFigureContents() {
        LM13ClassifierRole cRole = (LM13ClassifierRole)ModelUtil.getModel(this.lmDiagElement_);
        String name = ModelUtil.getName(cRole);
        this.classNameLabel_.setText(name);
        this.classNameLabel_.setOpaque(true);
        this.classNameLabel_.setBackgroundColor(LVConst.ClassBackColor);
        this.classNameLabel_.setBorder((Border)new SchemeBorder(SchemeBorder.SCHEMES.ETCHED));
        int x = GuiUtil.stringExtent(name) / 2 + 10;
        int y = this.classNameLabel_.getLocation().y + 25;
        this.lifeLine_.setLineStyle(3);
        this.lifeLine_.setBounds(new Rectangle(x, y, 1, 2048));
        GuiUtil.addFigure((IFigure)this, (IFigure)this.classNameLabel_);
        GuiUtil.addFigure((IFigure)this, (IFigure)this.lifeLine_);
    }

    public Activeline getActivelineTaraceback(LM13Message message) {
        String[] pre = message.getPredecessor();
        if (pre != null && pre.length > 0) {
            LM13Message preMsg = (LM13Message)ModelUtil.getModel(pre[0]);
            Activeline activeline = this.getActiveline(preMsg.getXmiId());
            if (activeline == null) {
                return this.getActivelineTaraceback(preMsg);
            }
            return activeline;
        }
        throw new IllegalArgumentException("\u30e1\u30c3\u30bb\u30fc\u30b8\u306b\u5bfe\u5fdc\u3057\u305f\u30a2\u30af\u30c6\u30a3\u30d6\u304c\u767a\u898b\u3067\u304d\u306a\u3044\u3002\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
    }

    public Activeline getActiveline(String msgXmiid) {
        Iterator ite = this.activelineList_.iterator();
        Activeline activeline = null;
        while (ite.hasNext()) {
            activeline = (Activeline)((Object)ite.next());
            if (!activeline.getMessage().getXmiId().equals(msgXmiid)) continue;
            return activeline;
        }
        return activeline;
    }

    public IFigure addActiveline(LM13Message message, int y) {
        LogUtil.writeln("activeline.y = " + y);
        int x = this.lifeLine_.getLocation().x + 5 * (this.getRecursiveCount(message.getReceiver(0), message, 0) - 1);
        int height = 30 * this.getChainCount(message, 1);
        if (message.getSender(0).equals(ModelUtil.getModel(this.lmDiagElement_))) {
            height += 30;
        }
        int width = 10;
        Activeline activeline = new Activeline(message);
        activeline.setBounds(new Rectangle(x, y, width, height));
        GuiUtil.addFigure((IFigure)this, (IFigure)activeline);
        this.activelineList_.add(activeline);
        return activeline;
    }

    private int getRecursiveCount(String targetXmiid, LM13Message message, int n) {
        String[] pre;
        if (message.getSender(0).equals(targetXmiid)) {
            ++n;
        }
        if ((pre = message.getPredecessor()) != null && pre.length > 0) {
            LM13Message preMsg = (LM13Message)ModelUtil.getModel(pre[0]);
            return this.getRecursiveCount(targetXmiid, preMsg, n);
        }
        return n;
    }

    private int getChainCount(LM13Message message, int count) {
        String[] mes3xmiid = message.getMessage3();
        if (mes3xmiid != null && mes3xmiid.length > 0) {
            LM13Message nextMessage = (LM13Message)ModelUtil.getModel(mes3xmiid[0]);
            return this.getChainCount(nextMessage, count + 1);
        }
        return count;
    }

    public LM13DiagramElement2 getDiagElement() {
        return this.lmDiagElement_;
    }

    public Object getModel() {
        return ModelUtil.getModel(this.lmDiagElement_);
    }

    static class Activeline
    extends RectangleFigure {
        private LM13Message lmMessage_;

        Activeline(LM13Message lmMessage) {
            this.lmMessage_ = lmMessage;
        }

        LM13Message getMessage() {
            return this.lmMessage_;
        }
    }

    static class LifelineAnchor
    extends AbstractConnectionAnchor {
        public LifelineAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(this.getBox());
            r.translate(-1, -1);
            r.resize(1, 1);
            this.getOwner().translateToAbsolute((Translatable)r);
            float centerX = (float)r.x + 0.5f * (float)r.width;
            float centerY = (float)r.y + 0.5f * (float)r.height;
            return new Point((int)centerX, (int)centerY + 2000);
        }

        protected Rectangle getBox() {
            return this.getOwner().getBounds();
        }

        public Point getReferencePoint() {
            if (this.getOwner() == null) {
                return null;
            }
            Point ref = this.getBox().getCenter();
            this.getOwner().translateToAbsolute((Translatable)ref);
            return ref;
        }
    }
}

