/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.LMChangedEvent;
import latte.action.AllAction;
import latte.model.LM13ClassifierRole;
import latte.model.LM13Diagram;
import latte.model.LM13DiagramElement1;
import latte.model.LM13DiagramElement2;
import latte.model.LM13Message;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import latte.view.LVDiag;
import latte.view.LVSeqDiagConnection;
import latte.view.LVSeqDiagFigure;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class LVSeqDiag
extends LVDiag {
    LVSeqDiag(LM13Diagram lmDiag) {
        super(lmDiag);
        this.createDiagContent();
    }

    void createDiagContent() {
        LogUtil.writeln("<!-- <<<<<<<<  \u30b7\u30fc\u30b1\u30f3\u30b9\u56f3\u30b3\u30f3\u30c6\u30f3\u30c4\u4f5c\u6210 >>>>>>> -->");
        LM13DiagramElement1 de1 = ModelUtil.getDiagramElement(this.getLmDiag());
        LM13DiagramElement2[] de2 = de1.getDiagramElement();
        LogUtil.writeln("<!-- <<<<<<<<  FIGURE\u4f5c\u6210 >>>>>>> -->");
        int i = 0;
        while (i < de2.length) {
            this.addFigure(de2[i]);
            ++i;
        }
        LogUtil.writeln("<!-- <<<<<<<<  CONNECTION\u4f5c\u6210 >>>>>>> -->");
        i = 0;
        while (i < de2.length) {
            this.addMessage(de2[i]);
            ++i;
        }
        LogUtil.writeln("<!-- <<<<<<<<  NOTELINK\u4f5c\u6210 >>>>>>> -->");
        i = 0;
        while (i < de2.length) {
            ++i;
        }
    }

    private void addFigure(LM13DiagramElement2 diagElement) {
        LogUtil.writeln("\n");
        Object modelElement = ModelUtil.getModel(diagElement);
        try {
            LogUtil.write("Model\u4f5c\u6210 Class=" + modelElement.getClass().getName());
            LogUtil.write("  Xmiid=" + diagElement.getXmiId());
            if (!(modelElement instanceof LM13ClassifierRole)) {
                LogUtil.writeln("<-\u3053\u306e\u30af\u30e9\u30b9\u306f\u4f5c\u6210\u3057\u306a\u3044");
                return;
            }
            this.addDiagElement(diagElement);
            LVSeqDiagFigure lvDiagFig = LVSeqDiagFigure.createFigure(this, diagElement);
            GuiUtil.addFigure((IFigure)this.getDraw2dView(), (IFigure)lvDiagFig);
            LogUtil.writeln("\u6210\u529f\uff01");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LogUtil.writeln("\u5931\u6557\uff01");
            LogUtil.writeln(e.getMessage());
            MsgUtil.showMsg("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.getMessage());
        }
    }

    private void addMessage(LM13DiagramElement2 diagElement) {
        LogUtil.writeln("\n");
        Object modelElement = ModelUtil.getModel(diagElement);
        Point location = ModelUtil.getLocation(diagElement);
        try {
            int receiverDy;
            int senderDy;
            MessageRouter router;
            IFigure receiveActiveline;
            LVSeqDiagFigure.Activeline sendActiveline;
            LogUtil.write("Model\u4f5c\u6210 Class=" + modelElement.getClass().getName());
            LogUtil.write("  Xmiid=" + diagElement.getXmiId());
            if (modelElement instanceof LM13Message) {
                this.addDiagElement(diagElement);
                LM13Message message = (LM13Message)modelElement;
                String senderXmiid = message.getSender(0);
                String receiverXmiid = message.getReceiver(0);
                LVSeqDiagFigure sendFigure = (LVSeqDiagFigure)this.lookupFigure(senderXmiid);
                LVSeqDiagFigure receiveFigure = (LVSeqDiagFigure)this.lookupFigure(receiverXmiid);
                sendActiveline = null;
                receiveActiveline = null;
                sendActiveline = message.getPredecessor() == null ? sendFigure.addActiveline(message, location.y) : sendFigure.getActivelineTaraceback(message);
                receiveActiveline = receiveFigure.addActiveline(message, location.y);
                router = null;
                if (receiverXmiid.equals(senderXmiid)) {
                    senderDy = 15;
                    receiverDy = 0;
                    router = new MessageRouter();
                } else {
                    senderDy = receiveActiveline.getBounds().y - sendActiveline.getBounds().y;
                    receiverDy = 0;
                }
            } else {
                LogUtil.writeln("<-\u3053\u306e\u30af\u30e9\u30b9\u306f\u4f5c\u6210\u3057\u306a\u3044");
                return;
            }
            LVSeqDiagConnection lvDiagConn = LVSeqDiagConnection.createConnection(this, diagElement, (ConnectionRouter)router);
            lvDiagConn.setSourceAnchor((ConnectionAnchor)new MessageAnchor((IFigure)sendActiveline, senderDy));
            lvDiagConn.setTargetAnchor((ConnectionAnchor)new MessageAnchor(receiveActiveline, receiverDy));
            GuiUtil.addFigure((IFigure)this.getDraw2dView(), (IFigure)lvDiagConn);
            LogUtil.writeln("\u6210\u529f\uff01");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LogUtil.writeln("\u5931\u6557\uff01");
            LogUtil.writeln(e.getMessage());
            MsgUtil.showMsg("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.getMessage());
        }
    }

    Image getTabImage() {
        return AllAction.ADD_SEQUENCE_DIAGRAM.getImage();
    }

    void createDiagModeBar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        GuiUtil.createToolbarItem(toolbar, 16, AllAction.MODE_SELECTION, true);
        GuiUtil.createToolbarItem(toolbar, 16, AllAction.MODE_ASSOCIATION);
        new ToolItem(toolbar, 2);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_NOTE);
    }

    void updateDiag(LMChangedEvent lmce) {
    }

    static class MessageAnchor
    extends AbstractConnectionAnchor {
        int dy_;

        public MessageAnchor(IFigure owner, int dy) {
            super(owner);
            this.dy_ = dy;
        }

        public Point getLocation(Point reference) {
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(this.getBox());
            this.getOwner().translateToAbsolute((Translatable)r);
            float centerX = (float)r.x + 0.5f * (float)r.width;
            float centerY = (float)r.y + (float)this.dy_;
            if (r.isEmpty() || reference.x == (int)centerX && reference.y == (int)centerY) {
                return new Point((int)centerX, (int)centerY);
            }
            float dx = (float)reference.x - centerX;
            float dy = 0.0f;
            float scale = 0.5f / Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
            return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
        }

        protected Rectangle getBox() {
            return this.getOwner().getBounds();
        }

        public Point getReferencePoint() {
            if (this.getOwner() == null) {
                return null;
            }
            Point ref = this.getBox().getCenter();
            this.getOwner().translateToAbsolute((Translatable)ref);
            return ref;
        }
    }

    class MessageRouter
    extends AbstractRouter {
        private final PrecisionPoint A_POINT = new PrecisionPoint();

        MessageRouter() {
        }

        public void route(Connection conn) {
            PointList points = conn.getPoints();
            points.removeAllPoints();
            Point ref1 = conn.getTargetAnchor().getReferencePoint();
            Point ref2 = conn.getSourceAnchor().getReferencePoint();
            this.A_POINT.setLocation(conn.getSourceAnchor().getLocation(ref1));
            conn.translateToRelative((Translatable)this.A_POINT);
            points.addPoint((Point)this.A_POINT);
            this.A_POINT.translate(30, 0);
            points.addPoint((Point)this.A_POINT);
            this.A_POINT.translate(0, conn.getTargetAnchor().getOwner().getBounds().y - conn.getSourceAnchor().getOwner().getBounds().y - 15);
            points.addPoint((Point)this.A_POINT);
            this.A_POINT.setLocation(conn.getTargetAnchor().getLocation((Point)this.A_POINT));
            conn.translateToRelative((Translatable)this.A_POINT);
            points.addPoint((Point)this.A_POINT);
            conn.setPoints(points);
        }
    }
}

