/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.ArrayList;
import java.util.Iterator;
import latte.InternalLogicException;
import latte.LMChangedEvent;
import latte.model.LM13Diagram;
import latte.util.GuiUtil;
import latte.view.DropTargetEnabler;
import latte.view.LVClassDiag;
import latte.view.LVDiag;
import latte.view.LVSeqDiag;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LVDiagFolder
implements CTabFolderListener {
    private CTabFolder tabFolder_ = null;
    private ArrayList diagList_ = new ArrayList();

    public LVDiagFolder(Composite parent) {
        this.tabFolder_ = new CTabFolder(parent, 0x800800);
        this.tabFolder_.addCTabFolderListener((CTabFolderListener)this);
        this.tabFolder_.setSelectionBackground(new Color[]{GuiUtil.getColor(31), GuiUtil.getColor(32), GuiUtil.getColor(22)}, new int[]{50, 100});
        this.tabFolder_.setSelectionForeground(GuiUtil.getColor(1));
        new DropTargetEnabler(this, (Control)this.tabFolder_);
    }

    public void showDiag(LM13Diagram lmDiag) {
        Iterator ite = this.diagList_.iterator();
        while (ite.hasNext()) {
            LVDiag diag = (LVDiag)ite.next();
            if (diag.getLmDiag() != lmDiag) continue;
            CTabItem items = diag.getTabItem();
            this.tabFolder_.setSelection(items);
            return;
        }
        this.createDiag(lmDiag);
    }

    private void createDiag(LM13Diagram lmDiag) {
        LVDiag lvDiag = null;
        if (lmDiag.getDiagramType().equals("ClassDiagram")) {
            lvDiag = new LVClassDiag(lmDiag);
        } else if (lmDiag.getDiagramType().equals("SequenceDiagram")) {
            lvDiag = new LVSeqDiag(lmDiag);
        } else {
            throw new IllegalStateException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u56f3\u3067\u3059\u3002\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        this.diagList_.add(lvDiag);
        this.tabFolder_.setSelection(lvDiag.getTabItem());
    }

    public void itemClosed(CTabFolderEvent event) {
        CTabItem closedItem = (CTabItem)event.item;
        LVDiag lvDiag = null;
        Iterator ite = this.diagList_.iterator();
        while (ite.hasNext()) {
            lvDiag = (LVDiag)ite.next();
            if (lvDiag.getTabItem() != closedItem) continue;
            this.diagList_.remove(lvDiag);
            return;
        }
        throw new InternalLogicException("diagList_\u306b\u5b58\u5728\u3059\u3079\u304dCTabItem\u304c\u7121\u3044");
    }

    public LVDiag getCurDiag() {
        CTabItem items = this.tabFolder_.getSelection();
        if (items == null) {
            return null;
        }
        Iterator ite = this.diagList_.iterator();
        while (ite.hasNext()) {
            LVDiag diag = (LVDiag)ite.next();
            if (diag.getTabItem() != items) continue;
            return diag;
        }
        return null;
    }

    public void updateDiag(LMChangedEvent lmce) {
        switch (lmce.getChangedType()) {
            case 0: 
            case 1: {
                Iterator i = this.diagList_.iterator();
                while (i.hasNext()) {
                    LVDiag diag = (LVDiag)i.next();
                    diag.dispose();
                }
                this.diagList_.clear();
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 33: {
                if (this.getCurDiag() == null) break;
                this.getCurDiag().updateDiag(lmce);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                Iterator it = this.diagList_.iterator();
                while (it.hasNext()) {
                    LVDiag diag = (LVDiag)it.next();
                    diag.updateDiag(lmce);
                }
                break;
            }
            case 24: 
            case 34: {
                if (this.getCurDiag() == null) break;
                this.getCurDiag().updateDiag(lmce);
            }
        }
    }

    private void removeAllDiag() {
        Iterator ite = this.diagList_.iterator();
        while (ite.hasNext()) {
            LVClassDiag diag = (LVClassDiag)ite.next();
            diag.dispose();
        }
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder_;
    }
}

