/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import latte.InternalLogicException;
import latte.LMChangedEvent;
import latte.action.AllAction;
import latte.model.IRNode;
import latte.model.LM13Abstraction;
import latte.model.LM13Association;
import latte.model.LM13Attribute;
import latte.model.LM13Class;
import latte.model.LM13Comment;
import latte.model.LM13Dependency;
import latte.model.LM13Diagram;
import latte.model.LM13DiagramElement1;
import latte.model.LM13DiagramElement2;
import latte.model.LM13Generalization;
import latte.model.LM13Interface;
import latte.model.LM13Operation;
import latte.model.LM13Relationship;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import latte.view.LVClassDiagConnection;
import latte.view.LVClassDiagFigure;
import latte.view.LVClassDiagInterfaceFigure;
import latte.view.LVDiag;
import latte.view.LVDiagFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class LVClassDiag
extends LVDiag {
    private Menu figurePopupMenu = this.createFigurePopupMenu();
    private Menu connectionPopupMenu = this.createConnectionPopupMenu();
    private Menu associationPopupMenu = this.createAssociationPopupMenu();
    public static final int POPUPMENU_NONE = 1;
    public static final int POPUPMENU_FIGURE = 2;
    public static final int POPUPMENU_CONNECTION = 3;
    public static final int POPUPMENU_ASSOCIATION = 4;

    public LVClassDiag(LM13Diagram lmDiag) {
        super(lmDiag);
        this.createDiagContent();
        new LVClassDiagListener(this);
    }

    void createDiagContent() {
        LogUtil.writeln("<!-- <<<<<<<<  \u30af\u30e9\u30b9\u56f3\u30b3\u30f3\u30c6\u30f3\u30c4\u4f5c\u6210 >>>>>>> -->");
        LM13DiagramElement1 de1 = ModelUtil.getDiagramElement(this.getLmDiag());
        LM13DiagramElement2[] de2 = de1.getDiagramElement();
        LogUtil.writeln("<!-- <<<<<<<<  FIGURE\u4f5c\u6210 >>>>>>> -->");
        int i = 0;
        while (i < de2.length) {
            this.addFigure(de2[i]);
            ++i;
        }
        LogUtil.writeln("<!-- <<<<<<<<  CONNECTION\u4f5c\u6210 >>>>>>> -->");
        i = 0;
        while (i < de2.length) {
            this.addConnection(de2[i]);
            ++i;
        }
        LogUtil.writeln("<!-- <<<<<<<<  NOTELINK\u4f5c\u6210 >>>>>>> -->");
        i = 0;
        while (i < de2.length) {
            this.addNoteLink(de2[i]);
            ++i;
        }
    }

    public LVClassDiagConnection lookupConnection(String xmiid) {
        List connectionList = this.getDiagConnectionList();
        Object connectionSubject = ModelUtil.getModel(xmiid);
        LVClassDiagConnection diagConnection = null;
        Iterator ite = connectionList.iterator();
        while (ite.hasNext()) {
            diagConnection = (LVClassDiagConnection)((Object)ite.next());
            if (diagConnection.getModel() != connectionSubject) continue;
            return diagConnection;
        }
        return null;
    }

    Image getTabImage() {
        return AllAction.ADD_CLASS_DIAGRAM.getImage();
    }

    public void setPopupMenu(int menu) {
        switch (menu) {
            case 1: {
                this.getSwtView().setMenu(null);
                break;
            }
            case 2: {
                this.getSwtView().setMenu(this.figurePopupMenu);
                break;
            }
            case 3: {
                this.getSwtView().setMenu(this.connectionPopupMenu);
                break;
            }
            case 4: {
                this.getSwtView().setMenu(this.associationPopupMenu);
            }
        }
    }

    private Menu createFigurePopupMenu() {
        Menu menu = new Menu((Control)this.getSwtView());
        GuiUtil.createMenuItem(menu, AllAction.EDIT_CUT);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_COPY);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_PASTE);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_DELETE);
        new MenuItem(menu, 2);
        GuiUtil.createMenuItem(menu, AllAction.SHOW_DEF);
        return menu;
    }

    private Menu createConnectionPopupMenu() {
        Menu menu = new Menu((Control)this.getSwtView());
        GuiUtil.createMenuItem(menu, AllAction.EDIT_CUT);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_COPY);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_PASTE);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_DELETE);
        return menu;
    }

    private Menu createAssociationPopupMenu() {
        Menu menu = new Menu((Control)this.getSwtView());
        GuiUtil.createMenuItem(menu, AllAction.NAVIGATABLE_FALSE);
        GuiUtil.createMenuItem(menu, AllAction.NAVIGATABLE_TRUE);
        new MenuItem(menu, 2);
        GuiUtil.createMenuItem(menu, AllAction.CONTAINER_NONE);
        GuiUtil.createMenuItem(menu, AllAction.CONTAINER_AGGREGATION);
        GuiUtil.createMenuItem(menu, AllAction.CONTAINER_COMPOSITION);
        new MenuItem(menu, 2);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_CUT);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_COPY);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_PASTE);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_DELETE);
        return menu;
    }

    public void updateDiag(LMChangedEvent lmce) {
        switch (lmce.getChangedType()) {
            case 11: {
                LVDiagFigure lvFig;
                Object addDef = lmce.getElement();
                Object addParent = lmce.getParent();
                if (!(addDef instanceof LM13Attribute) && !(addDef instanceof LM13Operation) || (lvFig = this.getLvfigByModel(addParent)) == null) break;
                lvFig.updateFigure(true);
                break;
            }
            case 12: {
                Object modifyDef = lmce.getElement();
                if (modifyDef instanceof LM13Diagram) {
                    LM13Diagram diag = (LM13Diagram)modifyDef;
                    if (diag != this.getLmDiag()) break;
                    this.setTabText(diag.getName());
                    break;
                }
                LVDiagFigure lvFig = null;
                if (modifyDef instanceof LM13Attribute || modifyDef instanceof LM13Operation) {
                    IRNode node = (IRNode)modifyDef;
                    lvFig = this.getLvfigByModel(node.rGetParentRNode().rGetParentRNode());
                } else if (modifyDef instanceof LM13Class || modifyDef instanceof LM13Interface || modifyDef instanceof LM13Comment) {
                    lvFig = this.getLvfigByModel(modifyDef);
                } else {
                    throw new InternalLogicException("LVClassDiag.updateDiag()\u8003\u616e\u6f0f\u308c");
                }
                if (lvFig == null) break;
                lvFig.updateFigure(true);
                break;
            }
            case 13: {
                LVDiagFigure lvFig;
                Object deleteDef = lmce.getElement();
                Object deleteParent = lmce.getParent();
                if (deleteDef instanceof LM13Diagram) {
                    if (deleteDef != this.getLmDiag()) break;
                    this.dispose();
                    break;
                }
                if (deleteDef instanceof LM13Class || deleteDef instanceof LM13Interface) {
                    LVDiagFigure lvFig2 = this.getLvfigByModel(deleteDef);
                    if (lvFig2 == null) break;
                    LM13DiagramElement2 e = lvFig2.getDiagElement();
                    this.removeFigure(e);
                    this.removeConnection();
                    break;
                }
                if (!(deleteDef instanceof LM13Attribute) && !(deleteDef instanceof LM13Operation) || (lvFig = this.getLvfigByModel(deleteParent)) == null) break;
                lvFig.updateFigure();
                break;
            }
            case 21: {
                this.addFigure((LM13DiagramElement2)lmce.getElement());
                break;
            }
            case 22: {
                Object modifyFig = lmce.getElement();
                if (modifyFig != null) {
                    LVDiagFigure lvDiagFig = this.getLvfigByDiagElement((LM13DiagramElement2)modifyFig);
                    if (lvDiagFig == null) break;
                    lvDiagFig.updateFigure();
                    break;
                }
                Iterator ite = this.getDiagFigureList().iterator();
                while (ite.hasNext()) {
                    ((LVClassDiagFigure)((Object)ite.next())).updateFigure();
                }
                break;
            }
            case 23: {
                this.removeFigure((LM13DiagramElement2)lmce.getElement());
                this.removeConnection();
                break;
            }
            case 24: {
                Object selectedFig = lmce.getElement();
                if (selectedFig != null) {
                    LVDiagFigure lvDiagFig = null;
                    if (selectedFig instanceof LM13DiagramElement2) {
                        lvDiagFig = this.getLvfigByDiagElement((LM13DiagramElement2)selectedFig);
                    } else if (selectedFig instanceof LM13Class || selectedFig instanceof LM13Interface) {
                        lvDiagFig = this.getLvfigByModel(selectedFig);
                    }
                    if (lvDiagFig == null) break;
                    lvDiagFig.updateFigure();
                    break;
                }
                Iterator ite = this.getDiagFigureList().iterator();
                while (ite.hasNext()) {
                    ((LVClassDiagFigure)((Object)ite.next())).updateFigure();
                }
                break;
            }
            case 31: {
                this.addConnection((LM13DiagramElement2)lmce.getElement());
                break;
            }
            case 32: {
                LM13DiagramElement2 diagElement = (LM13DiagramElement2)lmce.getElement();
                if (diagElement != null) {
                    LVClassDiagConnection lvConn = this.getLvconnByDiagElement(diagElement);
                    if (lvConn == null) break;
                    lvConn.updateConnection();
                    break;
                }
                Iterator ite = this.getDiagConnectionList().iterator();
                while (ite.hasNext()) {
                    ((LVClassDiagConnection)((Object)ite.next())).updateConnection();
                }
                break;
            }
            case 33: {
                this.removeConnection();
                break;
            }
            case 34: {
                Object selectedRel = lmce.getElement();
                if (selectedRel != null) {
                    LVClassDiagConnection lvDiagConn = null;
                    if (selectedRel instanceof LM13DiagramElement2) {
                        lvDiagConn = this.getLvconnByDiagElement((LM13DiagramElement2)selectedRel);
                    }
                    if (lvDiagConn == null) break;
                    lvDiagConn.updateConnection();
                    break;
                }
                Iterator ite = this.getDiagConnectionList().iterator();
                while (ite.hasNext()) {
                    ((LVClassDiagConnection)((Object)ite.next())).updateConnection();
                }
                break;
            }
        }
    }

    void removeConnection() {
        LM13DiagramElement1 parent = ModelUtil.getDiagramElement(this.getLmDiag());
        List<LM13DiagramElement2> elementList = Arrays.asList(parent.getDiagramElement());
        Iterator ite = this.getDiagConnectionList().iterator();
        while (ite.hasNext()) {
            LVClassDiagConnection lvConn = (LVClassDiagConnection)((Object)ite.next());
            if (elementList.contains(lvConn.getDiagElement())) continue;
            this.getDraw2dView().remove((IFigure)lvConn);
            lvConn.erase();
        }
    }

    void createDiagModeBar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        GuiUtil.createToolbarItem(toolbar, 16, AllAction.MODE_SELECTION, true);
        GuiUtil.createToolbarItem(toolbar, 16, AllAction.MODE_ASSOCIATION);
        GuiUtil.createToolbarItem(toolbar, 16, AllAction.MODE_GENELIZATION);
        GuiUtil.createToolbarItem(toolbar, 16, AllAction.MODE_DEPENDENCY);
        GuiUtil.createToolbarItem(toolbar, 16, AllAction.MODE_IMPLEMENTATION);
        GuiUtil.createToolbarItem(toolbar, 16, AllAction.MODE_NOTELINK);
        new ToolItem(toolbar, 2);
        GuiUtil.createToolbarItem(toolbar, 8, AllAction.ADD_NOTE);
    }

    private void addFigure(LM13DiagramElement2 diagElement) {
        Object modelElement = ModelUtil.getModel(diagElement);
        try {
            LogUtil.write("\nElement\u4f5c\u6210:Class=" + modelElement.getClass().getName());
            LogUtil.write("  Xmiid=" + diagElement.getXmiId());
            if (!(modelElement instanceof LM13Class || modelElement instanceof LM13Interface || modelElement instanceof LM13Comment)) {
                LogUtil.writeln("<- \u4f5c\u6210\u3057\u306a\u3044");
                return;
            }
            this.addDiagElement(diagElement);
            LVClassDiagFigure lvDiagFig = LVClassDiagFigure.createFigure(this, diagElement);
            GuiUtil.addFigure((IFigure)this.getDraw2dView(), (IFigure)lvDiagFig);
            LogUtil.writeln("<!-- <<<<<<<<  \u30a8\u30ec\u30e1\u30f3\u30c8\u53c2\u7167 >>>>>>> -->");
            LogUtil.writeln(diagElement);
            LogUtil.writeln("<!-- <<<<<<<<  \u30a8\u30ec\u30e1\u30f3\u30c8\u5b9f\u614b >>>>>>> -->");
            LogUtil.writeln(modelElement);
            LogUtil.writeln("\u6210\u529f\uff01");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LogUtil.writeln(e.getMessage());
            MsgUtil.showMsg("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.getMessage());
        }
    }

    private void addConnection(LM13DiagramElement2 diagElement) {
        Object modelElement = ModelUtil.getModel(diagElement);
        try {
            LogUtil.write("\nElement\u4f5c\u6210:Class=" + modelElement.getClass().getName());
            LogUtil.write("Xmiid=" + diagElement.getXmiId());
            if (!(modelElement instanceof LM13Generalization || modelElement instanceof LM13Association || modelElement instanceof LM13Dependency || modelElement instanceof LM13Abstraction)) {
                LogUtil.writeln("<- \u4f5c\u6210\u3057\u306a\u3044");
                return;
            }
            this.addDiagElement(diagElement);
            LVClassDiagConnection lvDiagCon = LVClassDiagConnection.createConnection(this, diagElement);
            this.getDraw2dView().add((IFigure)lvDiagCon);
            LogUtil.writeln("<!-- <<<<<<<<  \u30a8\u30ec\u30e1\u30f3\u30c8\u53c2\u7167 >>>>>>> -->");
            LogUtil.writeln(diagElement);
            LogUtil.writeln("<!-- <<<<<<<<  \u30a8\u30ec\u30e1\u30f3\u30c8\u5b9f\u614b >>>>>>> -->");
            LogUtil.writeln(modelElement);
            LogUtil.writeln("\u6210\u529f\uff01");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LogUtil.writeln(e.getMessage());
            MsgUtil.showMsg("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.getMessage());
        }
    }

    private void addNoteLink(LM13DiagramElement2 diagElement) {
        Object modelElement = ModelUtil.getModel(diagElement);
        try {
            LogUtil.write("\nElement\u4f5c\u6210:Class=" + modelElement.getClass().getName());
            LogUtil.write("Xmiid=" + diagElement.getXmiId());
            if (modelElement instanceof LM13Comment) {
                LM13Comment comment = (LM13Comment)modelElement;
                if (comment.getAnnotatedElement() == null) {
                    LogUtil.writeln("<- \u63a5\u7d9a\u3057\u3066\u306a\u3044\u306e\u3067\u4f5c\u6210\u3057\u306a\u3044");
                    return;
                }
            } else {
                LogUtil.writeln("<- \u4f5c\u6210\u3057\u306a\u3044");
                return;
            }
            this.addDiagElement(diagElement);
            LVClassDiagConnection lvDiagCon = LVClassDiagConnection.createConnection(this, diagElement);
            this.getDraw2dView().add((IFigure)lvDiagCon);
            LogUtil.writeln("<!-- <<<<<<<<  \u30a8\u30ec\u30e1\u30f3\u30c8\u53c2\u7167 >>>>>>> -->");
            LogUtil.writeln(diagElement);
            LogUtil.writeln("<!-- <<<<<<<<  \u30a8\u30ec\u30e1\u30f3\u30c8\u5b9f\u614b >>>>>>> -->");
            LogUtil.writeln(modelElement);
            LogUtil.writeln("\u6210\u529f\uff01");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LogUtil.writeln(e.getMessage());
            MsgUtil.showMsg("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002:" + e.getMessage());
        }
    }

    public void removeFigure(LM13DiagramElement2 diagElement) {
        LVDiagFigure lvFig = this.getLvfigByDiagElement(diagElement);
        this.getDraw2dView().remove((IFigure)lvFig);
        this.removeDiagElement(diagElement);
        lvFig.erase();
    }

    public List getDiagConnectionList() {
        List l = this.getDraw2dView().getChildren();
        ArrayList l2 = new ArrayList();
        Iterator ite = l.iterator();
        while (ite.hasNext()) {
            Object o = ite.next();
            if (!(o instanceof LVClassDiagConnection)) continue;
            l2.add(o);
        }
        return l2;
    }

    static class LVClassDiagListener
    implements MouseListener,
    MouseMotionListener {
        private LVClassDiag diag_ = null;
        private Point last_ = new Point(0, 0);

        public LVClassDiagListener(LVClassDiag diag) {
            this.diag_ = diag;
            this.diag_.getDraw2dView().addMouseListener((MouseListener)this);
            this.diag_.getDraw2dView().addMouseMotionListener((MouseMotionListener)this);
        }

        public void mousePressed(MouseEvent me) {
            LogUtil.writeln("ClassDiagListener.mousePressed(" + me.x + "," + me.y + ")" + " button=" + me.button);
            Viewport viewport = (Viewport)this.diag_.getDraw2dView().getParent();
            LogUtil.writeln("    ViewportLocation=" + viewport.getViewLocation());
            if (this.diag_.getMode() == 1) {
                AllAction.SELECT_NONE.execute(null);
                this.last_ = me.getLocation().translate(viewport.getViewLocation());
            } else if (me.button == 3) {
                AllAction.MODE_SELECTION.execute(null);
            }
        }

        public void mouseReleased(MouseEvent me) {
            LVClassDiagInterfaceFigure.getAddingConn().end();
            this.diag_.setPopupMenu(1);
        }

        public void mouseDragged(MouseEvent me) {
            LogUtil.writeln("ClassDiagListener.mouseDragged(" + me.x + "," + me.y + ")" + " button=" + me.button);
            switch (this.diag_.getMode()) {
                case 1: {
                    Object curElement = ModelUtil.getCurElement();
                    if (!(curElement instanceof LM13DiagramElement2) || curElement == null) {
                        return;
                    }
                    Object curModel = ModelUtil.getModel((LM13DiagramElement2)curElement);
                    Viewport viewport = (Viewport)this.diag_.getDraw2dView().getParent();
                    Point now = me.getLocation().translate(viewport.getViewLocation());
                    Dimension delta = now.getDifference(this.last_);
                    if (curModel instanceof LM13Class || curModel instanceof LM13Interface || curModel instanceof LM13Comment) {
                        LogUtil.writeln("delta=" + delta);
                        AllAction.FIGURE_MOVE.execute(delta);
                    } else {
                        boolean cfr_ignored_0 = curModel instanceof LM13Relationship;
                    }
                    this.last_ = now;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    LVClassDiagFigure.getAddingConn().move(me.getLocation());
                    break;
                }
                default: {
                    throw new InternalLogicException("mouseDragged()\u8003\u616e\u6f0f\u308c");
                }
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
            LogUtil.writeln("ClassDiagListener.mouseDoubleClicked(" + me.x + "," + me.y + ")" + " button=" + me.button);
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }
    }
}

