/*
 * Decompiled with CFR 0.152.
 */
package latte.model;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import latte.model.RStack;
import latte.model.UJAXP;
import latte.model.URelaxer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.SAXException;

public final class RNameClassNS {
    private Node pattern_;
    private String ns_;

    public RNameClassNS(String config, String ns) {
        try {
            Document doc = UJAXP.getDocument(new StringReader(config));
            this.ns_ = ns;
            this.pattern_ = this._makePattern(doc.getDocumentElement());
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
        catch (SAXException e) {
            throw new IllegalArgumentException();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException();
        }
    }

    private Node _makePattern(Element element) {
        Node node;
        String tagName = element.getTagName();
        if ("anyName".equals(tagName)) {
            node = new AnyName();
        } else if ("nsName".equals(tagName)) {
            Attr attr = element.getAttributeNode("ns");
            node = attr != null ? new NsName(attr.getValue()) : new NsName(this.ns_);
        } else {
            if ("name".equals(tagName)) {
                String name = URelaxer.getElementPropertyAsString(element);
                Attr attr = element.getAttributeNode("ns");
                Name node2 = attr != null ? new Name(attr.getValue(), name) : new Name(this.ns_, name);
                return node2;
            }
            if ("choice".equals(tagName)) {
                node = new Choice();
            } else if ("except".equals(tagName)) {
                node = new Except();
            } else {
                throw new IllegalArgumentException();
            }
        }
        Element[] children = URelaxer.getElements(element);
        int i = 0;
        while (i < children.length) {
            node.addChild(this._makePattern(children[i]));
            ++i;
        }
        return node;
    }

    public boolean isMatchElement(Element element) {
        String ns = element.getNamespaceURI();
        if (ns == null) {
            ns = "";
        }
        return this.pattern_.eval(ns, element.getLocalName());
    }

    public boolean isMatchAttributeHungry(RStack stack) {
        Element element = stack.getContextElement();
        NamedNodeMap attrs = element.getAttributes();
        int size = attrs.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)attrs.item(i);
            if (!"xmlns".equals(attr.getPrefix()) && !"xmlns".equals(attr.getName())) {
                String attrName;
                String ns = attr.getNamespaceURI();
                if (ns == null) {
                    ns = "";
                }
                if (!stack.isConsumedAttribute(attr) && this.pattern_.eval(ns, attrName = attr.getLocalName())) {
                    stack.consumeAttribute(attr);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public String[] getAttributeHungry(RStack stack) {
        Element element = stack.getContextElement();
        NamedNodeMap attrs = element.getAttributes();
        int size = attrs.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)attrs.item(i);
            if (!"xmlns".equals(attr.getPrefix())) {
                String ns = attr.getNamespaceURI();
                if (ns == null) {
                    ns = "";
                }
                if (!stack.isConsumedAttribute(attr)) {
                    String attrName = attr.getLocalName();
                    if (attrName == null) {
                        attrName = attr.getName();
                    }
                    if (this.pattern_.eval(ns, attrName)) {
                        stack.consumeAttribute(attr);
                        String[] result = new String[]{ns, attrName, "".equals(ns) ? element.getAttribute(attrName) : element.getAttributeNS(ns, attrName)};
                        return result;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static class Node {
        protected List children_ = new ArrayList();

        public void addChild(Node child) {
            this.children_.add(child);
        }

        public boolean eval(String ns, String local) {
            if (!this._evalBody(ns, local)) {
                return false;
            }
            return this._evalChildren(ns, local);
        }

        protected boolean _evalBody(String ns, String local) {
            return true;
        }

        protected boolean _evalChildren(String ns, String local) {
            int size = this.children_.size();
            int i = 0;
            while (i < size) {
                Node node = (Node)this.children_.get(i);
                if (!node.eval(ns, local)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class AnyName
    extends Node {
    }

    public static class NsName
    extends Node {
        private String ns_;

        public NsName(String ns) {
            this.ns_ = ns;
        }

        protected boolean _evalBody(String ns, String local) {
            return this.ns_.equals(ns);
        }
    }

    public static class Name
    extends Node {
        private String ns_;
        private String name_;

        public Name(String ns, String name) {
            this.ns_ = ns;
            this.name_ = name;
        }

        protected boolean _evalBody(String ns, String local) {
            return this.ns_.equals(ns) && this.name_.equals(local);
        }
    }

    public static class Choice
    extends Node {
        public boolean eval(String ns, String local) {
            int size = this.children_.size();
            int i = 0;
            while (i < size) {
                Node node = (Node)this.children_.get(i);
                if (node.eval(ns, local)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class Except
    extends Node {
        protected boolean _evalChildren(String ns, String local) {
            int size = this.children_.size();
            int i = 0;
            while (i < size) {
                Node node = (Node)this.children_.get(i);
                if (node.eval(ns, local)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

