/*
 * Decompiled with CFR 0.152.
 */
package latte.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import latte.LMChangedEvent;
import latte.Latte;
import latte.LatteData;
import latte.action.AbstractLatteAction;
import latte.action.ToolRoseImportAction;
import latte.model.ILM13XMIContentChoice;
import latte.model.LM13Comment;
import latte.model.LM13Diagram;
import latte.model.LM13DiagramElement1;
import latte.model.LM13DiagramElement2;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ToolRoseImportAction
extends AbstractLatteAction {
    private static String WITHID = " with id ";
    private static String NOTEVIEW = " NoteView @ ";
    private static int RATE = 4;
    private Shell dialog_ = null;
    private Text xmiFileTxt_ = null;
    private Text rxpFileTxt_ = null;
    static /* synthetic */ Class class$0;

    public ToolRoseImportAction(String title, String imageFile) {
        super(title, imageFile);
    }

    public void execMain(Object param) {
        try {
            Latte.getLatteData().checkSaving();
            this.showDialog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showDialog() {
        this.dialog_ = GuiUtil.createDialog(600, 200, this.getTitle());
        GuiUtil.createLabelInForm(this.dialog_, "XMI\u30d5\u30a1\u30a4\u30eb", 20, 22, 60, 13);
        this.xmiFileTxt_ = GuiUtil.createTextInForm(this.dialog_, 85, 20, 400, 13);
        GuiUtil.createButtonInForm(this.dialog_, "\u53c2\u7167", 515, 20, 40, 20, (SelectionListener)new XmiFileDiagSelection());
        GuiUtil.createLabelInForm(this.dialog_, "RXP\u30d5\u30a1\u30a4\u30eb", 20, 52, 60, 13);
        this.rxpFileTxt_ = GuiUtil.createTextInForm(this.dialog_, 85, 50, 400, 13);
        GuiUtil.createButtonInForm(this.dialog_, "\u53c2\u7167", 515, 50, 40, 20, (SelectionListener)new RxpFileDiagSelection());
        GuiUtil.createLabelInForm(this.dialog_, "RXP\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3059\u308b\u3068\u65e5\u672c\u8a9e\u306e\u6587\u5b57\u5316\u3051\u304c\u89e3\u6d88\u3055\u308c\u307e\u3059", 85, 80, 400, 30);
        GuiUtil.createButtonInForm(this.dialog_, "IMPORT", 200, 140, 90, 30, (SelectionListener)new ImportSelection());
        GuiUtil.createButtonInForm(this.dialog_, "\u30ad\u30e3\u30f3\u30bb\u30eb", 310, 140, 90, 30, (SelectionListener)new CancelSelection());
        this.dialog_.open();
    }

    private Map readRxpFile(String file) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        int index = -1;
        String key = null;
        String value = null;
        while ((line = reader.readLine()) != null) {
            index = line.lastIndexOf(WITHID);
            if (index != -1) {
                key = line.substring(index + WITHID.length());
                value = line.split("'")[1];
                map.put(key, value);
                continue;
            }
            index = line.lastIndexOf(NOTEVIEW);
            if (index == -1) continue;
            key = line.substring(index + NOTEVIEW.length());
            value = reader.readLine().substring(7);
            map.put(key, value);
        }
        return map;
    }

    private void changeRose2Latte() {
        ILM13XMIContentChoice[] content = Latte.getLatteData().getXMI().getXMIContent().getContent();
        int i = 0;
        while (i < content.length) {
            if (content[i] instanceof LM13Diagram) {
                LM13Diagram diag = (LM13Diagram)content[i];
                diag.setToolName("Latte ver1");
                LM13DiagramElement1 de1 = ModelUtil.getDiagramElement(diag);
                LM13DiagramElement2[] de2 = de1.getDiagramElement();
                int j = 0;
                while (j < de2.length) {
                    de2[j].setGeometry(this.convGeometry(de2[j].getGeometry()));
                    ++j;
                }
            }
            ++i;
        }
    }

    private String convGeometry(String roseGeo) {
        String[] s = roseGeo.split(",");
        int x = Integer.parseInt(s[0].trim()) / RATE;
        int y = Integer.parseInt(s[1].trim()) / RATE;
        int w = Integer.parseInt(s[2].trim()) / RATE;
        int h = Integer.parseInt(s[3].trim()) / RATE;
        String latteGeo = String.valueOf(x) + ", " + y + ", " + w + ", " + h;
        return latteGeo;
    }

    private void reflectSymbol(Map symbol) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Set idRefs = Latte.getLatteData().idrefEntrySet();
        Iterator ite = idRefs.iterator();
        Map.Entry entry = null;
        int i = 0;
        int j = 0;
        while (ite.hasNext()) {
            String newName;
            entry = (Map.Entry)ite.next();
            Object element = entry.getValue();
            Class<?> clazz = element.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method m = clazz.getMethod("setName", classArray);
            String xmiid = (String)entry.getKey();
            if (element instanceof LM13Comment) {
                System.out.print(xmiid);
                int lastIndex = xmiid.lastIndexOf(".");
                int num = Integer.parseInt(xmiid.substring(lastIndex + 1));
                xmiid = String.valueOf(xmiid.substring(0, lastIndex + 1)) + String.valueOf(num - 1);
            }
            if ((newName = (String)symbol.get(xmiid)) != null) {
                m.invoke(element, newName);
                LogUtil.writeln("\u25cb" + element);
                ++i;
                continue;
            }
            LogUtil.writeln("\u00d7" + element);
            ++j;
        }
        LogUtil.writeln("\u25cb=" + i);
        LogUtil.writeln("\u00d7=" + j);
    }

    static /* synthetic */ void access$3(ToolRoseImportAction toolRoseImportAction) {
        toolRoseImportAction.changeRose2Latte();
    }

    static /* synthetic */ Map access$4(ToolRoseImportAction toolRoseImportAction, String string) {
        return toolRoseImportAction.readRxpFile(string);
    }

    static /* synthetic */ void access$5(ToolRoseImportAction toolRoseImportAction, Map map) {
        toolRoseImportAction.reflectSymbol(map);
    }

    class ImportSelection
    extends SelectionAdapter {
        ImportSelection() {
        }

        public void widgetSelected(SelectionEvent event) {
            try {
                String xmiFileName = ToolRoseImportAction.this.xmiFileTxt_.getText();
                String rxpFileName = ToolRoseImportAction.this.rxpFileTxt_.getText();
                if (xmiFileName.length() == 0) {
                    MsgUtil.showMsg("XMI\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
                    return;
                }
                Latte.getLatteData().destroy();
                GuiUtil.setWaitMouseCursor();
                ToolRoseImportAction.this.dialog_.close();
                new Thread(this, xmiFileName, rxpFileName){
                    final /* synthetic */ ImportSelection this$1;
                    private final /* synthetic */ String val$xmiFileName;
                    private final /* synthetic */ String val$rxpFileName;
                    {
                        this.this$1 = importSelection;
                        this.val$xmiFileName = string;
                        this.val$rxpFileName = string2;
                    }

                    public void run() {
                        try {
                            try {
                                LatteData latteData = new LatteData();
                                latteData.setFile(new File(this.val$xmiFileName));
                                latteData.load();
                                if (latteData.getXMI().getXMIContent() == null) {
                                    throw new Exception("Latte\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc\u307f\u5931\u6557");
                                }
                                Latte.setLatteData(latteData);
                                ToolRoseImportAction.access$3(ImportSelection.access$0(this.this$1));
                                if (this.val$rxpFileName.length() != 0) {
                                    Map map = ToolRoseImportAction.access$4(ImportSelection.access$0(this.this$1), this.val$rxpFileName);
                                    LogUtil.writeln("\u8aad\u307f\u8fbc\u3093\u3060\u30b7\u30f3\u30dc\u30eb\u6570=" + map.size());
                                    ToolRoseImportAction.access$5(ImportSelection.access$0(this.this$1), map);
                                }
                                Latte.getLatteData().setFile(null);
                                latteData.addObserver(Latte.getMainForm());
                                GuiUtil.syncExce(new Runnable(this){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = var1_1;
                                    }

                                    public void run() {
                                        LMChangedEvent lmce = new LMChangedEvent(0, null, null);
                                        Latte.getLatteData().notifyObserversForce(lmce);
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                MsgUtil.showMsgAsync("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff1a" + e.getMessage());
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_5 = null;
                            GuiUtil.setNormalMouseCursor();
                            throw throwable;
                        }
                        Object var3_6 = null;
                        GuiUtil.setNormalMouseCursor();
                    }
                }.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        static /* synthetic */ ToolRoseImportAction access$0(ImportSelection importSelection) {
            return importSelection.ToolRoseImportAction.this;
        }
    }

    class CancelSelection
    extends SelectionAdapter {
        CancelSelection() {
        }

        public void widgetSelected(SelectionEvent event) {
            ToolRoseImportAction.this.dialog_.close();
        }
    }

    class XmiFileDiagSelection
    extends SelectionAdapter {
        XmiFileDiagSelection() {
        }

        public void widgetSelected(SelectionEvent event) {
            String openFile = GuiUtil.openFileDialog(4096, GuiUtil.XMI_EXTENTION);
            if (openFile == null) {
                return;
            }
            ToolRoseImportAction.this.xmiFileTxt_.setText(openFile);
        }
    }

    class RxpFileDiagSelection
    extends SelectionAdapter {
        RxpFileDiagSelection() {
        }

        public void widgetSelected(SelectionEvent event) {
            String openFile = GuiUtil.openFileDialog(4096, GuiUtil.RXP_EXTENTION);
            if (openFile == null) {
                return;
            }
            ToolRoseImportAction.this.rxpFileTxt_.setText(openFile);
        }
    }
}

