/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof String)) {
            transferData.result = -2147467259;
            return;
        }
        if (this.isSupportedType(transferData)) {
            TCHAR buffer = new TCHAR(0, (String)object, true);
            int byteCount = buffer.length() * TCHAR.sizeof;
            int newPtr = OS.GlobalAlloc(64, byteCount);
            OS.MoveMemory(newPtr, buffer, byteCount);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = newPtr;
            transferData.stgmedium.pUnkForRelease = 0;
            transferData.result = 0;
            return;
        }
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147221399;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
            transferData.result = -2147467259;
            return null;
        }
        IDataObject data = new IDataObject(transferData.pIDataObject);
        data.AddRef();
        FORMATETC formatetc = transferData.formatetc;
        STGMEDIUM stgmedium = new STGMEDIUM();
        stgmedium.tymed = 1;
        transferData.result = data.GetData(formatetc, stgmedium);
        data.Release();
        if (transferData.result != 0) {
            return null;
        }
        int hMem = stgmedium.unionField;
        int size = OS.GlobalSize(hMem) / TCHAR.sizeof * TCHAR.sizeof;
        TCHAR buffer = new TCHAR(0, size / TCHAR.sizeof);
        int ptr = OS.GlobalLock(hMem);
        OS.MoveMemory(buffer, ptr, size);
        OS.GlobalUnlock(hMem);
        OS.GlobalFree(hMem);
        return buffer.toString(0, buffer.strlen());
    }

    protected int[] getTypeIds() {
        return new int[]{OS.IsUnicode ? 13 : 1};
    }

    protected String[] getTypeNames() {
        return new String[]{OS.IsUnicode ? "CF_UNICODETEXT" : "CF_TEXT"};
    }
}

