/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.general;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.ui.general.WhenInstallPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class GeneralUtilities {
    private static ImageIcon _jawsTitleImage;
    private static ImageIcon _jawsTitleVerImage;
    private static ImageIcon _sunLogoImage;
    private static ImageIcon _javaCupImage;
    private static ImageIcon _dividerImage;
    private static ImageIcon _alertImage;
    private static ImageIcon _infoImage;
    private static ImageIcon _lockImage;
    private static ImageIcon _defaultImage;
    private static int _tileWidth;
    private static int _tileHeight;
    public static final int INSTALL_NO = 0;
    public static final int INSTALL_YES = 1;
    public static final int INSTALL_ASK = 2;

    public static void placeWindow(Window window) {
        Window window2 = window.getOwner();
        Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle rectangle2 = window.getBounds();
        Rectangle rectangle3 = window2 == null ? rectangle : window2.getBounds();
        double d = (double)rectangle3.height - (double)rectangle3.height / 1.618;
        rectangle2.x = rectangle3.x + (rectangle3.width - rectangle2.width) / 2;
        int n = (int)(d - (double)(rectangle2.height / 2));
        int n2 = window2 == null ? 0 : window2.getInsets().top;
        rectangle2.y = rectangle3.y + Math.max(n, n2);
        if (rectangle2.x + rectangle2.width > rectangle.width) {
            rectangle2.x = Math.max(rectangle.width - rectangle2.width, 0);
        }
        if (rectangle2.y + rectangle2.height > rectangle.height) {
            rectangle2.y = Math.max(rectangle.height - rectangle2.height, 0);
        }
        window.setBounds(rectangle2);
    }

    private static void invokeOnEventDispatchingThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static ImageIcon getDefaultImage() {
        if (_defaultImage == null) {
            _defaultImage = Resources.getIconFromFilename("resources/JavaIcon-48.png");
        }
        return _defaultImage;
    }

    public static ImageIcon getDividerImage() {
        if (_dividerImage == null) {
            _dividerImage = Resources.getIcon("divider.image");
        }
        return _dividerImage;
    }

    public static ImageIcon getInfoIcon() {
        if (_infoImage == null) {
            _infoImage = Resources.getIcon("info.image");
        }
        return _infoImage;
    }

    public static ImageIcon getJavaCupImage() {
        if (_javaCupImage == null) {
            _javaCupImage = Resources.getIconFromFilename("resources/JavaIcon47x88.png");
        }
        return _javaCupImage;
    }

    public static ImageIcon getJawsTitleImage() {
        if (_jawsTitleImage == null) {
            _jawsTitleImage = Resources.getIcon("jawsTitle.image");
        }
        return _jawsTitleImage;
    }

    public static ImageIcon getLockIcon() {
        if (_lockImage == null) {
            _lockImage = Resources.getIcon("lock.image");
        }
        return _lockImage;
    }

    public static ImageIcon getSunLogoImage() {
        if (_sunLogoImage == null) {
            _sunLogoImage = Resources.getIcon("sunLogo.image");
        }
        return _sunLogoImage;
    }

    public static ImageIcon getWarningIcon() {
        if (_alertImage == null) {
            _alertImage = Resources.getIcon("alert.image");
        }
        return _alertImage;
    }

    private static void setReturn(JButton jButton) {
        Container container = jButton;
        while (container != null) {
            if (!((container = container.getParent()) instanceof JOptionPane)) continue;
            ((JOptionPane)container).setValue(jButton);
            break;
        }
    }

    private static Object messageFormat(Object object) {
        if (object instanceof String) {
            return new PlainTextArea((String)object);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] instanceof String ? new PlainTextArea((String)objectArray[i]) : objectArray[i];
            }
            return objectArray2;
        }
        return object;
    }

    public static void showAboutDialog(Frame frame, String string) {
        String string2 = "     Copyright \u00a9 2003 Sun Microsystems, Inc.  All rights reserved.  Use is subject to license terms.  Third-party software, including font technology, is copyrighted and licensed from Sun suppliers.  Sun,  Sun Microsystems,  the Sun logo and  Java are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S. and other countries.  All SPARC trademarks are used under license and are trademarks or registered trademarks of SPARC International, Inc. in the U.S. and other countries.  Federal Acquisitions: Commercial Software - Government Users Subject to Standard License Terms and Conditions.  ";
        String string3 = "\n\n";
        String string4 = "     Copyright \u00a9 2003 Sun Microsystems, Inc. Tous droits r\u00e9serv\u00e9s.  Distribu\u00e9 par des licences qui en restreignent l'utilisation.  Le logiciel d\u00e9tenu par des tiers, et qui comprend la technologie relative aux polices de caract\u00e8res, est prot\u00e9g\u00e9 par un copyright et licenci\u00e9 par des fournisseurs de Sun.  Sun,  Sun Microsystems,  le logo Sun et  Java sont des marques de fabrique ou des marques d\u00e9pos\u00e9es de Sun Microsystems, Inc. aux Etats-Unis et dans d'autres pays.  Toutes les marques SPARC sont utilis\u00e9es sous licence et sont des marques de fabrique ou des marques d\u00e9pos\u00e9es de SPARC International, Inc. aux Etats-Unis et dans d'autres pays.  ";
        final JDialog jDialog = new JDialog(frame, string, true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        final JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 31);
        jTextArea.setText(string2 + string3 + string4);
        jTextArea.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JButton jButton = new JButton(Resources.getString("aboutBox.closeButton"));
        jPanel2.add((Component)jButton, "South");
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        JLabel jLabel = new JLabel(GeneralUtilities.getSunLogoImage());
        jLabel.setBorder(border);
        jPanel3.add((Component)jLabel, "West");
        JLabel jLabel2 = new JLabel(GeneralUtilities.getJavaCupImage());
        jLabel2.setBorder(border);
        jPanel3.add((Component)jLabel2, "East");
        jPanel.add((Component)jPanel3, "West");
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 2, 6, 2));
        jDialog.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jButton.requestFocus();
        jDialog.getRootPane().setDefaultButton(jButton);
        JLabel jLabel3 = new JLabel(Resources.getString("aboutBox.versionLabel", Globals.getBuildID()), 2);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        container.add((Component)jLabel3, "North");
        container.add((Component)jScrollPane, "Center");
        container.add((Component)jPanel, "South");
        jDialog.setBounds(0, 0, 400, 400);
        GeneralUtilities.placeWindow(jDialog);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$0;

                    public void run() {
                        3.access$000(this.this$0).getViewport().setViewPosition(new Point(0, 0));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }

            static /* synthetic */ JScrollPane access$000(3 var0) {
                return var0.jScrollPane;
            }
        });
        jDialog.show();
    }

    public static int showLocalInstallDialog(Window window, String string) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new JButton[4];
        objectArray2[0] = new JButton(Resources.getString("install.yesButton"));
        objectArray2[0].setMnemonic(Resources.getVKCode("install.yesMnemonic"));
        final JButton jButton = objectArray2[0];
        objectArray2[1] = new JButton(Resources.getString("install.noButton"));
        objectArray2[1].setMnemonic(Resources.getVKCode("install.noMnemonic"));
        final JButton jButton2 = objectArray2[1];
        objectArray2[2] = new JButton(Resources.getString("install.askButton"));
        objectArray2[2].setMnemonic(Resources.getVKCode("install.askMnemonic"));
        objectArray2[3] = new JButton(Resources.getString("install.configButton"));
        objectArray2[3].setMnemonic(Resources.getVKCode("install.configMnemonic"));
        for (int i = 0; i < 3; ++i) {
            objectArray2[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GeneralUtilities.setReturn((JButton)actionEvent.getSource());
                }
            });
        }
        objectArray2[3].addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Component component;
                WhenInstallPanel whenInstallPanel = new WhenInstallPanel();
                String string = Resources.getString("install.configureTitle");
                for (component = (Component)actionEvent.getSource(); component != null && !(component instanceof JDialog); component = component.getParent()) {
                }
                int n = GeneralUtilities.showOptionDialog(component, whenInstallPanel, string, 2, -1, null, null, false, null);
                switch (n) {
                    case 0: {
                        ConfigProperties configProperties = ConfigProperties.getInstance();
                        int n2 = whenInstallPanel.getWhen();
                        if (n2 == 1) {
                            configProperties.setWhenInstall(n2);
                            GeneralUtilities.setReturn(jButton);
                        } else if (n2 == 0) {
                            configProperties.setWhenInstall(n2);
                            GeneralUtilities.setReturn(jButton2);
                        } else {
                            configProperties.setWhenInstall(2);
                        }
                        ConfigProperties configProperties2 = configProperties;
                        synchronized (configProperties2) {
                            configProperties.store();
                            break;
                        }
                    }
                }
            }
        });
        String string2 = Resources.getString("install.installTitle", string);
        objectArray[0] = Resources.getString("install.message0");
        objectArray[1] = Resources.getString("install.message1", string);
        int n = GeneralUtilities.showOptionDialog(null, objectArray, string2, -1, -1, objectArray2, objectArray2[2], true, null);
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 2;
    }

    public static JFrame createFrame(String string) {
        return new JFrame(string);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n) {
        GeneralUtilities.showOptionDialog(component, object, string, -1, n);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2) {
        return GeneralUtilities.showOptionDialog(component, object, string, n, n2, null, null);
    }

    public static JDialog createDialog(Frame frame, String string, boolean bl) {
        return new JDialog(frame, string, bl);
    }

    public static JTextPane addBoldText(JTextPane jTextPane, String string, Object[] objectArray) {
        int n;
        MessageFormat messageFormat = new MessageFormat("");
        int n2 = 0;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        if (jTextPane == null) {
            jTextPane = new JTextPane(){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width = Math.min(400, dimension.width);
                    return dimension;
                }
            };
        }
        Document document = jTextPane.getDocument();
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setFontFamily(simpleAttributeSet, "SansSerif");
        StyleConstants.setFontFamily(simpleAttributeSet2, "SansSerif");
        while ((n = string.indexOf("{", n2)) != -1) {
            if (n != 0 && (n <= 0 || string.charAt(n - 1) == '\'')) continue;
            if (n2 != n) {
                try {
                    document.insertString(document.getLength(), string.substring(n2, n), simpleAttributeSet2);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            int n3 = string.indexOf("}", n) + 1;
            messageFormat.applyPattern(string.substring(n, n3));
            try {
                document.insertString(document.getLength(), messageFormat.format(objectArray), simpleAttributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            n2 = n3;
        }
        if (n2 < string.length()) {
            try {
                document.insertString(document.getLength(), string.substring(n2), simpleAttributeSet2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        jTextPane.setOpaque(false);
        jTextPane.setEditable(false);
        return jTextPane;
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Object[] objectArray, Object object2) {
        return GeneralUtilities.showOptionDialog(component, object, string, n, n2, objectArray, object2, false, null);
    }

    public static String showInputDialog(Component component, Object object, String string, String string2) {
        return (String)JOptionPane.showInputDialog(component, GeneralUtilities.messageFormat(object), string, -1, GeneralUtilities.getDefaultImage(), null, string2);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Object[] objectArray, Object object2, Icon icon) {
        return GeneralUtilities.showOptionDialog(component, object, string, n, n2, objectArray, object2, false, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showOptionDialog(Component component, Object object, String string, int n, int n2, Object[] objectArray, Object object2, boolean bl, Icon icon) {
        if (icon == null) {
            icon = GeneralUtilities.getDefaultImage();
        }
        JOptionPane jOptionPane = new JOptionPane(GeneralUtilities.messageFormat(object), n2, n, icon, objectArray, object2);
        final JDialog jDialog = jOptionPane.createDialog(component, string);
        jOptionPane.selectInitialValue();
        GeneralUtilities.invokeOnEventDispatchingThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Container container = jDialog.getContentPane();
                Graphics graphics = container.getGraphics();
                try {
                    graphics.setClip(new Rectangle(0, 0, container.getWidth(), container.getHeight()));
                    container.paint(graphics);
                }
                finally {
                    graphics.dispose();
                }
                jDialog.validate();
                jDialog.setSize(jDialog.getPreferredSize());
            }
        });
        SplashScreen.hide();
        final Object object3 = new Object();
        if (bl) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                Debug.ignoredException(exception);
            }
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int n = 0;
                    do {
                        try {
                            Thread.sleep(1000L);
                            Object object = object3;
                            synchronized (object) {
                                Window[] windowArray = jDialog.getOwnedWindows();
                                if (jDialog.isShowing() && (windowArray == null || windowArray.length == 0)) {
                                    jDialog.toFront();
                                }
                            }
                        }
                        catch (Exception exception) {
                            Debug.ignoredException(exception);
                        }
                    } while (++n < 8 && jDialog.isShowing());
                }
            }).start();
        }
        jDialog.show();
        Object object4 = object3;
        synchronized (object4) {
            jDialog.dispose();
        }
        object4 = jOptionPane.getValue();
        if (object4 == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object4 instanceof Integer) {
                return (Integer)object4;
            }
            return -1;
        }
        int n3 = objectArray.length;
        for (int i = 0; i < n3; ++i) {
            if (!objectArray[i].equals(object4)) continue;
            return i;
        }
        return -1;
    }

    private static class PlainTextArea
    extends JTextArea {
        public boolean isFocusTraversable() {
            return false;
        }

        PlainTextArea(String string) {
            super(string);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setOpaque(false);
            this.setEditable(false);
        }
    }
}

