/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.Resource;
import com.sun.javaws.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JNLPClassPath {
    private Stack _pendingJarDescs = new Stack();
    private ArrayList _loaders = new ArrayList();
    private Loader _appletLoader = null;
    private LaunchDesc _launchDesc = null;
    private HashMap _fileToUrls = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources() {
        Object object;
        try {
            object = this.getNextPendingJarDesc();
            while (object != null) {
                this.createLoader((JARDesc)object);
                object = this.getNextPendingJarDesc();
            }
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        if (this._appletLoader != null) {
            object = this._loaders;
            synchronized (object) {
                this._loaders.add(this._appletLoader);
            }
        }
    }

    private synchronized JARDesc getNextPendingJarDesc() {
        return this._pendingJarDescs.isEmpty() ? null : (JARDesc)this._pendingJarDescs.pop();
    }

    public JNLPClassPath(LaunchDesc launchDesc, boolean bl) {
        Object object;
        this._launchDesc = launchDesc;
        if (bl) {
            object = URLUtil.getBase(launchDesc.getCanonicalHome());
            if (Globals.TraceStartup) {
                Debug.println("Classpath: " + object);
            }
            this._appletLoader = "file".equals(((URL)object).getProtocol()) ? new FileDirectoryLoader((URL)object) : new URLDirectoryLoader((URL)object);
        }
        if ((object = launchDesc.getResources()) != null) {
            JARDesc[] jARDescArray = ((ResourcesDesc)object).getEagerOrAllJarDescs(true);
            for (int i = jARDescArray.length - 1; i >= 0; --i) {
                if (!jARDescArray[i].isJavaFile()) continue;
                if (Globals.TraceStartup) {
                    Debug.println("Classpath: " + jARDescArray[i].getLocation() + ":" + jARDescArray[i].getVersion());
                }
                this._pendingJarDescs.add(jARDescArray[i]);
            }
        }
    }

    private static void check(URL uRL) throws IOException {
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = uRL.openConnection().getPermission()) != null) {
            securityManager.checkPermission(permission);
        }
    }

    private synchronized JARDesc getIfPendingJarDesc(JARDesc jARDesc) {
        if (this._pendingJarDescs.contains(jARDesc)) {
            this._pendingJarDescs.remove(jARDesc);
            return jARDesc;
        }
        return null;
    }

    public synchronized JARDesc getJarDescFromFileURL(URL uRL) {
        return (JARDesc)this._fileToUrls.get(uRL.toString());
    }

    private Loader createLoader(final JARDesc jARDesc) throws IOException {
        try {
            return (Loader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return JNLPClassPath.this.createLoaderHelper(jARDesc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (Globals.TraceStartup || Globals.TraceClassLoading) {
                Debug.println("Failed to create loader for: " + jARDesc + " (" + privilegedActionException.getException() + ")");
            }
            throw (IOException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loader createLoaderHelper(JARDesc jARDesc) throws IOException {
        URL uRL = jARDesc.getLocation();
        String string = jARDesc.getVersion();
        try {
            DiskCacheEntry diskCacheEntry = DownloadProtocol.getResource(uRL, string, 0, true, null);
            if (diskCacheEntry == null || !diskCacheEntry.getFile().exists()) {
                throw new IOException("Resource not found: " + jARDesc.getLocation() + ":" + jARDesc.getVersion());
            }
            String string2 = URLUtil.getEncodedPath(diskCacheEntry.getFile());
            URL uRL2 = new URL("file", "", string2);
            if (Globals.TraceStartup) {
                Debug.println("Creating loader for: " + uRL2);
            }
            JarLoader jarLoader = new JarLoader(uRL2);
            JNLPClassPath jNLPClassPath = this;
            synchronized (jNLPClassPath) {
                this._loaders.add(jarLoader);
                this._fileToUrls.put(uRL2.toString(), jARDesc);
            }
            return jarLoader;
        }
        catch (JNLPException jNLPException) {
            if (Globals.TraceStartup || Globals.TraceClassLoading) {
                Debug.println("Failed to download: " + jNLPException + " (" + jNLPException + ")");
            }
            Debug.ignoredException(jNLPException);
            throw new IOException(jNLPException.getMessage());
        }
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource findNamedResource(String string, boolean bl) throws IOException {
        Object object;
        Resource resource = this.findNamedResourceInLoaders(string, bl);
        if (resource != null) {
            return resource;
        }
        Object object2 = this;
        synchronized (object2) {
            if (this._pendingJarDescs.isEmpty()) {
                return null;
            }
        }
        object2 = this._launchDesc.getResources().getPackageInformation(string);
        if (object2 != null) {
            object = ((ResourcesDesc.PackageInformation)object2).getLaunchDesc().getResources().getPart(((ResourcesDesc.PackageInformation)object2).getPart());
            for (int i = 0; i < ((JARDesc[])object).length; ++i) {
                JARDesc jARDesc = this.getIfPendingJarDesc(object[i]);
                if (jARDesc == null) continue;
                this.createLoader(jARDesc);
            }
            resource = this.findNamedResourceInLoaders(string, bl);
            if (resource != null) {
                return resource;
            }
        }
        object = this.getNextPendingJarDesc();
        while (object != null) {
            Loader loader = this.createLoader((JARDesc)object);
            resource = loader.getResource(string, bl);
            if (resource != null) {
                return resource;
            }
            object = this.getNextPendingJarDesc();
        }
        if (this._appletLoader != null) {
            resource = this._appletLoader.getResource(string, bl);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource findNamedResourceInLoaders(String string, boolean bl) throws IOException {
        int n = 0;
        JNLPClassPath jNLPClassPath = this;
        synchronized (jNLPClassPath) {
            n = this._loaders.size();
        }
        for (int i = 0; i < n; ++i) {
            Loader loader = null;
            Object object = this;
            synchronized (object) {
                loader = (Loader)this._loaders.get(i);
            }
            object = loader.getResource(string, bl);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Resource getResource(String string, boolean bl) {
        if (Globals.TraceClassLoading) {
            Debug.println("getResource: " + string + " (check: " + bl + ")");
        }
        try {
            return this.findNamedResource(string, bl);
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
            return null;
        }
    }

    public URL checkURL(URL uRL) {
        try {
            JNLPClassPath.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    public Enumeration getResources(String string) {
        return this.getResources(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getResources(final String string, final boolean bl) {
        int n;
        this.loadAllResources();
        JNLPClassPath jNLPClassPath = this;
        synchronized (jNLPClassPath) {
            n = this._loaders.size();
        }
        final int n2 = n;
        return new Enumeration(){
            private int index = 0;
            private Resource res = null;

            public boolean hasMoreElements() {
                return this.next();
            }

            private boolean next() {
                if (this.res != null) {
                    return true;
                }
                while (this.index < n2) {
                    Loader loader = (Loader)JNLPClassPath.this._loaders.get(this.index++);
                    this.res = loader.getResource(string, bl);
                    if (this.res == null) continue;
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource resource = this.res;
                this.res = null;
                return resource;
            }
        };
    }

    private static class FileDirectoryLoader
    extends Loader {
        private File dir;

        FileDirectoryLoader(URL uRL) {
            super(uRL);
            Debug.jawsAssert("file".equals(uRL.getProtocol()), "must be FILE URL");
            this.dir = new File(URLUtil.getPathFromURL(uRL));
        }

        Resource getResource(String string, boolean bl) {
            try {
                File file;
                URL uRL = new URL(this.getBaseURL(), string);
                if (!uRL.getFile().startsWith(this.getBaseURL().getFile())) {
                    return null;
                }
                if (bl) {
                    JNLPClassPath.check(uRL);
                }
                if ((file = new File(this.dir, string.replace('/', File.separatorChar))).exists()) {
                    return new Resource(this, string, uRL, file){
                        private final /* synthetic */ String val$name;
                        private final /* synthetic */ URL val$url;
                        private final /* synthetic */ File val$file;
                        private final /* synthetic */ FileDirectoryLoader this$0;

                        public int getContentLength() throws IOException {
                            return (int)this.val$file.length();
                        }

                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(this.val$file);
                        }

                        public String getName() {
                            return this.val$name;
                        }

                        public URL getCodeSourceURL() {
                            return this.this$0.getBaseURL();
                        }

                        public URL getURL() {
                            return this.val$url;
                        }
                        {
                            this.this$0 = fileDirectoryLoader;
                            this.val$name = string;
                            this.val$url = uRL;
                            this.val$file = file;
                        }
                    };
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }
    }

    private static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;

        JarLoader(URL uRL) throws IOException {
            super(new URL("jar", "", -1, uRL + "!/"));
            this.jar = this.getJarFile(uRL);
            this.csu = uRL;
            Debug.jawsAssert("file".equals(uRL.getProtocol()), "Only works for file URLs");
        }

        Resource getResource(String string, boolean bl) {
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry != null) {
                URL uRL;
                try {
                    uRL = new URL(this.getBaseURL(), string);
                    if (bl) {
                        JNLPClassPath.check(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.ignoredException(malformedURLException);
                    return null;
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                    return null;
                }
                catch (AccessControlException accessControlException) {
                    Debug.ignoredException(accessControlException);
                    return null;
                }
                return new Resource(this, string, uRL, jarEntry){
                    private final /* synthetic */ String val$name;
                    private final /* synthetic */ URL val$url;
                    private final /* synthetic */ JarEntry val$entry;
                    private final /* synthetic */ JarLoader this$0;

                    public int getContentLength() {
                        return (int)this.val$entry.getSize();
                    }

                    public InputStream getInputStream() throws IOException {
                        return JarLoader.access$400(this.this$0).getInputStream(this.val$entry);
                    }

                    public String getName() {
                        return this.val$name;
                    }

                    public URL getCodeSourceURL() {
                        return JarLoader.access$300(this.this$0);
                    }

                    public URL getURL() {
                        return this.val$url;
                    }

                    public Certificate[] getCertificates() {
                        return this.val$entry.getCertificates();
                    }

                    public Manifest getManifest() throws IOException {
                        return JarLoader.access$400(this.this$0).getManifest();
                    }
                    {
                        this.this$0 = jarLoader;
                        this.val$name = string;
                        this.val$url = uRL;
                        this.val$entry = jarEntry;
                    }
                };
            }
            return null;
        }

        static /* synthetic */ URL access$300(JarLoader jarLoader) {
            return jarLoader.csu;
        }

        static /* synthetic */ JarFile access$400(JarLoader jarLoader) {
            return jarLoader.jar;
        }

        private JarFile getJarFile(URL uRL) throws IOException {
            if ("file".equals(uRL.getProtocol())) {
                String string = URLUtil.getPathFromURL(uRL);
                File file = new File(string);
                if (!file.exists()) {
                    throw new FileNotFoundException(string);
                }
                return new JarFile(string);
            }
            throw new IOException("Must be file URL");
        }
    }

    private static abstract class Loader {
        private final URL base;

        URL getBaseURL() {
            return this.base;
        }

        Loader(URL uRL) {
            this.base = uRL;
        }

        Resource getResource(String string) {
            return this.getResource(string, true);
        }

        abstract Resource getResource(String var1, boolean var2);
    }

    private static class URLDirectoryLoader
    extends Loader {
        URLDirectoryLoader(URL uRL) {
            super(uRL);
        }

        Resource getResource(String string, boolean bl) {
            URLConnection uRLConnection;
            URL uRL;
            try {
                uRL = new URL(this.getBaseURL(), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (bl) {
                    JNLPClassPath.check(uRL);
                }
                if ((uRLConnection = uRL.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    int n = httpURLConnection.getResponseCode();
                    if (n >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                return null;
            }
            return new Resource(this, string, uRL, uRLConnection){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ URL val$url;
                private final /* synthetic */ URLConnection val$uc;
                private final /* synthetic */ URLDirectoryLoader this$0;

                public int getContentLength() throws IOException {
                    return this.val$uc.getContentLength();
                }

                public InputStream getInputStream() throws IOException {
                    return this.val$uc.getInputStream();
                }

                public String getName() {
                    return this.val$name;
                }

                public URL getCodeSourceURL() {
                    return this.this$0.getBaseURL();
                }

                public URL getURL() {
                    return this.val$url;
                }
                {
                    this.this$0 = uRLDirectoryLoader;
                    this.val$name = string;
                    this.val$url = uRL;
                    this.val$uc = uRLConnection;
                }
            };
        }
    }
}

