/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class BorderLayout
extends AbstractHintLayout {
    public static final Integer CENTER = new Integer(2);
    public static final Integer TOP = new Integer(8);
    public static final Integer BOTTOM = new Integer(32);
    public static final Integer LEFT = new Integer(1);
    public static final Integer RIGHT = new Integer(4);
    private IFigure center;
    private IFigure left;
    private IFigure top;
    private IFigure bottom;
    private IFigure right;
    private int vGap = 0;
    private int hGap = 0;

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        Dimension childSize;
        int minWHint = 0;
        int minHHint = 0;
        if (wHint < 0) {
            minWHint = -1;
        }
        if (hHint < 0) {
            minHHint = -1;
        }
        Insets border = container.getInsets();
        wHint = Math.max(minWHint, wHint - border.getWidth());
        hHint = Math.max(minHHint, hHint - border.getHeight());
        Dimension minSize = new Dimension();
        int middleRowWidth = 0;
        int middleRowHeight = 0;
        int rows = 0;
        int columns = 0;
        if (this.top != null && this.top.isVisible()) {
            childSize = this.top.getMinimumSize(wHint, hHint);
            hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
            minSize.setSize(childSize);
            ++rows;
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            childSize = this.bottom.getMinimumSize(wHint, hHint);
            hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
            minSize.width = Math.max(minSize.width, childSize.width);
            minSize.height += childSize.height;
            ++rows;
        }
        if (this.left != null && this.left.isVisible()) {
            childSize = this.left.getMinimumSize(wHint, hHint);
            middleRowWidth = childSize.width;
            middleRowHeight = childSize.height;
            wHint = Math.max(minWHint, wHint - (childSize.width + this.hGap));
            ++columns;
        }
        if (this.right != null && this.right.isVisible()) {
            childSize = this.right.getMinimumSize(wHint, hHint);
            middleRowWidth += childSize.width;
            middleRowHeight = Math.max(childSize.height, middleRowHeight);
            wHint = Math.max(minWHint, wHint - (childSize.width + this.hGap));
            ++columns;
        }
        if (this.center != null && this.center.isVisible()) {
            childSize = this.center.getMinimumSize(wHint, hHint);
            middleRowWidth += childSize.width;
            middleRowHeight = Math.max(childSize.height, middleRowHeight);
            ++columns;
        }
        minSize.height += middleRowHeight + border.getHeight() + ((rows += columns > 0 ? 1 : 0) - 1) * this.vGap;
        minSize.width = Math.max(minSize.width, middleRowWidth) + border.getWidth() + (columns - 1) * this.hGap;
        return minSize;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension childSize;
        int minWHint = 0;
        int minHHint = 0;
        if (wHint < 0) {
            minWHint = -1;
        }
        if (hHint < 0) {
            minHHint = -1;
        }
        Insets border = container.getInsets();
        wHint = Math.max(minWHint, wHint - border.getWidth());
        hHint = Math.max(minHHint, hHint - border.getHeight());
        Dimension prefSize = new Dimension();
        int middleRowWidth = 0;
        int middleRowHeight = 0;
        int rows = 0;
        int columns = 0;
        if (this.top != null && this.top.isVisible()) {
            childSize = this.top.getPreferredSize(wHint, hHint);
            hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
            prefSize.setSize(childSize);
            ++rows;
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            childSize = this.bottom.getPreferredSize(wHint, hHint);
            hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
            prefSize.width = Math.max(prefSize.width, childSize.width);
            prefSize.height += childSize.height;
            ++rows;
        }
        if (this.left != null && this.left.isVisible()) {
            childSize = this.left.getPreferredSize(wHint, hHint);
            middleRowWidth = childSize.width;
            middleRowHeight = childSize.height;
            wHint = Math.max(minWHint, wHint - (childSize.width + this.hGap));
            ++columns;
        }
        if (this.right != null && this.right.isVisible()) {
            childSize = this.right.getPreferredSize(wHint, hHint);
            middleRowWidth += childSize.width;
            middleRowHeight = Math.max(childSize.height, middleRowHeight);
            wHint = Math.max(minWHint, wHint - (childSize.width + this.hGap));
            ++columns;
        }
        if (this.center != null && this.center.isVisible()) {
            childSize = this.center.getPreferredSize(wHint, hHint);
            middleRowWidth += childSize.width;
            middleRowHeight = Math.max(childSize.height, middleRowHeight);
            ++columns;
        }
        prefSize.height += middleRowHeight + border.getHeight() + ((rows += columns > 0 ? 1 : 0) - 1) * this.vGap;
        prefSize.width = Math.max(prefSize.width, middleRowWidth) + border.getWidth() + (columns - 1) * this.hGap;
        return prefSize;
    }

    public void layout(IFigure container) {
        Dimension childSize;
        Rectangle area = container.getClientArea();
        Rectangle rect = new Rectangle();
        int wHint = area.width;
        int hHint = area.height;
        int centerXLoc = 0;
        int centerYLoc = 0;
        if (this.top != null && this.top.isVisible()) {
            childSize = this.top.getPreferredSize(wHint, hHint);
            rect.setLocation(area.x, area.y);
            rect.setSize(childSize);
            rect.width = area.width;
            this.top.setBounds(rect);
            centerYLoc = rect.height + this.vGap;
            hHint = Math.max(0, hHint - centerYLoc);
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            childSize = this.bottom.getPreferredSize(wHint, hHint);
            rect.setSize(childSize);
            rect.width = area.width;
            rect.setLocation(area.x, area.y + area.height - rect.height);
            this.bottom.setBounds(rect);
            hHint = Math.max(0, hHint - (rect.height + this.vGap));
        }
        if (this.left != null && this.left.isVisible()) {
            childSize = this.left.getPreferredSize(wHint, hHint);
            rect.setLocation(area.x, area.y + centerYLoc);
            rect.width = childSize.width;
            rect.height = hHint > 0 ? hHint : childSize.height;
            this.left.setBounds(rect);
            centerXLoc = rect.width + this.hGap;
            wHint = Math.max(0, wHint - centerXLoc);
        }
        if (this.right != null && this.right.isVisible()) {
            childSize = this.right.getPreferredSize(wHint, hHint);
            rect.width = childSize.width;
            rect.height = hHint > 0 ? hHint : childSize.height;
            rect.setLocation(area.x + area.width - rect.width, area.y + centerYLoc);
            this.right.setBounds(rect);
            wHint = Math.max(0, wHint - (rect.width + this.hGap));
        }
        if (this.center != null && this.center.isVisible()) {
            rect.setLocation(area.x + centerXLoc, area.y + centerYLoc);
            if (wHint > 0 && hHint > 0) {
                rect.width = wHint;
                rect.height = hHint;
            } else {
                childSize = this.center.getPreferredSize(wHint, hHint);
                rect.setSize(childSize);
                if (rect.width < wHint) {
                    rect.width = wHint;
                }
                if (rect.height < hHint) {
                    rect.height = hHint;
                }
            }
            this.center.setBounds(rect);
        }
    }

    public void remove(IFigure child) {
        if (this.center == child) {
            this.center = null;
        } else if (this.top == child) {
            this.top = null;
        } else if (this.bottom == child) {
            this.bottom = null;
        } else if (this.right == child) {
            this.right = null;
        } else if (this.left == child) {
            this.left = null;
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.remove(child);
        super.setConstraint(child, constraint);
        if (constraint == null) {
            return;
        }
        switch ((Integer)constraint) {
            case 2: {
                this.center = child;
                break;
            }
            case 8: {
                this.top = child;
                break;
            }
            case 32: {
                this.bottom = child;
                break;
            }
            case 4: {
                this.right = child;
                break;
            }
            case 1: {
                this.left = child;
                break;
            }
        }
    }

    public void setHorizontalSpacing(int gap) {
        this.hGap = gap;
    }

    public void setVerticalSpacing(int gap) {
        this.vGap = gap;
    }
}

