/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.util.ObjectIdentifier;

class GSSContextImpl
implements GSSContext {
    private GSSManagerImpl gssManager = null;
    private static final int PRE_INIT = 1;
    private static final int IN_PROGRESS = 2;
    private static final int READY = 3;
    private static final int DELETED = 4;
    private int currentState = 1;
    private boolean initiator;
    private GSSContextSpi mechCtxt = null;
    private Oid mechOid = null;
    private ObjectIdentifier objId = null;
    private GSSCredentialImpl myCred = null;
    private GSSCredentialImpl delegCred = null;
    private GSSNameImpl srcName = null;
    private GSSNameImpl targName = null;
    private int reqLifetime = Integer.MAX_VALUE;
    private ChannelBinding channelBindings = null;
    private boolean reqConfState = true;
    private boolean reqIntegState = true;
    private boolean reqMutualAuthState = true;
    private boolean reqReplayDetState = true;
    private boolean reqSequenceDetState = true;
    private boolean reqCredDelegState = false;
    private boolean reqAnonState = false;

    public int getLifetime() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getLifetime();
        }
        return this.reqLifetime;
    }

    public void dispose() throws GSSException {
        this.currentState = 4;
        this.mechCtxt = null;
        this.myCred = null;
        this.srcName = null;
        this.targName = null;
    }

    public boolean getAnonymityState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getAnonymityState();
        }
        return this.reqAnonState;
    }

    public boolean getConfState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getConfState();
        }
        return this.reqConfState;
    }

    public boolean getCredDelegState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getCredDelegState();
        }
        return this.reqCredDelegState;
    }

    public boolean getIntegState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getIntegState();
        }
        return this.reqIntegState;
    }

    public boolean getMutualAuthState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getMutualAuthState();
        }
        return this.reqMutualAuthState;
    }

    public boolean getReplayDetState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getReplayDetState();
        }
        return this.reqReplayDetState;
    }

    public boolean getSequenceDetState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getSequenceDetState();
        }
        return this.reqSequenceDetState;
    }

    public boolean isEstablished() {
        if (this.mechCtxt == null) {
            return false;
        }
        return this.currentState == 3;
    }

    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    public boolean isProtReady() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.isProtReady();
        }
        return false;
    }

    public boolean isTransferable() throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.isTransferable();
        }
        return false;
    }

    public byte[] export() throws GSSException {
        return null;
    }

    public void requestLifetime(int n2) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqLifetime = n2;
        }
    }

    public int getWrapSizeLimit(int n2, boolean bl2, int n3) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getWrapSizeLimit(n2, bl2, n3);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    public void requestAnonymity(boolean bl2) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqAnonState = bl2;
        }
    }

    public void requestConf(boolean bl2) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqConfState = bl2;
        }
    }

    public void requestCredDeleg(boolean bl2) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqCredDelegState = bl2;
        }
    }

    public void requestInteg(boolean bl2) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqIntegState = bl2;
        }
    }

    public void requestMutualAuth(boolean bl2) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqMutualAuthState = bl2;
        }
    }

    public void requestReplayDet(boolean bl2) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqReplayDetState = bl2;
        }
    }

    public void requestSequenceDet(boolean bl2) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqSequenceDetState = bl2;
        }
    }

    public byte[] acceptSecContext(byte[] byArray, int n2, int n3) throws GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        this.acceptSecContext(new ByteArrayInputStream(byArray, n2, n3), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] initSecContext(byte[] byArray, int n2, int n3) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, n3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(600);
        int n4 = this.initSecContext(byteArrayInputStream, byteArrayOutputStream);
        return n4 == 0 ? null : byteArrayOutputStream.toByteArray();
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        if (this.mechCtxt == null) {
            this.channelBindings = channelBinding;
        }
    }

    public GSSCredential getDelegCred() throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        return new GSSCredentialImpl(this.gssManager, this.mechCtxt.getDelegCred());
    }

    public GSSName getSrcName() throws GSSException {
        return this.srcName;
    }

    public GSSName getTargName() throws GSSException {
        return this.targName;
    }

    public byte[] getMIC(byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getMIC(byArray, n2, n3, messageProp);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.unwrap(byArray, n2, n3, messageProp);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    public byte[] wrap(byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.wrap(byArray, n2, n3, messageProp);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    public void verifyMIC(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.verifyMIC(byArray, n2, n3, byArray2, n4, n5, messageProp);
    }

    public Oid getMech() throws GSSException {
        return this.mechOid;
    }

    public GSSContextImpl(GSSManagerImpl gSSManagerImpl, byte[] byArray) throws GSSException {
        this.gssManager = gSSManagerImpl;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.mechCtxt != null && this.currentState != 2) {
            throw new GSSExceptionImpl(11, "Illegal call to initSecContext");
        }
        GSSHeader gSSHeader = null;
        int n2 = 0;
        try {
            Object object;
            if (this.mechCtxt == null) {
                if (this.myCred == null) {
                    this.myCred = (GSSCredentialImpl)this.gssManager.createCredential(1);
                }
                this.srcName = (GSSNameImpl)this.myCred.getName();
                object = this.myCred.getElement(this.mechOid, true);
                if (this.mechOid == null) {
                    this.mechOid = object.getMechanism();
                }
                this.objId = new ObjectIdentifier(this.mechOid.toString());
                GSSNameSpi gSSNameSpi = this.targName.getElement(this.mechOid);
                this.mechCtxt = this.gssManager.getMechanismContext(gSSNameSpi, (GSSCredentialSpi)object, this.reqLifetime, this.mechOid);
                this.mechCtxt.requestConf(this.reqConfState);
                this.mechCtxt.requestInteg(this.reqIntegState);
                this.mechCtxt.requestCredDeleg(this.reqCredDelegState);
                this.mechCtxt.requestMutualAuth(this.reqMutualAuthState);
                this.mechCtxt.requestReplayDet(this.reqReplayDetState);
                this.mechCtxt.requestSequenceDet(this.reqSequenceDetState);
                this.mechCtxt.requestAnonymity(this.reqAnonState);
                this.mechCtxt.setChannelBinding(this.channelBindings);
                this.currentState = 2;
            } else {
                gSSHeader = new GSSHeader(inputStream);
                if (!gSSHeader.getOid().equals(this.objId)) {
                    throw new GSSExceptionImpl(10, "Mechanism not equal to " + this.mechOid.toString() + " in initSecContext token");
                }
                n2 = gSSHeader.getMechTokenLength();
            }
            object = this.mechCtxt.initSecContext(inputStream, n2);
            int n3 = 0;
            if (object != null) {
                n3 = ((Object)object).length;
                gSSHeader = new GSSHeader(this.objId, ((Object)object).length);
                n3 += gSSHeader.encode(outputStream);
                outputStream.write((byte[])object);
            }
            if (this.mechCtxt.isEstablished()) {
                this.currentState = 3;
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(10, iOException.getMessage());
        }
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.mechCtxt != null && this.currentState != 2) {
            throw new GSSExceptionImpl(11, "Illegal call to acceptSecContext");
        }
        GSSHeader gSSHeader = null;
        int n2 = 0;
        try {
            Object object;
            gSSHeader = new GSSHeader(inputStream);
            if (this.mechCtxt == null) {
                this.objId = gSSHeader.getOid();
                this.mechOid = new Oid(this.objId.toString());
                if (this.myCred == null) {
                    this.myCred = (GSSCredentialImpl)this.gssManager.createCredential(null, Integer.MAX_VALUE, this.mechOid, 2);
                }
                this.targName = (GSSNameImpl)this.myCred.getName();
                object = this.myCred.getElement(this.mechOid, false);
                this.mechCtxt = this.gssManager.getMechanismContext((GSSCredentialSpi)object, this.mechOid);
                this.mechCtxt.setChannelBinding(this.channelBindings);
                this.currentState = 2;
            } else if (!gSSHeader.getOid().equals(this.objId)) {
                throw new GSSExceptionImpl(10, "Mechanism not equal to " + this.mechOid.toString() + " in acceptSecContext token");
            }
            n2 = gSSHeader.getMechTokenLength();
            object = this.mechCtxt.acceptSecContext(inputStream, n2);
            if (object != null) {
                int n3 = ((byte[])object).length;
                gSSHeader = new GSSHeader(this.objId, ((byte[])object).length);
                n3 += gSSHeader.encode(outputStream);
                outputStream.write((byte[])object);
            }
            this.srcName = new GSSNameImpl(this.gssManager, this.mechCtxt.getSrcName());
            if (this.mechCtxt.isEstablished()) {
                this.currentState = 3;
            }
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(10, iOException.getMessage());
        }
    }

    public GSSContextImpl(GSSManagerImpl gSSManagerImpl, GSSCredential gSSCredential) throws GSSException {
        this.gssManager = gSSManagerImpl;
        this.myCred = (GSSCredentialImpl)gSSCredential;
        this.initiator = false;
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.verifyMIC(inputStream, inputStream2, messageProp);
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.getMIC(inputStream, outputStream, messageProp);
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.unwrap(inputStream, outputStream, messageProp);
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.wrap(inputStream, outputStream, messageProp);
    }

    public GSSContextImpl(GSSManagerImpl gSSManagerImpl, GSSName gSSName, Oid oid, GSSCredential gSSCredential, int n2) throws GSSException {
        this.gssManager = gSSManagerImpl;
        this.myCred = (GSSCredentialImpl)gSSCredential;
        this.reqLifetime = n2;
        this.targName = (GSSNameImpl)gSSName;
        this.mechOid = this.mechOid;
        this.initiator = true;
    }
}

