/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.util.Vector;
import org.apache.xml.utils.IntVector;

public class DTMStringPool {
    Vector m_intToString;
    static final int HASHPRIME = 101;
    int[] m_hashStart = new int[101];
    IntVector m_hashChain;
    public static final int NULL = -1;

    public DTMStringPool() {
        this.m_intToString = new Vector();
        this.m_hashChain = new IntVector(512);
        this.removeAllElements();
        this.stringToIndex("");
    }

    public void removeAllElements() {
        this.m_intToString.removeAllElements();
        for (int i2 = 0; i2 < 101; ++i2) {
            this.m_hashStart[i2] = -1;
        }
        this.m_hashChain.removeAllElements();
    }

    public String indexToString(int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 == -1) {
            return null;
        }
        return (String)this.m_intToString.elementAt(n2);
    }

    public int stringToIndex(String string) {
        int n2;
        if (string == null) {
            return -1;
        }
        int n3 = string.hashCode() % 101;
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = n2 = this.m_hashStart[n3];
        while (n4 != -1) {
            if (this.m_intToString.elementAt(n4).equals(string)) {
                return n4;
            }
            n2 = n4;
            n4 = this.m_hashChain.elementAt(n4);
        }
        int n5 = this.m_intToString.size();
        this.m_intToString.addElement(string);
        this.m_hashChain.addElement(-1);
        if (n2 == -1) {
            this.m_hashStart[n3] = n5;
        } else {
            this.m_hashChain.setElementAt(n5, n2);
        }
        return n5;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen", "Twenty", "Twenty-One", "Twenty-Two", "Twenty-Three", "Twenty-Four", "Twenty-Five", "Twenty-Six", "Twenty-Seven", "Twenty-Eight", "Twenty-Nine", "Thirty", "Thirty-One", "Thirty-Two", "Thirty-Three", "Thirty-Four", "Thirty-Five", "Thirty-Six", "Thirty-Seven", "Thirty-Eight", "Thirty-Nine"};
        DTMStringPool dTMStringPool = new DTMStringPool();
        System.out.println("If no complaints are printed below, we passed initial test.");
        for (int i2 = 0; i2 <= 1; ++i2) {
            int n2;
            int n3;
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                n2 = dTMStringPool.stringToIndex(stringArray2[n3]);
                if (n2 == n3) continue;
                System.out.println("\tMismatch populating pool: assigned " + n2 + " for create " + n3);
            }
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                n2 = dTMStringPool.stringToIndex(stringArray2[n3]);
                if (n2 == n3) continue;
                System.out.println("\tMismatch in stringToIndex: returned " + n2 + " for lookup " + n3);
            }
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                String string = dTMStringPool.indexToString(n3);
                if (stringArray2[n3].equals(string)) continue;
                System.out.println("\tMismatch in indexToString: returned" + string + " for lookup " + n3);
            }
            dTMStringPool.removeAllElements();
            System.out.println("\nPass " + i2 + " complete\n");
        }
    }
}

