/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.RandomAccessSubList;
import java.util.SubList;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount = 0;

    public int hashCode() {
        int n2 = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            n2 = 31 * n2 + (object == null ? 0 : object.hashCode());
        }
        return n2;
    }

    protected AbstractList() {
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    protected void removeRange(int n2, int n3) {
        ListIterator listIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            listIterator.next();
            listIterator.remove();
        }
    }

    public abstract Object get(int var1);

    public Object remove(int n2) {
        throw new UnsupportedOperationException();
    }

    public void add(int n2, Object object) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        if (object == null) {
            while (listIterator.hasNext()) {
                if (listIterator.next() != null) continue;
                return listIterator.previousIndex();
            }
        } else {
            while (listIterator.hasNext()) {
                if (!object.equals(listIterator.next())) continue;
                return listIterator.previousIndex();
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        ListIterator listIterator = this.listIterator(this.size());
        if (object == null) {
            while (listIterator.hasPrevious()) {
                if (listIterator.previous() != null) continue;
                return listIterator.nextIndex();
            }
        } else {
            while (listIterator.hasPrevious()) {
                if (!object.equals(listIterator.previous())) continue;
                return listIterator.nextIndex();
            }
        }
        return -1;
    }

    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = ((List)object).listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object object2 = listIterator.next();
            Object object3 = listIterator2.next();
            if (object2 != null ? object2.equals(object3) : object3 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    public boolean addAll(int n2, Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n2++, iterator.next());
            bl2 = true;
        }
        return bl2;
    }

    public Iterator iterator() {
        return new Itr();
    }

    public List subList(int n2, int n3) {
        return this instanceof RandomAccess ? new RandomAccessSubList(this, n2, n3) : new SubList(this, n2, n3);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n2) {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        return new ListItr(n2);
    }

    public Object set(int n2, Object object) {
        throw new UnsupportedOperationException();
    }

    private class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        final void checkForComodification() {
            if (AbstractList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            return this.cursor != AbstractList.this.size();
        }

        public Object next() {
            this.checkForComodification();
            try {
                Object object = AbstractList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        private Itr() {
            this.expectedModCount = AbstractList.this.modCount;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            this.checkForComodification();
            try {
                int n2 = this.cursor - 1;
                Object object = AbstractList.this.get(n2);
                this.lastRet = this.cursor = n2;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public void add(Object object) {
            this.checkForComodification();
            try {
                AbstractList.this.add(this.cursor++, object);
                this.lastRet = -1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void set(Object object) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.set(this.lastRet, object);
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        ListItr(int n2) {
            this.cursor = n2;
        }
    }
}

