/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import sun.misc.SoftCache;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker = new Object();
    private static final HashMap primClasses = new HashMap(8, 1.0f);
    private static final SoftCache subclassAudits;
    private final BlockDataInputStream bin;
    private final ValidationList vlist;
    private int depth;
    private boolean closed;
    private final HandleTable handles;
    private int passHandle = -1;
    private boolean defaultDataEnd = false;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableResolve;
    private Object curObj;
    private ObjectStreamClass curDesc;
    private GetFieldImpl curGet;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$lang$Object;

    public byte readByte() throws IOException {
        return this.bin.readByte();
    }

    public char readChar() throws IOException {
        return this.bin.readChar();
    }

    public double readDouble() throws IOException {
        return this.bin.readDouble();
    }

    public float readFloat() throws IOException {
        return this.bin.readFloat();
    }

    public int available() throws IOException {
        return this.bin.available();
    }

    public int read() throws IOException {
        return this.bin.read();
    }

    public int readInt() throws IOException {
        return this.bin.readInt();
    }

    public int readUnsignedByte() throws IOException {
        return this.bin.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.bin.readUnsignedShort();
    }

    public long readLong() throws IOException {
        return this.bin.readLong();
    }

    public short readShort() throws IOException {
        return this.bin.readShort();
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
        subclassAudits = new SoftCache(5);
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bin = null;
        this.handles = null;
        this.vlist = null;
        this.enableOverride = true;
    }

    private void clear() {
        this.handles.clear();
        this.vlist.clear();
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.depth == 0) {
            this.clear();
        }
        this.bin.close();
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        ClassNotFoundException classNotFoundException;
        if (this.curObj == null || this.curDesc == null) {
            throw new NotActiveException("not in call to readObject");
        }
        this.bin.setBlockDataMode(false);
        this.defaultReadFields(this.curObj, this.curDesc);
        this.bin.setBlockDataMode(true);
        if (!this.curDesc.hasWriteObjectData()) {
            this.defaultDataEnd = true;
        }
        if ((classNotFoundException = this.handles.lookupException(this.passHandle)) != null) {
            throw classNotFoundException;
        }
    }

    private void handleReset() throws StreamCorruptedException {
        if (this.depth > 0) {
            throw new StreamCorruptedException("unexpected reset");
        }
        this.clear();
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (this.bin.readShort() != -21267 || this.bin.readShort() != 5) {
            throw new StreamCorruptedException("invalid stream header");
        }
    }

    private void skipCustomData() throws IOException {
        int n2 = this.passHandle;
        block4: while (true) {
            if (this.bin.getBlockDataMode()) {
                this.bin.skipBlockData();
                this.bin.setBlockDataMode(false);
            }
            switch (this.bin.peekByte()) {
                case 119: 
                case 122: {
                    this.bin.setBlockDataMode(true);
                    continue block4;
                }
                case 120: {
                    this.bin.readByte();
                    this.passHandle = n2;
                    return;
                }
            }
            this.readObject0(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySubclass() {
        Class clazz = this.getClass();
        Object object = subclassAudits;
        synchronized (object) {
            Boolean bl2 = (Boolean)subclassAudits.get(clazz);
            if (bl2 == null) {
                bl2 = new Boolean(ObjectInputStream.auditSubclass(clazz));
                subclassAudits.put(clazz, bl2);
            }
            if (bl2.booleanValue()) {
                return;
            }
        }
        object = System.getSecurityManager();
        if (object != null) {
            ((SecurityManager)object).checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
    }

    public boolean readBoolean() throws IOException {
        return this.bin.readBoolean();
    }

    public int skipBytes(int n2) throws IOException {
        return this.bin.skipBytes(n2);
    }

    protected boolean enableResolveObject(boolean bl2) throws SecurityException {
        SecurityManager securityManager;
        if (bl2 == this.enableResolve) {
            return bl2;
        }
        if (bl2 && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableResolve = bl2;
        return !this.enableResolve;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.bin.readFully(byArray, 0, byArray.length, false);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        if (n2 < 0 || n3 < 0 || n4 > byArray.length || n4 < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.bin.read(byArray, n2, n3, false);
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        if (n2 < 0 || n3 < 0 || n4 > byArray.length || n4 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bin.readFully(byArray, n2, n3, false);
    }

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private IOException readFatalException() throws IOException {
        if (this.bin.readByte() != 123) {
            throw new StreamCorruptedException();
        }
        this.clear();
        return (IOException)this.readObject0(false);
    }

    public ObjectInputStream(InputStream inputStream) throws IOException {
        this.verifySubclass();
        this.bin = new BlockDataInputStream(inputStream);
        this.handles = new HandleTable(10);
        this.vlist = new ValidationList();
        this.enableOverride = false;
        this.readStreamHeader();
        this.bin.setBlockDataMode(true);
    }

    public GetField readFields() throws IOException, ClassNotFoundException {
        if (this.curGet == null) {
            if (this.curObj == null || this.curDesc == null) {
                throw new NotActiveException("not in call to readObject");
            }
            this.curGet = new GetFieldImpl(this.curDesc);
        }
        this.bin.setBlockDataMode(false);
        this.curGet.readFields();
        this.bin.setBlockDataMode(true);
        if (!this.curDesc.hasWriteObjectData()) {
            this.defaultDataEnd = true;
        }
        return this.curGet;
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n2) throws NotActiveException, InvalidObjectException {
        if (this.depth == 0) {
            throw new NotActiveException("stream inactive");
        }
        this.vlist.register(objectInputValidation, n2);
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        objectStreamClass.readNonProxy(this);
        return objectStreamClass;
    }

    private ObjectStreamClass readClassDesc(boolean bl2) throws IOException {
        switch (this.bin.peekByte()) {
            case 112: {
                return (ObjectStreamClass)this.readNull();
            }
            case 113: {
                return (ObjectStreamClass)this.readHandle(bl2);
            }
            case 125: {
                return this.readProxyDesc(bl2);
            }
            case 114: {
                return this.readNonProxyDesc(bl2);
            }
        }
        throw new StreamCorruptedException();
    }

    private ObjectStreamClass readNonProxyDesc(boolean bl2) throws IOException {
        if (this.bin.readByte() != 114) {
            throw new StreamCorruptedException();
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        int n2 = this.handles.assign(bl2 ? unsharedMarker : objectStreamClass);
        this.passHandle = -1;
        ObjectStreamClass objectStreamClass2 = null;
        try {
            objectStreamClass2 = this.readClassDescriptor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (IOException)new InvalidClassException("failed to read class descriptor").initCause(classNotFoundException);
        }
        Class clazz = null;
        ClassNotFoundException classNotFoundException = null;
        this.bin.setBlockDataMode(true);
        try {
            clazz = this.resolveClass(objectStreamClass2);
            if (clazz == null) {
                throw new ClassNotFoundException("null class");
            }
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        this.skipCustomData();
        objectStreamClass.initNonProxy(objectStreamClass2, clazz, classNotFoundException, this.readClassDesc(false));
        this.handles.finish(n2);
        this.passHandle = n2;
        return objectStreamClass;
    }

    private ObjectStreamClass readProxyDesc(boolean bl2) throws IOException {
        if (this.bin.readByte() != 125) {
            throw new StreamCorruptedException();
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        int n2 = this.handles.assign(bl2 ? unsharedMarker : objectStreamClass);
        this.passHandle = -1;
        int n3 = this.bin.readInt();
        String[] stringArray = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            stringArray[i2] = this.bin.readUTF();
        }
        Class clazz = null;
        ClassNotFoundException classNotFoundException = null;
        this.bin.setBlockDataMode(true);
        try {
            clazz = this.resolveProxyClass(stringArray);
            if (clazz == null) {
                throw new ClassNotFoundException("null class");
            }
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        this.skipCustomData();
        objectStreamClass.initProxy(clazz, classNotFoundException, this.readClassDesc(false));
        this.handles.finish(n2);
        this.passHandle = n2;
        return objectStreamClass;
    }

    private static boolean auditSubclass(final Class clazz) {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class clazz2 = clazz; clazz2 != (class$java$io$ObjectInputStream == null ? ObjectInputStream.class$("java.io.ObjectInputStream") : class$java$io$ObjectInputStream); clazz2 = clazz2.getSuperclass()) {
                    try {
                        clazz2.getDeclaredMethod("readUnshared", new Class[0]);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            clazz2.getDeclaredMethod("readFields", new Class[0]);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return bl2;
    }

    private Class readClass(boolean bl2) throws IOException {
        if (this.bin.readByte() != 118) {
            throw new StreamCorruptedException();
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        Class clazz = objectStreamClass.forClass();
        this.passHandle = this.handles.assign(bl2 ? unsharedMarker : clazz);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(this.passHandle, classNotFoundException);
        }
        this.handles.finish(this.passHandle);
        return clazz;
    }

    private static native ClassLoader latestUserDefinedLoader();

    private Object readNull() throws IOException {
        if (this.bin.readByte() != 112) {
            throw new StreamCorruptedException();
        }
        this.passHandle = -1;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object readObject() throws IOException, ClassNotFoundException {
        if (this.enableOverride) {
            return this.readObjectOverride();
        }
        int n2 = this.passHandle;
        try {
            Object object = this.readObject0(false);
            this.handles.markDependency(n2, this.passHandle);
            ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
            if (classNotFoundException != null) {
                throw classNotFoundException;
            }
            if (this.depth == 0) {
                this.vlist.doCallbacks();
            }
            Object object2 = object;
            Object var6_5 = null;
            this.passHandle = n2;
            if (this.closed && this.depth == 0) {
                this.clear();
            }
            return object2;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                this.passHandle = n2;
                if (!this.closed || this.depth != 0) break block6;
                this.clear();
            }
            throw throwable;
        }
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readUnshared() throws IOException, ClassNotFoundException {
        int n2 = this.passHandle;
        try {
            Object object = this.readObject0(true);
            this.handles.markDependency(n2, this.passHandle);
            ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
            if (classNotFoundException != null) {
                throw classNotFoundException;
            }
            if (this.depth == 0) {
                this.vlist.doCallbacks();
            }
            Object object2 = object;
            Object var6_5 = null;
            this.passHandle = n2;
            if (this.closed && this.depth == 0) {
                this.clear();
            }
            return object2;
        }
        catch (Throwable throwable) {
            block5: {
                Object var6_6 = null;
                this.passHandle = n2;
                if (!this.closed || this.depth != 0) break block5;
                this.clear();
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readArray(boolean bl2) throws IOException {
        if (this.bin.readByte() != 117) {
            throw new StreamCorruptedException();
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        int n2 = this.bin.readInt();
        Object object = null;
        Class clazz = null;
        Class clazz2 = objectStreamClass.forClass();
        if (clazz2 != null) {
            clazz = clazz2.getComponentType();
            object = Array.newInstance(clazz, n2);
        }
        int n3 = this.handles.assign(bl2 ? unsharedMarker : object);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(n3, classNotFoundException);
        }
        if (clazz == null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.readObject0(false);
            }
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.bin.readInts((int[])object, 0, n2);
            } else if (clazz == Byte.TYPE) {
                this.bin.readFully((byte[])object, 0, n2, true);
            } else if (clazz == Long.TYPE) {
                this.bin.readLongs((long[])object, 0, n2);
            } else if (clazz == Float.TYPE) {
                this.bin.readFloats((float[])object, 0, n2);
            } else if (clazz == Double.TYPE) {
                this.bin.readDoubles((double[])object, 0, n2);
            } else if (clazz == Short.TYPE) {
                this.bin.readShorts((short[])object, 0, n2);
            } else if (clazz == Character.TYPE) {
                this.bin.readChars((char[])object, 0, n2);
            } else {
                if (clazz != Boolean.TYPE) throw new InternalError();
                this.bin.readBooleans((boolean[])object, 0, n2);
            }
        } else {
            Object[] objectArray = (Object[])object;
            for (int i3 = 0; i3 < n2; ++i3) {
                objectArray[i3] = this.readObject0(false);
                this.handles.markDependency(n3, this.passHandle);
            }
        }
        this.handles.finish(n3);
        this.passHandle = n3;
        return object;
    }

    private Object readHandle(boolean bl2) throws IOException {
        if (this.bin.readByte() != 113) {
            throw new StreamCorruptedException();
        }
        this.passHandle = this.bin.readInt() - 0x7E0000;
        if (this.passHandle < 0 || this.passHandle >= this.handles.size()) {
            throw new StreamCorruptedException("illegal handle value");
        }
        if (bl2) {
            throw new InvalidObjectException("cannot read back reference as unshared");
        }
        Object object = this.handles.lookupObject(this.passHandle);
        if (object == unsharedMarker) {
            throw new InvalidObjectException("cannot read back reference to unshared object");
        }
        return object;
    }

    private Object readObject0(boolean bl2) throws IOException {
        int n2;
        boolean bl3 = this.bin.getBlockDataMode();
        if (bl3) {
            n2 = this.bin.currentBlockRemaining();
            if (n2 > 0) {
                throw new OptionalDataException(n2);
            }
            if (this.defaultDataEnd) {
                throw new OptionalDataException(true);
            }
            this.bin.setBlockDataMode(false);
        }
        while (true) {
            byte by = this.bin.peekByte();
            n2 = by;
            if (by != 121) break;
            this.bin.readByte();
            this.handleReset();
        }
        ++this.depth;
        try {
            switch (n2) {
                case 112: {
                    Object object = this.readNull();
                    return object;
                }
                case 113: {
                    Object object = this.readHandle(bl2);
                    return object;
                }
                case 118: {
                    Class clazz = this.readClass(bl2);
                    return clazz;
                }
                case 114: 
                case 125: {
                    ObjectStreamClass objectStreamClass = this.readClassDesc(bl2);
                    return objectStreamClass;
                }
                case 116: 
                case 124: {
                    Object object = this.checkResolve(this.readString(bl2));
                    return object;
                }
                case 117: {
                    Object object = this.checkResolve(this.readArray(bl2));
                    return object;
                }
                case 115: {
                    Object object = this.checkResolve(this.readOrdinaryObject(bl2));
                    return object;
                }
                case 123: {
                    IOException iOException = this.readFatalException();
                    throw new WriteAbortedException("writing aborted", iOException);
                }
                case 119: 
                case 122: {
                    if (bl3) {
                        this.bin.setBlockDataMode(true);
                        this.bin.peek();
                        throw new OptionalDataException(this.bin.currentBlockRemaining());
                    }
                    throw new StreamCorruptedException("unexpected block data");
                }
                case 120: {
                    if (bl3) {
                        throw new OptionalDataException(true);
                    }
                    throw new StreamCorruptedException("unexpected end of block data");
                }
            }
            throw new StreamCorruptedException();
        }
        finally {
            --this.depth;
            this.bin.setBlockDataMode(bl3);
        }
    }

    private Object readOrdinaryObject(boolean bl2) throws IOException {
        Object object;
        Object object2;
        if (this.bin.readByte() != 115) {
            throw new StreamCorruptedException();
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        objectStreamClass.checkDeserialize();
        try {
            object2 = objectStreamClass.isInstantiable() ? objectStreamClass.newInstance() : null;
        }
        catch (Exception exception) {
            throw new InvalidClassException(objectStreamClass.forClass().getName(), "unable to create instance");
        }
        this.passHandle = this.handles.assign(bl2 ? unsharedMarker : object2);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(this.passHandle, classNotFoundException);
        }
        if (objectStreamClass.isExternalizable()) {
            this.readExternalData((Externalizable)object2, objectStreamClass);
        } else {
            this.readSerialData(object2, objectStreamClass);
        }
        this.handles.finish(this.passHandle);
        if (object2 != null && this.handles.lookupException(this.passHandle) == null && objectStreamClass.hasReadResolveMethod() && (object = objectStreamClass.invokeReadResolve(object2)) != object2) {
            object2 = object;
            this.handles.setObject(this.passHandle, object2);
        }
        return object2;
    }

    public String readLine() throws IOException {
        return this.bin.readLine();
    }

    String readTypeString() throws IOException {
        int n2 = this.passHandle;
        try {
            switch (this.bin.peekByte()) {
                case 112: {
                    String string = (String)this.readNull();
                    return string;
                }
                case 113: {
                    String string = (String)this.readHandle(false);
                    return string;
                }
                case 116: 
                case 124: {
                    String string = this.readString(false);
                    return string;
                }
            }
            throw new StreamCorruptedException();
        }
        finally {
            this.passHandle = n2;
        }
    }

    public String readUTF() throws IOException {
        return this.bin.readUTF();
    }

    private String readString(boolean bl2) throws IOException {
        String string;
        switch (this.bin.readByte()) {
            case 116: {
                string = this.bin.readUTF();
                break;
            }
            case 124: {
                string = this.bin.readLongUTF();
                break;
            }
            default: {
                throw new StreamCorruptedException();
            }
        }
        this.passHandle = this.handles.assign(bl2 ? unsharedMarker : string);
        this.handles.finish(this.passHandle);
        return string;
    }

    private void readExternalData(Externalizable externalizable, ObjectStreamClass objectStreamClass) throws IOException {
        Object object = this.curObj;
        ObjectStreamClass objectStreamClass2 = this.curDesc;
        GetFieldImpl getFieldImpl = this.curGet;
        this.curObj = externalizable;
        this.curDesc = null;
        this.curGet = null;
        boolean bl2 = objectStreamClass.hasBlockExternalData();
        if (bl2) {
            this.bin.setBlockDataMode(true);
        }
        if (externalizable != null) {
            try {
                externalizable.readExternal(this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.handles.markException(this.passHandle, classNotFoundException);
            }
        }
        if (bl2) {
            this.skipCustomData();
        }
        this.curObj = object;
        this.curDesc = objectStreamClass2;
        this.curGet = getFieldImpl;
    }

    private void defaultReadFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Class clazz = objectStreamClass.forClass();
        if (clazz != null && object != null && !clazz.isInstance(object)) {
            throw new ClassCastException();
        }
        int n2 = objectStreamClass.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < n2) {
            this.primVals = new byte[n2];
        }
        this.bin.readFully(this.primVals, 0, n2, false);
        if (object != null) {
            objectStreamClass.setPrimFieldValues(object, this.primVals);
        }
        int n3 = this.passHandle;
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields(false);
        Object[] objectArray = new Object[objectStreamClass.getNumObjFields()];
        int n4 = objectStreamFieldArray.length - objectArray.length;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[n4 + i2];
            objectArray[i2] = this.readObject0(objectStreamField.isUnshared());
            if (objectStreamField.getField() == null) continue;
            this.handles.markDependency(n3, this.passHandle);
        }
        if (object != null) {
            objectStreamClass.setObjFieldValues(object, objectArray);
        }
        this.passHandle = n3;
    }

    private void readSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        for (int i2 = 0; i2 < classDataSlotArray.length; ++i2) {
            ObjectStreamClass objectStreamClass2 = classDataSlotArray[i2].desc;
            if (classDataSlotArray[i2].hasData) {
                if (object != null && objectStreamClass2.hasReadObjectMethod() && this.handles.lookupException(this.passHandle) == null) {
                    Object object2 = this.curObj;
                    ObjectStreamClass objectStreamClass3 = this.curDesc;
                    GetFieldImpl getFieldImpl = this.curGet;
                    this.curObj = object;
                    this.curDesc = objectStreamClass2;
                    this.curGet = null;
                    this.bin.setBlockDataMode(true);
                    try {
                        objectStreamClass2.invokeReadObject(object, this);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.handles.markException(this.passHandle, classNotFoundException);
                    }
                    this.curObj = object2;
                    this.curDesc = objectStreamClass3;
                    this.curGet = getFieldImpl;
                    this.defaultDataEnd = false;
                } else {
                    this.defaultReadFields(object, objectStreamClass2);
                }
                if (objectStreamClass2.hasWriteObjectData()) {
                    this.skipCustomData();
                    continue;
                }
                this.bin.setBlockDataMode(false);
                continue;
            }
            if (object == null || !objectStreamClass2.hasReadObjectNoDataMethod() || this.handles.lookupException(this.passHandle) != null) continue;
            objectStreamClass2.invokeReadObjectNoData(object);
        }
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        try {
            return Class.forName(string, false, ObjectInputStream.latestUserDefinedLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz = (Class)primClasses.get(string);
            if (clazz != null) {
                return clazz;
            }
            throw classNotFoundException;
        }
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = ObjectInputStream.latestUserDefinedLoader();
        ClassLoader classLoader2 = null;
        boolean bl2 = false;
        Class[] classArray = new Class[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Class clazz = Class.forName(stringArray[i2], false, classLoader);
            if ((clazz.getModifiers() & 1) == 0) {
                if (bl2) {
                    if (classLoader2 != clazz.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    classLoader2 = clazz.getClassLoader();
                    bl2 = true;
                }
            }
            classArray[i2] = clazz;
        }
        try {
            return Proxy.getProxyClass(bl2 ? classLoader2 : classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    private Object checkResolve(Object object) throws IOException {
        if (!this.enableResolve || this.handles.lookupException(this.passHandle) != null) {
            return object;
        }
        Object object2 = this.resolveObject(object);
        if (object2 != object) {
            this.handles.setObject(this.passHandle, object2);
        }
        return object2;
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    private class BlockDataInputStream
    extends InputStream
    implements DataInput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private static final int HEADER_BLOCKED = -2;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private int end = -1;
        private int unread = 0;
        private final PeekInputStream in;
        private final DataInputStream din;

        byte peekByte() throws IOException {
            int n2 = this.peek();
            if (n2 < 0) {
                throw new EOFException();
            }
            return (byte)n2;
        }

        public byte readByte() throws IOException {
            int n2 = this.read();
            if (n2 < 0) {
                throw new EOFException();
            }
            return (byte)n2;
        }

        public char readChar() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readChar();
            }
            char c2 = Bits.getChar(this.buf, this.pos);
            this.pos += 2;
            return c2;
        }

        public double readDouble() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readDouble();
            }
            double d2 = Bits.getDouble(this.buf, this.pos);
            this.pos += 8;
            return d2;
        }

        public float readFloat() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readFloat();
            }
            float f2 = Bits.getFloat(this.buf, this.pos);
            this.pos += 4;
            return f2;
        }

        public int available() throws IOException {
            if (this.blkmode) {
                int n2;
                if (this.pos == this.end && this.unread == 0) {
                    while ((n2 = this.readBlockHeader(false)) == 0) {
                    }
                    switch (n2) {
                        case -2: {
                            break;
                        }
                        case -1: {
                            this.pos = 0;
                            this.end = -1;
                            break;
                        }
                        default: {
                            this.pos = 0;
                            this.end = 0;
                            this.unread = n2;
                        }
                    }
                }
                n2 = this.unread > 0 ? Math.min(this.in.available(), this.unread) : 0;
                return this.end >= 0 ? this.end - this.pos + n2 : 0;
            }
            return this.in.available();
        }

        int currentBlockRemaining() {
            if (this.blkmode) {
                return this.end >= 0 ? this.end - this.pos + this.unread : 0;
            }
            throw new IllegalStateException();
        }

        int peek() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos] & 0xFF : -1;
            }
            return this.in.peek();
        }

        public int read() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos++] & 0xFF : -1;
            }
            return this.in.read();
        }

        public int readInt() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readInt();
            }
            int n2 = Bits.getInt(this.buf, this.pos);
            this.pos += 4;
            return n2;
        }

        public int readUnsignedByte() throws IOException {
            int n2 = this.read();
            if (n2 < 0) {
                throw new EOFException();
            }
            return n2;
        }

        public int readUnsignedShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readUnsignedShort();
            }
            int n2 = Bits.getShort(this.buf, this.pos) & 0xFFFF;
            this.pos += 2;
            return n2;
        }

        public long readLong() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readLong();
            }
            long l2 = Bits.getLong(this.buf, this.pos);
            this.pos += 8;
            return l2;
        }

        public short readShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readShort();
            }
            short s2 = Bits.getShort(this.buf, this.pos);
            this.pos += 2;
            return s2;
        }

        public void close() throws IOException {
            if (this.blkmode) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
            }
            this.in.close();
        }

        private void refill() throws IOException {
            try {
                do {
                    int n2;
                    this.pos = 0;
                    if (this.unread > 0) {
                        n2 = this.in.read(this.buf, 0, Math.min(this.unread, 1024));
                        if (n2 >= 0) {
                            this.end = n2;
                            this.unread -= n2;
                            continue;
                        }
                        throw new StreamCorruptedException("unexpected EOF in middle of data block");
                    }
                    n2 = this.readBlockHeader(true);
                    if (n2 >= 0) {
                        this.end = 0;
                        this.unread = n2;
                        continue;
                    }
                    this.end = -1;
                    this.unread = 0;
                } while (this.pos == this.end);
            }
            catch (IOException iOException) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
                throw iOException;
            }
        }

        void skipBlockData() throws IOException {
            if (!this.blkmode) {
                throw new IllegalStateException("not in block data mode");
            }
            while (this.end >= 0) {
                this.refill();
            }
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        public boolean readBoolean() throws IOException {
            int n2 = this.read();
            if (n2 < 0) {
                throw new EOFException();
            }
            return n2 != 0;
        }

        public int skipBytes(int n2) throws IOException {
            return this.din.skipBytes(n2);
        }

        public long skip(long l2) throws IOException {
            long l3 = l2;
            while (l3 > 0L) {
                int n2;
                if (this.blkmode) {
                    if (this.pos == this.end) {
                        this.refill();
                    }
                    if (this.end < 0) break;
                    n2 = (int)Math.min(l3, (long)(this.end - this.pos));
                    l3 -= (long)n2;
                    this.pos += n2;
                    continue;
                }
                n2 = (int)Math.min(l3, 1024L);
                if ((n2 = this.in.read(this.buf, 0, n2)) < 0) break;
                l3 -= (long)n2;
            }
            return l2 - l3;
        }

        private int readBlockHeader(boolean bl2) throws IOException {
            if (ObjectInputStream.this.defaultDataEnd) {
                return -1;
            }
            try {
                int n2;
                block7: while (true) {
                    int n3;
                    int n4 = n3 = bl2 ? Integer.MAX_VALUE : this.in.available();
                    if (n3 == 0) {
                        return -2;
                    }
                    n2 = this.in.peek();
                    switch (n2) {
                        case 119: {
                            if (n3 < 2) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 2);
                            return this.hbuf[1] & 0xFF;
                        }
                        case 122: {
                            if (n3 < 5) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 5);
                            int n5 = Bits.getInt(this.hbuf, 1);
                            if (n5 < 0) {
                                throw new StreamCorruptedException("illegal block data header length");
                            }
                            return n5;
                        }
                        case 121: {
                            this.in.read();
                            ObjectInputStream.this.handleReset();
                            continue block7;
                        }
                    }
                    break;
                }
                if (n2 >= 0 && (n2 < 112 || n2 > 125)) {
                    throw new StreamCorruptedException();
                }
                return -1;
            }
            catch (EOFException eOFException) {
                throw new StreamCorruptedException("unexpected EOF while reading block data header");
            }
        }

        boolean setBlockDataMode(boolean bl2) throws IOException {
            if (this.blkmode == bl2) {
                return this.blkmode;
            }
            if (bl2) {
                this.pos = 0;
                this.end = 0;
                this.unread = 0;
            } else if (this.pos < this.end) {
                throw new IllegalStateException("unread block data");
            }
            this.blkmode = bl2;
            return !this.blkmode;
        }

        public void readFully(byte[] byArray) throws IOException {
            this.readFully(byArray, 0, byArray.length, false);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.read(byArray, n2, n3, false);
        }

        public void readFully(byte[] byArray, int n2, int n3) throws IOException {
            this.readFully(byArray, n2, n3, false);
        }

        int read(byte[] byArray, int n2, int n3, boolean bl2) throws IOException {
            if (n3 == 0) {
                return 0;
            }
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                if (this.end < 0) {
                    return -1;
                }
                int n4 = Math.min(n3, this.end - this.pos);
                System.arraycopy(this.buf, this.pos, byArray, n2, n4);
                this.pos += n4;
                return n4;
            }
            if (bl2) {
                int n5 = this.in.read(this.buf, 0, Math.min(n3, 1024));
                if (n5 > 0) {
                    System.arraycopy(this.buf, 0, byArray, n2, n5);
                }
                return n5;
            }
            return this.in.read(byArray, n2, n3);
        }

        public void readFully(byte[] byArray, int n2, int n3, boolean bl2) throws IOException {
            while (n3 > 0) {
                int n4 = this.read(byArray, n2, n3, bl2);
                if (n4 < 0) {
                    throw new EOFException();
                }
                n2 += n4;
                n3 -= n4;
            }
        }

        void readChars(char[] cArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 512);
                    this.in.readFully(this.buf, 0, n6 << 1);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        cArray[n2++] = this.din.readChar();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + (this.end - this.pos >> 1));
                }
                while (n2 < n5) {
                    cArray[n2++] = Bits.getChar(this.buf, this.pos);
                    this.pos += 2;
                }
            }
        }

        void readDoubles(double[] dArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    n5 = Math.min(n4 - n2, 128);
                    this.in.readFully(this.buf, 0, n5 << 3);
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        dArray[n2++] = this.din.readDouble();
                        continue;
                    }
                    n5 = Math.min(n4 - n2, this.end - this.pos >> 3);
                }
                ObjectInputStream.bytesToDoubles(this.buf, this.pos, dArray, n2, n5);
                n2 += n5;
                this.pos += n5 << 3;
            }
        }

        void readFloats(float[] fArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    n5 = Math.min(n4 - n2, 256);
                    this.in.readFully(this.buf, 0, n5 << 2);
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        fArray[n2++] = this.din.readFloat();
                        continue;
                    }
                    n5 = Math.min(n4 - n2, this.end - this.pos >> 2);
                }
                ObjectInputStream.bytesToFloats(this.buf, this.pos, fArray, n2, n5);
                n2 += n5;
                this.pos += n5 << 2;
            }
        }

        void readInts(int[] nArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 256);
                    this.in.readFully(this.buf, 0, n6 << 2);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        nArray[n2++] = this.din.readInt();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + (this.end - this.pos >> 2));
                }
                while (n2 < n5) {
                    nArray[n2++] = Bits.getInt(this.buf, this.pos);
                    this.pos += 4;
                }
            }
        }

        void readLongs(long[] lArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 128);
                    this.in.readFully(this.buf, 0, n6 << 3);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        lArray[n2++] = this.din.readLong();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + (this.end - this.pos >> 3));
                }
                while (n2 < n5) {
                    lArray[n2++] = Bits.getLong(this.buf, this.pos);
                    this.pos += 8;
                }
            }
        }

        void readShorts(short[] sArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 512);
                    this.in.readFully(this.buf, 0, n6 << 1);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        sArray[n2++] = this.din.readShort();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + (this.end - this.pos >> 1));
                }
                while (n2 < n5) {
                    sArray[n2++] = Bits.getShort(this.buf, this.pos);
                    this.pos += 2;
                }
            }
        }

        void readBooleans(boolean[] blArray, int n2, int n3) throws IOException {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5;
                if (!this.blkmode) {
                    int n6 = Math.min(n4 - n2, 1024);
                    this.in.readFully(this.buf, 0, n6);
                    n5 = n2 + n6;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 1) {
                        blArray[n2++] = this.din.readBoolean();
                        continue;
                    }
                    n5 = Math.min(n4, n2 + this.end - this.pos);
                }
                while (n2 < n5) {
                    blArray[n2++] = Bits.getBoolean(this.buf, this.pos++);
                }
            }
        }

        public String readLine() throws IOException {
            return this.din.readLine();
        }

        String readLongUTF() throws IOException {
            return this.readUTFBody(this.readLong());
        }

        public String readUTF() throws IOException {
            return this.readUTFBody(this.readUnsignedShort());
        }

        private String readUTFBody(long l2) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.blkmode) {
                this.pos = 0;
                this.end = 0;
            }
            while (l2 > 0L) {
                int n2 = this.end - this.pos;
                if (n2 >= 3 || (long)n2 == l2) {
                    l2 -= this.readUTFSpan(stringBuffer, l2);
                    continue;
                }
                if (this.blkmode) {
                    l2 -= (long)this.readUTFChar(stringBuffer, l2);
                    continue;
                }
                if (n2 > 0) {
                    System.arraycopy(this.buf, this.pos, this.buf, 0, n2);
                }
                this.pos = 0;
                this.end = (int)Math.min(1024L, l2);
                this.in.readFully(this.buf, n2, this.end - n2);
            }
            return stringBuffer.toString();
        }

        private int readUTFChar(StringBuffer stringBuffer, long l2) throws IOException {
            int n2 = this.readByte() & 0xFF;
            switch (n2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    stringBuffer.append((char)n2);
                    return 1;
                }
                case 12: 
                case 13: {
                    if (l2 < 2L) {
                        throw new UTFDataFormatException();
                    }
                    byte by = this.readByte();
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n2 & 0x1F) << 6 | (by & 0x3F) << 0));
                    return 2;
                }
                case 14: {
                    if (l2 < 3L) {
                        if (l2 == 2L) {
                            this.readByte();
                        }
                        throw new UTFDataFormatException();
                    }
                    byte by = this.readByte();
                    byte by2 = this.readByte();
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n2 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    return 3;
                }
            }
            throw new UTFDataFormatException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long readUTFSpan(StringBuffer stringBuffer, long l2) throws IOException {
            int n2;
            int n3;
            block16: {
                n3 = 0;
                n2 = this.pos;
                int n4 = Math.min(this.end - this.pos, 256);
                int n5 = this.pos + (l2 > (long)n4 ? n4 - 2 : (int)l2);
                boolean bl2 = false;
                try {
                    try {}
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl2 = true;
                        Object var13_13 = null;
                        if (bl2 || (long)(this.pos - n2) > l2) {
                            this.pos = n2 + (int)l2;
                            throw new UTFDataFormatException();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (!bl2 && (long)(this.pos - n2) <= l2) {
                        throw throwable;
                    }
                    this.pos = n2 + (int)l2;
                    throw new UTFDataFormatException();
                }
                block9: while (this.pos < n5) {
                    int n6 = this.buf[this.pos++] & 0xFF;
                    switch (n6 >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            this.cbuf[n3++] = (char)n6;
                            continue block9;
                        }
                        case 12: 
                        case 13: {
                            byte by2 = this.buf[this.pos++];
                            if ((by2 & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.cbuf[n3++] = (char)((n6 & 0x1F) << 6 | (by2 & 0x3F) << 0);
                            continue block9;
                        }
                        case 14: {
                            byte by = this.buf[this.pos + 1];
                            byte by2 = this.buf[this.pos + 0];
                            this.pos += 2;
                            if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.cbuf[n3++] = (char)((n6 & 0xF) << 12 | (by2 & 0x3F) << 6 | (by & 0x3F) << 0);
                            continue block9;
                        }
                    }
                    throw new UTFDataFormatException();
                }
                Object var13_12 = null;
                if (bl2 || (long)(this.pos - n2) > l2) {
                    this.pos = n2 + (int)l2;
                    throw new UTFDataFormatException();
                }
            }
            stringBuffer.append(this.cbuf, 0, n3);
            return this.pos - n2;
        }

        BlockDataInputStream(InputStream inputStream) {
            this.in = new PeekInputStream(inputStream);
            this.din = new DataInputStream(this);
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException;

        public abstract byte get(String var1, byte var2) throws IOException;

        public abstract char get(String var1, char var2) throws IOException;

        public abstract double get(String var1, double var2) throws IOException;

        public abstract float get(String var1, float var2) throws IOException;

        public abstract int get(String var1, int var2) throws IOException;

        public abstract long get(String var1, long var2) throws IOException;

        public abstract short get(String var1, short var2) throws IOException;

        public abstract boolean get(String var1, boolean var2) throws IOException;

        public abstract Object get(String var1, Object var2) throws IOException;
    }

    private class GetFieldImpl
    extends GetField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;
        private final int[] objHandles;

        void readFields() throws IOException {
            ObjectInputStream.this.bin.readFully(this.primVals, 0, this.primVals.length, false);
            int n2 = ObjectInputStream.this.passHandle;
            ObjectStreamField[] objectStreamFieldArray = this.desc.getFields(false);
            int n3 = objectStreamFieldArray.length - this.objVals.length;
            for (int i2 = 0; i2 < this.objVals.length; ++i2) {
                this.objVals[i2] = ObjectInputStream.this.readObject0(objectStreamFieldArray[n3 + i2].isUnshared());
                this.objHandles[i2] = ObjectInputStream.this.passHandle;
            }
            ObjectInputStream.this.passHandle = n2;
        }

        public ObjectStreamClass getObjectStreamClass() {
            return this.desc;
        }

        public boolean defaulted(String string) throws IOException {
            return this.getFieldOffset(string, null) < 0;
        }

        public byte get(String string, byte by) throws IOException {
            int n2 = this.getFieldOffset(string, Byte.TYPE);
            return n2 >= 0 ? this.primVals[n2] : by;
        }

        public char get(String string, char c2) throws IOException {
            int n2 = this.getFieldOffset(string, Character.TYPE);
            return n2 >= 0 ? Bits.getChar(this.primVals, n2) : c2;
        }

        public double get(String string, double d2) throws IOException {
            int n2 = this.getFieldOffset(string, Double.TYPE);
            return n2 >= 0 ? Bits.getDouble(this.primVals, n2) : d2;
        }

        public float get(String string, float f2) throws IOException {
            int n2 = this.getFieldOffset(string, Float.TYPE);
            return n2 >= 0 ? Bits.getFloat(this.primVals, n2) : f2;
        }

        public int get(String string, int n2) throws IOException {
            int n3 = this.getFieldOffset(string, Integer.TYPE);
            return n3 >= 0 ? Bits.getInt(this.primVals, n3) : n2;
        }

        public long get(String string, long l2) throws IOException {
            int n2 = this.getFieldOffset(string, Long.TYPE);
            return n2 >= 0 ? Bits.getLong(this.primVals, n2) : l2;
        }

        public short get(String string, short s2) throws IOException {
            int n2 = this.getFieldOffset(string, Short.TYPE);
            return n2 >= 0 ? Bits.getShort(this.primVals, n2) : s2;
        }

        public boolean get(String string, boolean bl2) throws IOException {
            int n2 = this.getFieldOffset(string, Boolean.TYPE);
            return n2 >= 0 ? Bits.getBoolean(this.primVals, n2) : bl2;
        }

        GetFieldImpl(ObjectStreamClass objectStreamClass) {
            this.desc = objectStreamClass;
            this.primVals = new byte[objectStreamClass.getPrimDataSize()];
            this.objVals = new Object[objectStreamClass.getNumObjFields()];
            this.objHandles = new int[this.objVals.length];
        }

        private int getFieldOffset(String string, Class clazz) {
            ObjectStreamField objectStreamField = this.desc.getField(string, clazz);
            if (objectStreamField != null) {
                return objectStreamField.getOffset();
            }
            if (this.desc.getLocalDesc().getField(string, clazz) != null) {
                return -1;
            }
            throw new IllegalArgumentException("no such field");
        }

        public Object get(String string, Object object) throws IOException {
            int n2 = this.getFieldOffset(string, class$java$lang$Object == null ? (class$java$lang$Object = ObjectInputStream.class$("java.lang.Object")) : class$java$lang$Object);
            if (n2 >= 0) {
                int n3 = this.objHandles[n2];
                ObjectInputStream.this.handles.markDependency(ObjectInputStream.this.passHandle, n3);
                return ObjectInputStream.this.handles.lookupException(n3) == null ? this.objVals[n2] : null;
            }
            return object;
        }
    }

    private static class HandleTable {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep = -1;
        int size = 0;

        int size() {
            return this.size;
        }

        void clear() {
            Arrays.fill(this.status, 0, this.size, (byte)0);
            Arrays.fill(this.entries, 0, this.size, null);
            Arrays.fill(this.deps, 0, this.size, null);
            this.lowDep = -1;
            this.size = 0;
        }

        private void grow() {
            int n2 = (this.entries.length << 1) + 1;
            byte[] byArray = new byte[n2];
            Object[] objectArray = new Object[n2];
            HandleList[] handleListArray = new HandleList[n2];
            System.arraycopy(this.status, 0, byArray, 0, this.size);
            System.arraycopy(this.entries, 0, objectArray, 0, this.size);
            System.arraycopy(this.deps, 0, handleListArray, 0, this.size);
            this.status = byArray;
            this.entries = objectArray;
            this.deps = handleListArray;
        }

        HandleTable(int n2) {
            this.status = new byte[n2];
            this.entries = new Object[n2];
            this.deps = new HandleList[n2];
        }

        void finish(int n2) {
            int n3;
            if (this.lowDep < 0) {
                n3 = n2 + 1;
            } else if (this.lowDep >= n2) {
                n3 = this.size;
                this.lowDep = -1;
            } else {
                return;
            }
            block4: for (int i2 = n2; i2 < n3; ++i2) {
                switch (this.status[i2]) {
                    case 2: {
                        this.status[i2] = 1;
                        this.deps[i2] = null;
                        continue block4;
                    }
                    case 1: 
                    case 3: {
                        continue block4;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void markDependency(int n2, int n3) {
            if (n2 == -1 || n3 == -1) {
                return;
            }
            block0 : switch (this.status[n2]) {
                case 2: {
                    switch (this.status[n3]) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            this.markException(n2, (ClassNotFoundException)this.entries[n3]);
                            break block0;
                        }
                        case 2: {
                            if (this.deps[n3] == null) {
                                this.deps[n3] = new HandleList();
                            }
                            this.deps[n3].add(n2);
                            if (this.lowDep >= 0 && this.lowDep <= n3) break block0;
                            this.lowDep = n3;
                            break block0;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        ClassNotFoundException lookupException(int n2) {
            return n2 != -1 && this.status[n2] == 3 ? (ClassNotFoundException)this.entries[n2] : null;
        }

        void markException(int n2, ClassNotFoundException classNotFoundException) {
            switch (this.status[n2]) {
                case 2: {
                    this.status[n2] = 3;
                    this.entries[n2] = classNotFoundException;
                    HandleList handleList = this.deps[n2];
                    if (handleList == null) break;
                    int n3 = handleList.size();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        this.markException(handleList.get(i2), classNotFoundException);
                    }
                    this.deps[n2] = null;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        Object lookupObject(int n2) {
            return n2 != -1 && this.status[n2] != 3 ? this.entries[n2] : null;
        }

        void setObject(int n2, Object object) {
            switch (this.status[n2]) {
                case 1: 
                case 2: {
                    this.entries[n2] = object;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        int assign(Object object) {
            if (this.size >= this.entries.length) {
                this.grow();
            }
            this.status[this.size] = 2;
            this.entries[this.size] = object;
            return this.size++;
        }

        private static class HandleList {
            private int[] list = new int[4];
            private int size = 0;

            public int size() {
                return this.size;
            }

            public int get(int n2) {
                if (n2 >= this.size) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.list[n2];
            }

            public void add(int n2) {
                if (this.size >= this.list.length) {
                    int[] nArray = new int[this.list.length << 1];
                    System.arraycopy(this.list, 0, nArray, 0, this.list.length);
                    this.list = nArray;
                }
                this.list[this.size++] = n2;
            }
        }
    }

    private static class PeekInputStream
    extends InputStream {
        private final InputStream in;
        private int peekb = -1;

        public int available() throws IOException {
            return this.in.available() + (this.peekb >= 0 ? 1 : 0);
        }

        int peek() throws IOException {
            return this.peekb >= 0 ? this.peekb : (this.peekb = this.in.read());
        }

        public int read() throws IOException {
            if (this.peekb >= 0) {
                int n2 = this.peekb;
                this.peekb = -1;
                return n2;
            }
            return this.in.read();
        }

        public void close() throws IOException {
            this.in.close();
        }

        public long skip(long l2) throws IOException {
            if (l2 <= 0L) {
                return 0L;
            }
            int n2 = 0;
            if (this.peekb >= 0) {
                this.peekb = -1;
                ++n2;
                --l2;
            }
            return (long)n2 + this.skip(l2);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            if (n3 == 0) {
                return 0;
            }
            if (this.peekb < 0) {
                return this.in.read(byArray, n2, n3);
            }
            byArray[n2++] = (byte)this.peekb;
            this.peekb = -1;
            return (n4 = this.in.read(byArray, n2, --n3)) >= 0 ? n4 + 1 : 1;
        }

        void readFully(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            for (int i2 = 0; i2 < n3; i2 += n4) {
                n4 = this.read(byArray, n2 + i2, n3 - i2);
                if (n4 >= 0) continue;
                throw new EOFException();
            }
        }

        PeekInputStream(InputStream inputStream) {
            this.in = inputStream;
        }
    }

    private static class ValidationList {
        private Callback list;

        ValidationList() {
        }

        public void clear() {
            this.list = null;
        }

        void doCallbacks() throws InvalidObjectException {
            try {
                while (this.list != null) {
                    this.list.obj.validateObject();
                    this.list = this.list.next;
                }
            }
            catch (InvalidObjectException invalidObjectException) {
                this.list = null;
                throw invalidObjectException;
            }
        }

        void register(ObjectInputValidation objectInputValidation, int n2) throws InvalidObjectException {
            if (objectInputValidation == null) {
                throw new InvalidObjectException("null callback");
            }
            Callback callback = null;
            Callback callback2 = this.list;
            while (callback2 != null && n2 < callback2.priority) {
                callback = callback2;
                callback2 = callback2.next;
            }
            if (callback != null) {
                callback.next = new Callback(objectInputValidation, n2, callback2);
            } else {
                this.list = new Callback(objectInputValidation, n2, this.list);
            }
        }

        private static class Callback {
            final ObjectInputValidation obj;
            final int priority;
            Callback next;

            Callback(ObjectInputValidation objectInputValidation, int n2, Callback callback) {
                this.obj = objectInputValidation;
                this.priority = n2;
                this.next = callback;
            }
        }
    }
}

