/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.List;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.util.EventObject;

public abstract class AWTEvent
extends EventObject {
    private byte[] bdata;
    protected int id;
    protected boolean consumed = false;
    transient boolean focusManagerIsDispatching = false;
    public static final long COMPONENT_EVENT_MASK = 1L;
    public static final long CONTAINER_EVENT_MASK = 2L;
    public static final long FOCUS_EVENT_MASK = 4L;
    public static final long KEY_EVENT_MASK = 8L;
    public static final long MOUSE_EVENT_MASK = 16L;
    public static final long MOUSE_MOTION_EVENT_MASK = 32L;
    public static final long WINDOW_EVENT_MASK = 64L;
    public static final long ACTION_EVENT_MASK = 128L;
    public static final long ADJUSTMENT_EVENT_MASK = 256L;
    public static final long ITEM_EVENT_MASK = 512L;
    public static final long TEXT_EVENT_MASK = 1024L;
    public static final long INPUT_METHOD_EVENT_MASK = 2048L;
    static final long INPUT_METHODS_ENABLED_MASK = 4096L;
    public static final long PAINT_EVENT_MASK = 8192L;
    public static final long INVOCATION_EVENT_MASK = 16384L;
    public static final long HIERARCHY_EVENT_MASK = 32768L;
    public static final long HIERARCHY_BOUNDS_EVENT_MASK = 65536L;
    public static final long MOUSE_WHEEL_EVENT_MASK = 131072L;
    public static final long WINDOW_STATE_EVENT_MASK = 262144L;
    public static final long WINDOW_FOCUS_EVENT_MASK = 524288L;
    public static final int RESERVED_ID_MAX = 1999;
    private static final long serialVersionUID = -1825314779160409405L;

    public int getID() {
        return this.id;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            AWTEvent.initIDs();
        }
    }

    protected void consume() {
        switch (this.id) {
            case 401: 
            case 402: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 507: 
            case 1100: 
            case 1101: {
                this.consumed = true;
                break;
            }
        }
    }

    private static native void initIDs();

    protected boolean isConsumed() {
        return this.consumed;
    }

    void copyPrivateDataInto(AWTEvent aWTEvent) {
        aWTEvent.bdata = this.bdata;
    }

    Event convertToOld() {
        Object object = this.getSource();
        int n2 = this.id;
        switch (this.id) {
            case 401: 
            case 402: {
                int n3;
                KeyEvent keyEvent = (KeyEvent)this;
                if (keyEvent.isActionKey()) {
                    int n4 = n2 = this.id == 401 ? 403 : 404;
                }
                if ((n3 = keyEvent.getKeyCode()) == 16 || n3 == 17 || n3 == 18) {
                    return null;
                }
                return new Event(object, keyEvent.getWhen(), n2, 0, 0, Event.getOldEventKey(keyEvent), keyEvent.getModifiers() & 0xFFFFFFEF);
            }
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)this;
                Event event = new Event(object, mouseEvent.getWhen(), n2, mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers() & 0xFFFFFFEF);
                event.clickCount = mouseEvent.getClickCount();
                return event;
            }
            case 1004: {
                return new Event(object, 1004, null);
            }
            case 1005: {
                return new Event(object, 1005, null);
            }
            case 201: 
            case 203: 
            case 204: {
                return new Event(object, n2, null);
            }
            case 100: {
                if (!(object instanceof Frame) && !(object instanceof Dialog)) break;
                Point point = ((Component)object).getLocation();
                return new Event(object, 0L, 205, point.x, point.y, 0, 0);
            }
            case 1001: {
                ActionEvent actionEvent = (ActionEvent)this;
                String string = object instanceof Button ? ((Button)object).getLabel() : (object instanceof MenuItem ? ((MenuItem)object).getLabel() : actionEvent.getActionCommand());
                return new Event(object, 0L, n2, 0, 0, 0, actionEvent.getModifiers(), string);
            }
            case 701: {
                Object object2;
                ItemEvent itemEvent = (ItemEvent)this;
                if (object instanceof List) {
                    n2 = itemEvent.getStateChange() == 1 ? 701 : 702;
                    object2 = itemEvent.getItem();
                } else {
                    n2 = 1001;
                    object2 = object instanceof Choice ? itemEvent.getItem() : new Boolean(itemEvent.getStateChange() == 1);
                }
                return new Event(object, n2, object2);
            }
            case 601: {
                AdjustmentEvent adjustmentEvent = (AdjustmentEvent)this;
                switch (adjustmentEvent.getAdjustmentType()) {
                    case 1: {
                        n2 = 602;
                        break;
                    }
                    case 2: {
                        n2 = 601;
                        break;
                    }
                    case 4: {
                        n2 = 604;
                        break;
                    }
                    case 3: {
                        n2 = 603;
                        break;
                    }
                    case 5: {
                        if (adjustmentEvent.getValueIsAdjusting()) {
                            n2 = 605;
                            break;
                        }
                        n2 = 607;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return new Event(object, n2, new Integer(adjustmentEvent.getValue()));
            }
        }
        return null;
    }

    public AWTEvent(Event event) {
        this(event.target, event.id);
    }

    private native void nativeSetSource(ComponentPeer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(Object object) {
        if (this.source == object) {
            return;
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
            while (component != null && component.peer != null && component.peer instanceof LightweightPeer) {
                component = component.parent;
            }
        }
        AWTEvent aWTEvent = this;
        synchronized (aWTEvent) {
            ComponentPeer componentPeer;
            this.source = object;
            if (component != null && (componentPeer = component.peer) != null) {
                this.nativeSetSource(componentPeer);
            }
        }
    }

    public AWTEvent(Object object, int n2) {
        super(object);
        this.id = n2;
        switch (n2) {
            case 601: 
            case 701: 
            case 900: 
            case 1001: {
                this.consumed = true;
                break;
            }
        }
    }

    public String paramString() {
        return "";
    }

    public String toString() {
        String string = null;
        if (this.source instanceof Component) {
            string = ((Component)this.source).getName();
        } else if (this.source instanceof MenuComponent) {
            string = ((MenuComponent)this.source).getName();
        }
        return this.getClass().getName() + "[" + this.paramString() + "] on " + (string != null ? string : this.source);
    }
}

