/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ViewportUI;

class SynthViewportUI
extends ViewportUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthViewportUI() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.fetchStyle((JComponent)propertyChangeEvent.getSource());
        }
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void fetchStyle(JComponent jComponent) {
        SynthStyle synthStyle;
        SynthContext synthContext = this.getContext(jComponent, 1);
        SynthStyle synthStyle2 = SynthLookAndFeel.getStyle(synthContext.getComponent(), synthContext.getRegion());
        if (synthStyle2 != (synthStyle = synthContext.getStyle())) {
            if (synthStyle != null) {
                synthStyle.uninstallDefaults(synthContext);
            }
            synthContext.setStyle(synthStyle2);
            synthStyle2.installDefaults(synthContext);
        }
        this.style = synthStyle2;
        synthContext.dispose();
    }

    protected void installDefaults(JComponent jComponent) {
        this.fetchStyle(jComponent);
    }

    protected void installListeners(JComponent jComponent) {
        jComponent.addPropertyChangeListener(this);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
    }

    protected void uninstallDefaults(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallListeners(jComponent);
        this.uninstallDefaults(jComponent);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, this.getRegion(jComponent), this.style, n2);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthViewportUI();
    }
}

