/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthEventListener;
import com.sun.java.swing.plaf.gtk.SynthInternalFrameTitlePane;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopIconUI;

class SynthDesktopIconUI
extends DesktopIconUI
implements SynthUI {
    private SynthStyle style;
    protected JInternalFrame.JDesktopIcon desktopIcon;
    protected JInternalFrame frame;
    protected JComponent iconPane;

    public void deiconize() {
        try {
            this.frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void installComponents() {
        this.iconPane = new SynthInternalFrameTitlePane(this.frame);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    protected void installDefaults() {
        this.fetchStyle(this.desktopIcon);
    }

    protected void installListeners() {
        EventHandler eventHandler = this.createEventHandler();
        this.desktopIcon.addMouseMotionListener(eventHandler);
        this.desktopIcon.addMouseListener(eventHandler);
        this.desktopIcon.addPropertyChangeListener(eventHandler);
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconPane);
        this.iconPane = null;
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.desktopIcon, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        EventHandler eventHandler = this.getEventHandler(this.desktopIcon);
        this.desktopIcon.removeMouseMotionListener(eventHandler);
        this.desktopIcon.removeMouseListener(eventHandler);
        this.desktopIcon.removePropertyChangeListener(eventHandler);
    }

    EventHandler createEventHandler() {
        return new EventHandler();
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    public void installUI(JComponent jComponent) {
        this.desktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
        this.frame = this.desktopIcon.getInternalFrame();
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.frame));
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.frame = null;
        this.desktopIcon = null;
    }

    Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        Region region = this.getRegion(jComponent);
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.style, n2);
    }

    private EventHandler getEventHandler(JComponent jComponent) {
        return (EventHandler)SynthLookAndFeel.getSynthEventListener(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.iconPane.getMaximumSize();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = new Dimension(this.iconPane.getMinimumSize());
        Border border = this.frame.getBorder();
        if (border != null) {
            dimension.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.desktopIcon.getLayout().preferredLayoutSize(this.desktopIcon);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public Insets getInsets(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        Border border = jInternalFrame.getBorder();
        if (border != null) {
            return border.getBorderInsets(jInternalFrame);
        }
        return new Insets(0, 0, 0, 0);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthDesktopIconUI();
    }

    private class EventHandler
    extends MouseInputAdapter
    implements PropertyChangeListener,
    SynthEventListener {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;

        private EventHandler() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JDesktopPane jDesktopPane;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            Insets insets = SynthDesktopIconUI.this.desktopIcon.getInsets();
            int n2 = ((JComponent)SynthDesktopIconUI.this.desktopIcon.getParent()).getWidth();
            int n3 = ((JComponent)SynthDesktopIconUI.this.desktopIcon.getParent()).getHeight();
            if (this.startingBounds == null) {
                return;
            }
            int n4 = this.startingBounds.x - (this._x - point.x);
            int n5 = this.startingBounds.y - (this._y - point.y);
            if (n4 + insets.left <= -this.__x) {
                n4 = -this.__x - insets.left;
            }
            if (n5 + insets.top <= -this.__y) {
                n5 = -this.__y - insets.top;
            }
            if (n4 + this.__x + insets.right > n2) {
                n4 = n2 - this.__x - insets.right;
            }
            if (n5 + this.__y + insets.bottom > n3) {
                n5 = n3 - this.__y - insets.bottom;
            }
            if ((jDesktopPane = SynthDesktopIconUI.this.desktopIcon.getDesktopPane()) != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.dragFrame(SynthDesktopIconUI.this.desktopIcon, n4, n5);
            } else {
                this.moveAndRepaint(SynthDesktopIconUI.this.desktopIcon, n4, n5, SynthDesktopIconUI.this.desktopIcon.getWidth(), SynthDesktopIconUI.this.desktopIcon.getHeight());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = SynthDesktopIconUI.this.desktopIcon.getBounds();
            JDesktopPane jDesktopPane = SynthDesktopIconUI.this.desktopIcon.getDesktopPane();
            if (jDesktopPane != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.beginDraggingFrame(SynthDesktopIconUI.this.desktopIcon);
            }
            try {
                SynthDesktopIconUI.this.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (SynthDesktopIconUI.this.desktopIcon.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)SynthDesktopIconUI.this.desktopIcon.getParent()).moveToFront(SynthDesktopIconUI.this.desktopIcon);
            }
            if (mouseEvent.getClickCount() > 1 && SynthDesktopIconUI.this.frame.isIconifiable() && SynthDesktopIconUI.this.frame.isIcon()) {
                SynthDesktopIconUI.this.deiconize();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            JDesktopPane jDesktopPane = SynthDesktopIconUI.this.desktopIcon.getDesktopPane();
            if (jDesktopPane != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.endDraggingFrame(SynthDesktopIconUI.this.desktopIcon);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthDesktopIconUI.this.fetchStyle((JInternalFrame.JDesktopIcon)propertyChangeEvent.getSource());
            }
        }

        public void moveAndRepaint(JComponent jComponent, int n2, int n3, int n4, int n5) {
            Rectangle rectangle = jComponent.getBounds();
            jComponent.setBounds(n2, n3, n4, n5);
            SwingUtilities.computeUnion(n2, n3, n4, n5, rectangle);
            jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

