/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.corba.EncapsOutputStream;
import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.core.ClientGIOP;
import com.sun.corba.se.internal.core.EndPoint;
import com.sun.corba.se.internal.core.IOR;
import com.sun.corba.se.internal.core.RequestHandler;
import com.sun.corba.se.internal.core.ServerGIOP;
import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.ConnectionTable;
import com.sun.corba.se.internal.iiop.EndPointImpl;
import com.sun.corba.se.internal.iiop.ListenerThread;
import com.sun.corba.se.internal.iiop.ORB;
import com.sun.corba.se.internal.ior.IIOPProfile;
import com.sun.corba.se.internal.ior.ObjectId;
import com.sun.corba.se.internal.ior.ObjectKeyTemplate;
import com.sun.corba.se.internal.orbutil.ORBUtility;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;

public class GIOPImpl
implements ClientGIOP,
ServerGIOP {
    private int requestId = 5;
    protected ConnectionTable table;
    protected ORB orb;
    private RequestHandler handler;
    protected HashMap listenerThreads = new HashMap();
    protected Vector endPoints = new Vector();
    private EndPoint bootstrapEndpoint;
    private boolean wasExplicitInitializationDone = false;

    public int allocateRequestId() {
        return this.getNextRequestId();
    }

    protected synchronized int getNextRequestId() {
        return this.requestId++;
    }

    void destroyConnections() {
        Iterator iterator = this.listenerThreads.entrySet().iterator();
        while (iterator.hasNext()) {
            ((ListenerThread)((Map.Entry)iterator.next()).getValue()).shutdown();
        }
        this.table.destroyConnections();
    }

    public synchronized void initEndpoints() {
        if (!this.wasExplicitInitializationDone) {
            if (this.endPoints.size() == 0) {
                this.getEndpoint("IIOP_CLEAR_TEXT", 0, null);
            }
            Iterator iterator = this.orb.getUserSpecifiedListenPorts().iterator();
            while (iterator.hasNext()) {
                ORB.UserSpecifiedListenPort userSpecifiedListenPort = (ORB.UserSpecifiedListenPort)iterator.next();
                this.getEndpoint(userSpecifiedListenPort.getType(), userSpecifiedListenPort.getPort(), null);
            }
            this.wasExplicitInitializationDone = true;
        }
    }

    public synchronized EndPoint getDefaultEndpoint() {
        if (this.endPoints.size() == 0) {
            return null;
        }
        return (EndPoint)this.endPoints.elementAt(0);
    }

    public synchronized EndPoint getBootstrapEndpoint(int n2) {
        if (this.bootstrapEndpoint == null) {
            this.bootstrapEndpoint = this.getEndpoint("IIOP_CLEAR_TEXT", n2, null);
        }
        return this.bootstrapEndpoint;
    }

    public void deleteConnection(EndPoint endPoint) {
        try {
            this.table.deleteConn(endPoint);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RequestHandler getRequestHandler() {
        return this.handler;
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.handler = requestHandler;
    }

    public int getPersistentServerPort(String string) {
        return this.getServerPort(string, true);
    }

    public int getServerPort(String string) {
        return this.getServerPort(string, false);
    }

    private int getServerPort(String string, boolean bl2) {
        if (this.endPoints.size() == 0) {
            throw new INITIALIZE("GIOPImpl.get*ServerPort called before endpoints initialized.", 1398079692, CompletionStatus.COMPLETED_NO);
        }
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            EndPoint endPoint = (EndPoint)iterator.next();
            if (!endPoint.getType().equals(string)) continue;
            if (bl2) {
                return endPoint.getLocatorPort();
            }
            return endPoint.getPort();
        }
        return -1;
    }

    public Collection getServerEndpoints() {
        return this.endPoints;
    }

    public IOR locate(IOR iOR) {
        IIOPProfile iIOPProfile = iOR.getProfile();
        ObjectKeyTemplate objectKeyTemplate = iIOPProfile.getTemplate().getObjectKeyTemplate();
        ObjectId objectId = iIOPProfile.getObjectId();
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.orb);
        objectKeyTemplate.write(objectId, encapsOutputStream);
        byte[] byArray = encapsOutputStream.toByteArray();
        Connection connection = this.table.getConnection(iOR);
        IOR iOR2 = connection.locate(this.getNextRequestId(), byArray, iOR);
        if (iOR2 == null) {
            iOR2 = iOR;
        }
        return iOR2;
    }

    public GIOPImpl(ORB oRB, RequestHandler requestHandler) {
        this.orb = oRB;
        this.table = new ConnectionTable(oRB, this);
        this.setRequestHandler(requestHandler);
    }

    public Connection getConnection(IOR iOR) {
        return this.table.getConnection(iOR);
    }

    private synchronized ListenerThread createListener(final String string, int n2) {
        ListenerThread listenerThread;
        final ConnectionTable connectionTable = this.table;
        if (this.orb.transportDebugFlag) {
            ORBUtility.dprint(this, "createListener( socketType = " + string + " port = " + n2 + " )");
        }
        try {
            final ServerSocket serverSocket = this.orb.getSocketFactory().createServerSocket(string, n2);
            listenerThread = (ListenerThread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ORB cfr_ignored_0 = GIOPImpl.this.orb;
                    ListenerThread listenerThread = new ListenerThread(connectionTable, ORB.threadGroup, serverSocket, string);
                    listenerThread.setDaemon(true);
                    return listenerThread;
                }
            });
            listenerThread.start();
        }
        catch (Exception exception) {
            throw new INTERNAL(1398079697, CompletionStatus.COMPLETED_NO);
        }
        return listenerThread;
    }

    public synchronized EndPoint getEndpoint(String string, int n2, InetAddress inetAddress) {
        Object object;
        if (this.orb.transportDebugFlag) {
            ORBUtility.dprint(this, "getEndpoint(" + string + ", " + n2 + ", " + inetAddress + ")");
        }
        String string2 = null;
        if (inetAddress != null) {
            string2 = inetAddress.getHostName().toLowerCase();
        }
        Enumeration enumeration = this.endPoints.elements();
        while (enumeration.hasMoreElements()) {
            object = (EndPoint)enumeration.nextElement();
            if (!object.getType().equals(string) || object.getPort() != n2 || !object.getHostName().equals(string2)) continue;
            return object;
        }
        if (string == "IIOP_CLEAR_TEXT" && n2 == 0 && this.orb.getORBServerPort() != 0) {
            n2 = this.orb.getORBServerPort();
        }
        object = this.createListener(string, n2);
        this.listenerThreads.put(string, object);
        EndPointImpl endPointImpl = new EndPointImpl(string, ((ListenerThread)object).getSocket().getLocalPort(), this.orb.getORBServerHost());
        this.endPoints.addElement(endPointImpl);
        return endPointImpl;
    }
}

