/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.Activation;

import [Ljava.lang.String;;
import com.sun.corba.se.ActivationIDL.Activator;
import com.sun.corba.se.ActivationIDL.ActivatorHelper;
import com.sun.corba.se.internal.Activation.ServerCallback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Properties;
import org.omg.CORBA.ORB;

public class ServerMain {
    public static final int OK = 0;
    public static final int MAIN_CLASS_NOT_FOUND = 1;
    public static final int NO_MAIN_METHOD = 2;
    public static final int APPLICATION_ERROR = 3;
    public static final int UNKNOWN_ERROR = 4;
    public static final int NO_SERVER_ID = 5;
    public static final int REGISTRATION_FAILED = 6;
    private static final boolean debug = false;

    private int getServerId() {
        Integer n2 = Integer.getInteger("com.sun.CORBA.POA.ORBServerId");
        if (n2 == null) {
            ServerMain.logTerminal("", 5);
        }
        return n2;
    }

    private void redirectIOStreams() {
        try {
            String string = System.getProperty("com.sun.CORBA.activation.DbDir") + System.getProperty("file.separator") + "logs" + System.getProperty("file.separator");
            File file = new File(string);
            String string2 = System.getProperty("com.sun.CORBA.POA.ORBServerId");
            FileOutputStream fileOutputStream = new FileOutputStream(string + string2 + ".out", true);
            FileOutputStream fileOutputStream2 = new FileOutputStream(string + string2 + ".err", true);
            PrintStream printStream = new PrintStream(fileOutputStream, true);
            PrintStream printStream2 = new PrintStream(fileOutputStream2, true);
            System.setOut(printStream);
            System.setErr(printStream2);
            ServerMain.logInformation("Server started");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerCallback(Class clazz) {
        Method method = this.getNamedMethod(clazz, "install");
        Method method2 = this.getNamedMethod(clazz, "uninstall");
        Method method3 = this.getNamedMethod(clazz, "shutdown");
        Properties properties = new Properties();
        properties.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.internal.iiop.ORB");
        String[] stringArray = null;
        ORB oRB = ORB.init(stringArray, properties);
        ServerCallback serverCallback = new ServerCallback(oRB, method, method2, method3);
        int n2 = this.getServerId();
        try {
            Activator activator = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
            activator.active(n2, serverCallback);
        }
        catch (Exception exception) {
            ServerMain.logTerminal("exception " + exception.getMessage(), 6);
        }
    }

    public static String printResult(int n2) {
        switch (n2) {
            case 0: {
                return "Server terminated normally";
            }
            case 1: {
                return "main class not found";
            }
            case 2: {
                return "no main method";
            }
            case 3: {
                return "application error";
            }
            case 5: {
                return "server ID not defined";
            }
            case 6: {
                return "server registration failed";
            }
        }
        return "unknown error";
    }

    public static void logError(String string) {
        ServerMain.writeLogMessage(System.out, "ERROR:  " + string);
        ServerMain.writeLogMessage(System.err, "ERROR:  " + string);
    }

    public static void logInformation(String string) {
        ServerMain.writeLogMessage(System.out, "        " + string);
    }

    public static void logTerminal(String string, int n2) {
        if (n2 == 0) {
            ServerMain.writeLogMessage(System.out, "        " + string);
        } else {
            ServerMain.writeLogMessage(System.out, "FATAL:  " + ServerMain.printResult(n2) + ": " + string);
            ServerMain.writeLogMessage(System.err, "FATAL:  " + ServerMain.printResult(n2) + ": " + string);
        }
        System.exit(n2);
    }

    public static void main(String[] stringArray) {
        ServerMain serverMain = new ServerMain();
        serverMain.run(stringArray);
    }

    private void run(String[] stringArray) {
        try {
            this.redirectIOStreams();
            String string = System.getProperty("com.sun.CORBA.POA.ORBServerName");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            Class clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName(string, true, classLoader);
            }
            Method method = this.getMainMethod(clazz);
            boolean bl2 = Boolean.getBoolean("com.sun.CORBA.activation.ORBServerVerify");
            if (bl2) {
                if (method == null) {
                    ServerMain.logTerminal("", 2);
                } else {
                    ServerMain.logTerminal("", 0);
                }
            }
            this.registerCallback(clazz);
            Object[] objectArray = new Object[]{stringArray};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ServerMain.logTerminal("ClassNotFound exception: " + classNotFoundException.getMessage(), 1);
        }
        catch (Exception exception) {
            ServerMain.logTerminal("Exception: " + exception.getMessage(), 3);
        }
    }

    private boolean isPublicStaticVoid(Method method) {
        int n2 = method.getModifiers();
        if (!Modifier.isPublic(n2) || !Modifier.isStatic(n2)) {
            ServerMain.logError(method.getName() + " is not public static");
            return false;
        }
        if (method.getExceptionTypes().length != 0) {
            ServerMain.logError(method.getName() + " declares exceptions");
            return false;
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            ServerMain.logError(method.getName() + " does not have a void return type");
            return false;
        }
        return true;
    }

    private static void writeLogMessage(PrintStream printStream, String string) {
        Date date = new Date();
        printStream.print("[" + date.toString() + "] " + string + "\n");
    }

    private Method getMainMethod(Class clazz) {
        Class[] classArray = new Class[]{String;.class};
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("main", classArray);
        }
        catch (Exception exception) {
            ServerMain.logTerminal(exception.getMessage(), 2);
        }
        if (!this.isPublicStaticVoid(method)) {
            ServerMain.logTerminal("", 2);
        }
        return method;
    }

    private Method getNamedMethod(Class clazz, String string) {
        Class[] classArray = new Class[]{ORB.class};
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
        if (!this.isPublicStaticVoid(method)) {
            return null;
        }
        return method;
    }
}

