/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.Observable;
import java.util.Observer;
import latte.Latte;
import latte.action.AbstractLatteAction;
import latte.action.AllAction;
import latte.model.LMChangedEvent;
import latte.view.LVDiagFolder;
import latte.view.LVTree;
import latte.view.LVUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;

public class MainForm
implements Observer {
    private Latte latte_ = null;
    private Display display_ = new Display();
    private Shell shell_ = new Shell(this.display_);
    private SashForm latteForm_ = null;
    private LVTree tree_ = null;
    private Text prop_ = null;
    private LVDiagFolder diagFolder_ = null;

    public MainForm(Latte latte) {
        this.latte_ = latte;
        AbstractLatteAction.setShell(this.shell_);
        this.shell_.setText(AllAction.LATTE_MYSELF.getTitle());
        this.shell_.setImage(AllAction.LATTE_MYSELF.getImage());
        this.shell_.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AllAction.FILE_EXIT.execute(e);
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.shell_.setLayout((Layout)layout);
        this.createMainMenuBar();
        this.createMainCoolBar();
        this.latteForm_ = new SashForm((Composite)this.shell_, 256);
        GridData gridData = new GridData(1808);
        this.latteForm_.setLayoutData((Object)gridData);
        Composite leftView = new Composite((Composite)this.latteForm_, 2048);
        leftView.setLayout((Layout)new FillLayout());
        SashForm leftSash = new SashForm(leftView, 512);
        this.tree_ = new LVTree(this.latte_, (Composite)leftSash);
        this.prop_ = new Text((Composite)leftSash, 770);
        this.diagFolder_ = new LVDiagFolder(this.latte_, (Composite)this.latteForm_);
        this.shell_.open();
    }

    private void createMainCoolBar() {
        CoolBar coolbar = new CoolBar((Composite)this.shell_, 0);
        Control fileToolbar = this.createFileToolBar(coolbar);
        Control editToolbar = this.createEditToolBar(coolbar);
        Control addToolbar = this.createAddToolBar(coolbar);
        LVUtil.createCoolItem(coolbar, fileToolbar);
        LVUtil.createCoolItem(coolbar, editToolbar);
        LVUtil.createCoolItem(coolbar, addToolbar);
    }

    private Control createFileToolBar(CoolBar coolbar) {
        ToolBar toolbar = new ToolBar((Composite)coolbar, 0x800000);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.FILE_NEW);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.FILE_OPEN);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.FILE_SAVE);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.FILE_SAVEAS);
        new ToolItem(toolbar, 2);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.FILE_PRINT);
        return toolbar;
    }

    private Control createEditToolBar(CoolBar coolbar) {
        ToolBar toolbar = new ToolBar((Composite)coolbar, 0x800000);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.EDIT_CUT);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.EDIT_COPY);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.EDIT_PASTE);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.EDIT_DELETE);
        return toolbar;
    }

    private Control createAddToolBar(CoolBar coolbar) {
        ToolBar toolbar = new ToolBar((Composite)coolbar, 0x800000);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.ADD_CLASS_DIAGRAM);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.ADD_SEQUENCE_DIAGRAM);
        new ToolItem(toolbar, 2);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.ADD_PACKAGE);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.ADD_CLASS);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.ADD_INTERFACE);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.ADD_ATTRIBUTE);
        LVUtil.createToolbarItem(toolbar, 8, AllAction.ADD_METHOD);
        return toolbar;
    }

    private void createMainMenuBar() {
        Menu menubar = new Menu((Decorations)this.shell_, 2);
        this.shell_.setMenuBar(menubar);
        Menu fileMenu = LVUtil.createMenu(menubar, "\u30d5\u30a1\u30a4\u30eb");
        LVUtil.createMenuItem(fileMenu, AllAction.FILE_OPEN);
        LVUtil.createMenuItem(fileMenu, AllAction.FILE_SAVE);
        LVUtil.createMenuItem(fileMenu, AllAction.FILE_SAVEAS);
        new MenuItem(fileMenu, 2);
        LVUtil.createMenuItem(fileMenu, AllAction.FILE_PRINT);
        new MenuItem(fileMenu, 2);
        LVUtil.createMenuItem(fileMenu, AllAction.FILE_EXIT);
        Menu editMenu = LVUtil.createMenu(menubar, "\u7de8\u96c6");
        LVUtil.createMenuItem(editMenu, AllAction.EDIT_CUT);
        LVUtil.createMenuItem(editMenu, AllAction.EDIT_COPY);
        LVUtil.createMenuItem(editMenu, AllAction.EDIT_PASTE);
        LVUtil.createMenuItem(editMenu, AllAction.EDIT_DELETE);
        Menu addMenu = LVUtil.createMenu(menubar, "\u8ffd\u52a0");
        LVUtil.createMenuItem(addMenu, AllAction.ADD_CLASS_DIAGRAM);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_SEQUENCE_DIAGRAM);
        new MenuItem(addMenu, 2);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_PACKAGE);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_CLASS);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_INTERFACE);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_ATTRIBUTE);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_METHOD);
        Menu helpMenu = LVUtil.createMenu(menubar, "\u30d8\u30eb\u30d7");
        LVUtil.createMenuItem(helpMenu, AllAction.HELP_DOC);
        LVUtil.createMenuItem(helpMenu, AllAction.HELP_VER);
    }

    public void update(Observable observable, Object event) {
        LMChangedEvent lmce = (LMChangedEvent)event;
        switch (lmce.getChangedType()) {
            case 100: {
                this.shell_.setText("Latte:" + this.latte_.getLatteData().getFile().getAbsolutePath());
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 22: 
            case 23: {
                if (this.latte_.getLatteData().getFile() != null) {
                    this.shell_.setText("Latte:" + this.latte_.getLatteData().getFile().getAbsolutePath());
                }
                this.tree_.updateTree((LMChangedEvent)event);
                this.diagFolder_.updateDiag((LMChangedEvent)event);
            }
        }
    }

    public void run() {
        while (!this.shell_.isDisposed()) {
            if (this.display_.readAndDispatch()) continue;
            this.display_.sleep();
        }
        this.display_.dispose();
    }

    public Text getProp() {
        return this.prop_;
    }

    public Tree getTree() {
        return this.tree_;
    }

    public LVDiagFolder getDiagFolder() {
        return this.diagFolder_;
    }

    public SashForm getLatteForm() {
        return this.latteForm_;
    }

    public Shell getShell() {
        return this.shell_;
    }
}

