/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import latte.action.AbstractLatteAction;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class LVUtil {
    public static final String[] EXTENTION = new String[]{"*.lat", "*.*"};

    public static void createMenuItem(Menu menu, AbstractLatteAction laction) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(laction.getTitle());
        menuItem.setImage(laction.getImage());
        menuItem.addSelectionListener((SelectionListener)laction);
        laction.addListener((Item)menuItem);
    }

    public static Menu createMenu(Menu menuBar, String title) {
        MenuItem menuItem = new MenuItem(menuBar, 64);
        menuItem.setText(title);
        Menu menu = new Menu(menuItem);
        menuItem.setMenu(menu);
        return menu;
    }

    public static void createCoolItem(CoolBar coolbar, Control control) {
        CoolItem coolItem = new CoolItem(coolbar, 8);
        coolItem.setControl(control);
        Point pt = control.computeSize(-1, -1);
        pt = coolItem.computeSize(pt.x, pt.y);
        coolItem.setSize(pt);
    }

    public static void createToolbarItem(ToolBar toolBar, int style, AbstractLatteAction laction, boolean selected) {
        ToolItem item = new ToolItem(toolBar, style);
        item.setImage(laction.getImage());
        item.setToolTipText(laction.getTitle());
        item.addSelectionListener((SelectionListener)laction);
        item.setSelection(selected);
        laction.addListener((Item)item);
    }

    public static void createToolbarItem(ToolBar toolBar, int style, AbstractLatteAction laction) {
        LVUtil.createToolbarItem(toolBar, style, laction, false);
    }
}

